/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.security;

import com.mendmix.security.Cache;
import com.mendmix.security.SecurityConstants;
import com.mendmix.security.cache.LocalCache;
import com.mendmix.security.cache.RedisCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SecurityStorageManager {
    private Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private SecurityConstants.CacheType cacheType;

    protected SecurityStorageManager(SecurityConstants.CacheType cacheType) {
        this.cacheType = cacheType;
    }

    protected void addCahe(String cacheName, int timeToLiveSeconds) {
        Cache cache = null;
        cache = this.cacheType == SecurityConstants.CacheType.redis ? new RedisCache(cacheName, timeToLiveSeconds) : new LocalCache(timeToLiveSeconds);
        this.caches.put(cacheName, cache);
    }

    protected Cache getCache(String cacheName) {
        return this.caches.get(cacheName);
    }
}

