/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.security;

import com.mendmix.common.CurrentRuntimeContext;
import com.mendmix.common.GlobalRuntimeContext;
import com.mendmix.common.model.AuthUser;
import com.mendmix.security.RequestContextAdapter;
import com.mendmix.security.SecurityDecisionProvider;
import com.mendmix.security.SecurityStorageManager;
import com.mendmix.security.context.ReactiveRequestContextAdapter;
import com.mendmix.security.context.ServletRequestContextAdapter;
import com.mendmix.security.model.UserSession;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SecuritySessionManager {
    private static final String PERMISSION_KEY_PREFIX = "permission:";
    private static final String API_ITEM_KEY = "api_%s_%s";
    private static String cacheName = "session";
    private volatile String cookieDomain;
    private String headerTokenName;
    private String sessionIdName;
    private boolean setCookie;
    private boolean keepCookie;
    private int sessionExpireIn = 0;
    private long sessionExpireInMills = 0L;
    private SecurityStorageManager storageManager;
    private RequestContextAdapter requestContextAdapter;

    public SecuritySessionManager(SecurityDecisionProvider decisionProvider, SecurityStorageManager storageManager) {
        this.storageManager = storageManager;
        this.cookieDomain = decisionProvider.cookieDomain();
        this.sessionIdName = decisionProvider.sessionIdName();
        this.headerTokenName = decisionProvider.headerTokenName();
        this.keepCookie = decisionProvider.keepCookie();
        this.sessionExpireIn = decisionProvider.sessionExpireIn();
        this.sessionExpireInMills = this.sessionExpireIn * 1000;
        this.storageManager.addCahe(cacheName, this.sessionExpireIn);
        this.requestContextAdapter = decisionProvider.isServletType() ? new ServletRequestContextAdapter() : new ReactiveRequestContextAdapter();
    }

    public UserSession getLoginSession(String sessionId) {
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            return null;
        }
        return (UserSession)this.storageManager.getCache(cacheName).getObject(sessionId);
    }

    public UserSession getSession() {
        return this.getSession(this.setCookie);
    }

    public UserSession getSession(boolean createIfAbsent) {
        String sessionId = this.getSessionId();
        UserSession session = null;
        if (StringUtils.isNotBlank((CharSequence)sessionId)) {
            session = this.getLoginSession(sessionId);
        }
        if (createIfAbsent && session == null) {
            session = UserSession.create();
            if (sessionId != null && GlobalRuntimeContext.isDevEnv()) {
                session.setSessionId(sessionId);
            }
            int expire = this.keepCookie ? this.sessionExpireIn : -1;
            this.requestContextAdapter.addCookie(this.cookieDomain, this.cookieDomain, session.getSessionId(), expire);
            this.storageLoginSession(session);
        }
        return session;
    }

    public UserSession getLoginSessionByUserId(AuthUser authUser) {
        String key = SecuritySessionManager.buildUserSessionUniqueKey(authUser);
        String sessionId = this.storageManager.getCache(cacheName).getString(key);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            return null;
        }
        return this.getLoginSession(sessionId);
    }

    public void storageLoginSession(UserSession session) {
        String key = session.getSessionId();
        if (!session.isAnonymous()) {
            session.setExpiredAt(System.currentTimeMillis() + this.sessionExpireInMills);
            String uniquekey = SecuritySessionManager.buildUserSessionUniqueKey(session.getUser());
            this.storageManager.getCache(cacheName).setString(uniquekey, session.getSessionId());
        }
        this.storageManager.getCache(cacheName).setObject(key, session);
    }

    public void removeLoginSession(String sessionId) {
        String key = sessionId;
        UserSession session = this.getLoginSession(sessionId);
        if (session != null && !session.isAnonymous()) {
            this.storageManager.getCache(cacheName).remove(key);
            key = SecuritySessionManager.buildUserSessionUniqueKey(session.getUser());
            this.storageManager.getCache(cacheName).remove(key);
        }
    }

    public void updateUserPermissions(UserSession session, List<String> permissions) {
        if (permissions == null) {
            return;
        }
        String key = PERMISSION_KEY_PREFIX + session.getSessionId();
        String field = String.format(API_ITEM_KEY, StringUtils.trimToEmpty((String)session.getSystemId()), StringUtils.trimToEmpty((String)session.getTenanId()));
        this.storageManager.getCache(cacheName).setMapValue(key, field, permissions);
    }

    public List<String> getUserPermissions(UserSession session) {
        String key = PERMISSION_KEY_PREFIX + session.getSessionId();
        String field = String.format(API_ITEM_KEY, StringUtils.trimToEmpty((String)session.getSystemId()), StringUtils.trimToEmpty((String)session.getTenanId()));
        return (List)this.storageManager.getCache(cacheName).getMapValue(key, field);
    }

    public long getUpdateTime(UserSession session) {
        return session.getExpiredAt() - this.sessionExpireInMills;
    }

    public void setSessionAttribute(String name, Object object) {
        String sessionId = this.getSessionId();
        this.storageManager.getCache(cacheName).setMapValue(sessionId, name, object);
    }

    public <T> T getSessionAttribute(String name) {
        String sessionId = this.getSessionId();
        return this.storageManager.getCache(cacheName).getMapValue(sessionId, name);
    }

    public String getSessionId() {
        String sessionId = this.requestContextAdapter.getHeader(this.headerTokenName);
        if (StringUtils.isNotBlank((CharSequence)sessionId) && sessionId.length() >= 32) {
            return sessionId;
        }
        sessionId = this.requestContextAdapter.getCookie(this.sessionIdName);
        return sessionId;
    }

    public void destroySessionAndCookies(UserSession session) {
        if (session == null) {
            return;
        }
        this.removeLoginSession(session.getSessionId());
        this.requestContextAdapter.addCookie(this.cookieDomain, this.cookieDomain, "", 0);
    }

    private static String buildUserSessionUniqueKey(AuthUser authUser) {
        String clientType;
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtils.defaultString((String)authUser.getId(), (String)authUser.getName())).append(":");
        if (CurrentRuntimeContext.getSystemId() != null) {
            builder.append(CurrentRuntimeContext.getSystemId());
        }
        if (StringUtils.isNotBlank((CharSequence)(clientType = CurrentRuntimeContext.getClientType()))) {
            builder.append("_").append(clientType);
        }
        return builder.toString();
    }
}

