/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.security;

import com.mendmix.common.exception.ForbiddenAccessException;
import com.mendmix.common.exception.UnauthorizedException;
import com.mendmix.common.http.HttpMethod;
import com.mendmix.common.util.ResourceUtils;
import com.mendmix.common.util.WebUtils;
import com.mendmix.security.CustomAuthnHandler;
import com.mendmix.security.SecurityDelegating;
import com.mendmix.security.context.ServletRequestContextAdapter;
import com.mendmix.security.model.UserSession;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecurityDelegatingFilter
implements Filter {
    private static final String DOT = ".";
    private static final String MSG_401_UNAUTHORIZED = "{\"code\": 401,\"msg\":\"401 Unauthorized\"}";
    private static String MSG_403_FORBIDDEN = "{\"code\": 403,\"msg\":\"403 Forbidden\"}";
    private static String apiUriSuffix = ResourceUtils.getProperty((String)"api.uri.suffix");
    private CustomAuthnHandler customAuthnHandler;

    public void setAdditionHandler(CustomAuthnHandler customAuthnHandler) {
        this.customAuthnHandler = customAuthnHandler;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (request.getRequestURI().contains(DOT) && (apiUriSuffix == null || !request.getRequestURI().endsWith(apiUriSuffix))) {
            chain.doFilter(req, res);
            return;
        }
        if (request.getMethod().equals(HttpMethod.OPTIONS.name())) {
            chain.doFilter(req, res);
            return;
        }
        ServletRequestContextAdapter.init(request, response);
        if (this.customAuthnHandler != null) {
            this.customAuthnHandler.beforeAuthentication(request);
        }
        UserSession userSession = null;
        try {
            if (this.customAuthnHandler == null || !this.customAuthnHandler.customAuthentication(request)) {
                userSession = SecurityDelegating.doAuthorization(request.getMethod(), request.getRequestURI());
            }
        }
        catch (UnauthorizedException e) {
            if (WebUtils.isAjax((HttpServletRequest)request)) {
                WebUtils.responseOutJson((HttpServletResponse)response, (String)MSG_401_UNAUTHORIZED);
            } else if (SecurityDelegating.decisionProvider().error401Page() == null) {
                response.setStatus(401);
                WebUtils.responseOutHtml((HttpServletResponse)response, (String)"401 Unauthorized");
            } else {
                String loginPage = WebUtils.getBaseUrl((HttpServletRequest)request) + SecurityDelegating.decisionProvider().error401Page();
                response.sendRedirect(loginPage);
            }
            return;
        }
        catch (ForbiddenAccessException e) {
            if (WebUtils.isAjax((HttpServletRequest)request)) {
                WebUtils.responseOutJson((HttpServletResponse)response, (String)MSG_403_FORBIDDEN);
            } else if (SecurityDelegating.decisionProvider().error403Page() == null) {
                response.setStatus(403);
                WebUtils.responseOutHtml((HttpServletResponse)response, (String)"403 Forbidden");
            } else {
                String loginPage = WebUtils.getBaseUrl((HttpServletRequest)request) + SecurityDelegating.decisionProvider().error403Page();
                response.sendRedirect(loginPage);
            }
            return;
        }
        if (this.customAuthnHandler != null) {
            this.customAuthnHandler.afterAuthentication(request, userSession);
        }
        chain.doFilter(req, res);
    }

    public void destroy() {
    }
}

