/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.security;

import com.mendmix.common.CurrentRuntimeContext;
import com.mendmix.common.async.RetryAsyncTaskExecutor;
import com.mendmix.common.async.RetryTask;
import com.mendmix.common.constants.PermissionLevel;
import com.mendmix.common.exception.ForbiddenAccessException;
import com.mendmix.common.exception.UnauthorizedException;
import com.mendmix.common.model.AuthUser;
import com.mendmix.common.util.LogMessageFormat;
import com.mendmix.security.Cache;
import com.mendmix.security.SecurityDecisionProvider;
import com.mendmix.security.SecuritySessionManager;
import com.mendmix.security.SecurityStorageManager;
import com.mendmix.security.event.SessionEventType;
import com.mendmix.security.event.SessionLifeCycleEvent;
import com.mendmix.security.model.ApiPermission;
import com.mendmix.security.model.UserSession;
import com.mendmix.security.util.ApiPermssionHelper;
import com.mendmix.spring.InstanceFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class SecurityDelegating {
    private static Logger logger = LoggerFactory.getLogger((String)"com.mendmix.security");
    private static final int SESSION_INTERVAL_MILLS = 60000;
    private static final String TMP_STATUS_CACHE_NAME = "tmpStatus";
    private SecurityDecisionProvider decisionProvider = (SecurityDecisionProvider)InstanceFactory.getInstance(SecurityDecisionProvider.class);
    private SecuritySessionManager sessionManager;
    private SecurityStorageManager storageManager = new SecurityStorageManager(this.decisionProvider.cacheType());
    private static volatile SecurityDelegating instance;

    private SecurityDelegating() {
        this.sessionManager = new SecuritySessionManager(this.decisionProvider, this.storageManager);
        this.storageManager.addCahe(TMP_STATUS_CACHE_NAME, 60);
        logger.info("MENDMIX-TRACE-LOGGGING-->> SecurityDelegating inited !!,sessisonStorageType:{}", (Object)this.decisionProvider.cacheType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecurityDelegating getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<SecurityDelegating> clazz = SecurityDelegating.class;
        synchronized (SecurityDelegating.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            instance = new SecurityDelegating();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void init() {
        SecurityDelegating.getInstance();
    }

    public static SecurityDecisionProvider decisionProvider() {
        return SecurityDelegating.getInstance().decisionProvider;
    }

    public static UserSession doAuthentication(String name, String password) {
        AuthUser userInfo = SecurityDelegating.getInstance().decisionProvider.validateUser(name, password);
        UserSession session = SecurityDelegating.updateSession(userInfo, true);
        InstanceFactory.getContext().publishEvent((ApplicationEvent)new SessionLifeCycleEvent(SessionEventType.create, session));
        return session;
    }

    public static UserSession updateSession(final AuthUser userInfo, boolean loadPermssion) {
        UserSession otherSession;
        UserSession session = SecurityDelegating.getCurrentSession();
        if (session == null) {
            session = UserSession.create();
        }
        if (session.getSystemId() == null) {
            session.setSystemId(CurrentRuntimeContext.getSystemId());
        }
        session.setTenanId(CurrentRuntimeContext.getTenantId());
        session.setClientType(CurrentRuntimeContext.getClientType());
        session.setUser(userInfo);
        if (SecurityDelegating.getInstance().decisionProvider.kickOff() && (otherSession = SecurityDelegating.getInstance().sessionManager.getLoginSessionByUserId(userInfo)) != null && !otherSession.getSessionId().equals(session.getSessionId())) {
            SecurityDelegating.getInstance().sessionManager.removeLoginSession(otherSession.getSessionId());
        }
        SecurityDelegating.getInstance().sessionManager.storageLoginSession(session);
        if (loadPermssion) {
            final UserSession _session = session;
            if (!userInfo.isAdmin() && SecurityDelegating.getInstance().decisionProvider.apiAuthzEnabled()) {
                CurrentRuntimeContext.setAuthUser((AuthUser)userInfo);
                CurrentRuntimeContext.setSystemId((String)session.getSystemId());
                CurrentRuntimeContext.setTenantId((String)session.getTenanId());
                RetryAsyncTaskExecutor.execute((RetryTask)new RetryTask(){

                    public String traceId() {
                        return LogMessageFormat.buildLogHeader((String)"fetchUserPermissions", (Serializable)((Object)userInfo.getName()));
                    }

                    public boolean process() throws Exception {
                        SecurityDelegating.getInstance().fetchUserPermissions(_session);
                        return true;
                    }
                });
            }
        }
        return session;
    }

    public static UserSession doAuthorization(String method, String uri) throws UnauthorizedException, ForbiddenAccessException {
        List<String> permissions;
        long interval;
        UserSession session = SecurityDelegating.getCurrentSession();
        if (session != null && (interval = System.currentTimeMillis() - SecurityDelegating.getInstance().sessionManager.getUpdateTime(session)) > 60000L) {
            SecurityDelegating.getInstance().sessionManager.storageLoginSession(session);
            InstanceFactory.getContext().publishEvent((ApplicationEvent)new SessionLifeCycleEvent(SessionEventType.renewal, session));
        }
        boolean isAdmin = session != null && session.getUser() != null && session.getUser().isAdmin();
        ApiPermission permissionObject = ApiPermssionHelper.matchPermissionObject(method, uri);
        if ((session == null || session.isAnonymous()) && PermissionLevel.Anonymous != permissionObject.getPermissionLevel()) {
            throw new UnauthorizedException();
        }
        if (session != null) {
            session.setSystemId(CurrentRuntimeContext.getSystemId());
        }
        if (!isAdmin && SecurityDelegating.getInstance().decisionProvider.apiAuthzEnabled() && permissionObject.getPermissionLevel() == PermissionLevel.PermissionRequired && !(permissions = SecurityDelegating.getInstance().getUserPermissions(session)).contains(permissionObject.getPermissionKey())) {
            throw new ForbiddenAccessException();
        }
        return session;
    }

    public static UserSession getAndValidateCurrentSession() {
        UserSession session = SecurityDelegating.getCurrentSession();
        if (session == null || session.isAnonymous()) {
            throw new UnauthorizedException();
        }
        return session;
    }

    public static UserSession getCurrentSession() {
        UserSession session = SecurityDelegating.getInstance().sessionManager.getSession();
        return session;
    }

    public static String getCurrentSessionId() {
        return SecurityDelegating.getInstance().sessionManager.getSessionId();
    }

    public static UserSession genUserSession(String sessionId) {
        return SecurityDelegating.getInstance().sessionManager.getLoginSession(sessionId);
    }

    public static boolean validateSessionId(String sessionId) {
        UserSession session = SecurityDelegating.getInstance().sessionManager.getLoginSession(sessionId);
        return session != null && !session.isAnonymous();
    }

    public static void refreshUserPermssion(Serializable ... userIds) {
        if (userIds == null || userIds.length <= 0 || userIds[1] != null) {
            // empty if block
        }
    }

    public static void doLogout() {
        UserSession session = SecurityDelegating.getCurrentSession();
        if (session == null) {
            return;
        }
        InstanceFactory.getContext().publishEvent((ApplicationEvent)new SessionLifeCycleEvent(SessionEventType.destory, session));
        SecurityDelegating.getInstance().sessionManager.destroySessionAndCookies(session);
    }

    public static void setSessionAttribute(String name, Object object) {
        SecurityDelegating.getInstance().sessionManager.setSessionAttribute(name, object);
    }

    public static <T> T getSessionAttribute(String name) {
        return SecurityDelegating.getInstance().sessionManager.getSessionAttribute(name);
    }

    public static void setTemporaryState(String key, String value) {
        Cache cache = SecurityDelegating.getInstance().storageManager.getCache(TMP_STATUS_CACHE_NAME);
        cache.setString(key, value);
    }

    public static String getTemporaryState(String key) {
        Cache cache = SecurityDelegating.getInstance().storageManager.getCache(TMP_STATUS_CACHE_NAME);
        return cache.getString(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUserPermissions(UserSession session) {
        List<String> permissions = this.sessionManager.getUserPermissions(session);
        if (permissions != null) {
            return permissions;
        }
        SecurityDelegating securityDelegating = SecurityDelegating.getInstance();
        synchronized (securityDelegating) {
            permissions = this.fetchUserPermissions(session);
            return permissions;
        }
    }

    private List<String> fetchUserPermissions(UserSession session) {
        ArrayList<String> permissions;
        List<ApiPermission> apiPermissions = this.decisionProvider.getUserApiPermissions(session.getUser().getId());
        if (apiPermissions == null || apiPermissions.isEmpty()) {
            permissions = new ArrayList<String>(0);
        } else {
            permissions = new ArrayList(apiPermissions.size());
            for (ApiPermission api : apiPermissions) {
                permissions.add(ApiPermssionHelper.buildPermissionKey(api.getMethod(), api.getUri()));
            }
        }
        this.sessionManager.updateUserPermissions(session, permissions);
        return permissions;
    }
}

