/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.security;

import com.mendmix.common.MendmixBaseException;
import com.mendmix.common.model.ApiModel;
import com.mendmix.common.model.AuthUser;
import com.mendmix.common.util.ResourceUtils;
import com.mendmix.security.SecurityConstants;
import com.mendmix.security.model.ApiPermission;
import java.util.ArrayList;
import java.util.List;

public abstract class SecurityDecisionProvider {
    public String sessionIdName() {
        return "JSESSIONID";
    }

    public String headerTokenName() {
        return "Authorization";
    }

    public int sessionExpireIn() {
        return 1800;
    }

    public String cookieDomain() {
        return null;
    }

    public boolean kickOff() {
        return true;
    }

    public boolean keepCookie() {
        return true;
    }

    public boolean oauth2Enabled() {
        return true;
    }

    public boolean apiAuthzEnabled() {
        return true;
    }

    public boolean isServletType() {
        return true;
    }

    public SecurityConstants.CacheType cacheType() {
        if (SecurityConstants.CacheType.redis.name().equals(ResourceUtils.getProperty((String)"security.cache.storage-type"))) {
            return SecurityConstants.CacheType.redis;
        }
        return SecurityConstants.CacheType.local;
    }

    public List<ApiModel> anonymousUris() {
        return new ArrayList<ApiModel>(0);
    }

    public abstract AuthUser validateUser(String var1, String var2) throws MendmixBaseException;

    public abstract List<ApiPermission> getAllApiPermissions();

    public abstract List<ApiPermission> getUserApiPermissions(String var1);

    public abstract String error401Page();

    public abstract String error403Page();
}

