/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.security;

import com.mendmix.common.ThreadLocalContext;
import com.mendmix.common.exception.ForbiddenAccessException;
import com.mendmix.common.exception.UnauthorizedException;
import com.mendmix.common.model.WrapperResponse;
import com.mendmix.common.util.JsonUtils;
import com.mendmix.security.ReactiveCustomAuthnHandler;
import com.mendmix.security.SecurityDelegating;
import com.mendmix.security.context.ReactiveRequestContextAdapter;
import com.mendmix.security.model.UserSession;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ReactiveSecurityDelegatingFilter
implements WebFilter {
    private static Logger logger = LoggerFactory.getLogger((String)"com.mendmix.security");
    private static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    private List<String> matchUriPrefixs;
    private String matchUriPrefix;
    private ReactiveCustomAuthnHandler customAuthnHandler;

    public ReactiveSecurityDelegatingFilter(ReactiveCustomAuthnHandler customAuthnHandler, String ... matchUriPrefixs) {
        this.customAuthnHandler = customAuthnHandler;
        if (matchUriPrefixs.length > 1) {
            this.matchUriPrefixs = Arrays.asList(matchUriPrefixs);
        } else {
            this.matchUriPrefix = matchUriPrefixs[0];
        }
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        try {
            if (this.matchUriPrefix != null && !request.getPath().value().startsWith(this.matchUriPrefix) || this.matchUriPrefixs != null && !this.matchUriPrefixs.stream().anyMatch(o -> request.getPath().value().startsWith((String)o))) {
                return chain.filter(exchange);
            }
            if (request.getMethod().equals((Object)HttpMethod.OPTIONS)) {
                return chain.filter(exchange);
            }
            exchange.getAttributes().clear();
            ReactiveRequestContextAdapter.init(request);
            if (this.customAuthnHandler != null) {
                this.customAuthnHandler.beforeAuthentication(exchange);
            }
            ServerHttpResponse response = exchange.getResponse();
            UserSession userSession = null;
            try {
                if (this.customAuthnHandler == null || !this.customAuthnHandler.customAuthentication(exchange)) {
                    userSession = SecurityDelegating.doAuthorization(request.getMethodValue(), request.getPath().value());
                }
            }
            catch (UnauthorizedException e) {
                if (ReactiveSecurityDelegatingFilter.isAjax(request) || SecurityDelegating.decisionProvider().error401Page() == null) {
                    byte[] bytes = JsonUtils.toJsonBytes((Object)WrapperResponse.fail((Exception)((Object)e)));
                    return response.writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap(bytes)));
                }
                response.getHeaders().setLocation(URI.create(SecurityDelegating.decisionProvider().error401Page()));
                return chain.filter(exchange);
            }
            catch (ForbiddenAccessException e) {
                if (ReactiveSecurityDelegatingFilter.isAjax(request) || SecurityDelegating.decisionProvider().error403Page() == null) {
                    byte[] bytes = JsonUtils.toJsonBytes((Object)WrapperResponse.fail((Exception)((Object)e)));
                    return response.writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap(bytes)));
                }
                response.getHeaders().setLocation(URI.create(SecurityDelegating.decisionProvider().error403Page()));
                return chain.filter(exchange);
            }
            if (this.customAuthnHandler != null) {
                this.customAuthnHandler.afterAuthentication(exchange, userSession);
            }
            return chain.filter(exchange).doFinally(s -> exchange.getAttributes().clear());
        }
        catch (Exception e) {
            logger.error("_global_filter_error", (Throwable)e);
            ThreadLocalContext.unset();
            exchange.getAttributes().clear();
            byte[] bytes = JsonUtils.toJsonBytes((Object)WrapperResponse.fail((Exception)e));
            return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(bytes)));
        }
    }

    private static boolean isAjax(ServerHttpRequest request) {
        return request.getHeaders().containsKey((Object)"x-requested-with") && XML_HTTP_REQUEST.equalsIgnoreCase(request.getHeaders().getFirst("x-requested-with").toString());
    }
}

