/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.workerid;

import com.mendmix.common.GlobalRuntimeContext;
import com.mendmix.common.WorkIdGenerator;
import com.mendmix.common.util.ResourceUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZkWorkIdGenerator
implements WorkIdGenerator,
Watcher {
    private static final String ROOT_PATH = String.format("/applications/%s/%s/nodes", GlobalRuntimeContext.ENV, GlobalRuntimeContext.APPID);
    private ZooKeeper zookeeper = null;
    private volatile List<String> nodeIds;

    public int generate(String nodeId) {
        String zkServers = ResourceUtils.getProperty((String)"application.zookeeper.servers");
        if (StringUtils.isBlank((CharSequence)zkServers)) {
            return 0;
        }
        try {
            this.zookeeper = new ZooKeeper(zkServers, 5000, (Watcher)this);
            Stat stat = this.zookeeper.exists(ROOT_PATH, false);
            if (stat == null) {
                String[] paths = StringUtils.split((String)ROOT_PATH.substring(1), (String)"/");
                String tmpPath = "";
                for (String path : paths) {
                    stat = this.zookeeper.exists(tmpPath = tmpPath + "/" + path, false);
                    if (stat != null) continue;
                    this.zookeeper.create(tmpPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
            }
            this.nodeIds = this.zookeeper.getChildren(ROOT_PATH, true);
            String nodePath = ROOT_PATH + "/" + nodeId;
            if (!this.nodeIds.contains(nodeId)) {
                this.zookeeper.create(nodePath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            }
            while (!this.nodeIds.contains(nodeId)) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception tmpPath) {}
            }
            int workId = this.nodeIds.size();
            return workId;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            try {
                this.nodeIds = this.zookeeper.getChildren(ROOT_PATH, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void close() {
        if (this.zookeeper != null) {
            try {
                this.zookeeper.close();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

