/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.lock.zk;

import com.mendmix.common.util.ResourceUtils;
import com.mendmix.common2.lock.LockException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.Validate;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZkDistributeLock
implements Lock,
Watcher {
    private static final String LOCK_KEY_SUFFIX = "_lk_";
    private static final String ROOT_PATH = "/dlocks";
    private static final int DEFAULT_SESSION_TIMEOUT = 30000;
    private static String zkServers = ResourceUtils.getProperty((String)"mendmix.lock.zkServers");
    private ZooKeeper zk;
    private String lockName;
    private String waitNode;
    private String myZnode;
    private CountDownLatch latch;
    private int sessionTimeout;

    public ZkDistributeLock(String lockName) {
        this(lockName, 30000);
    }

    public ZkDistributeLock(String lockName, int sessionTimeout) {
        Validate.notBlank((CharSequence)zkServers, (String)"config[mendmix.lock.zkServers] not found", (Object[])new Object[0]);
        if (lockName.contains(LOCK_KEY_SUFFIX)) {
            throw new LockException("lockName \u4e0d\u80fd\u5305\u542b[_lk_]");
        }
        this.lockName = lockName;
        this.sessionTimeout = sessionTimeout;
        try {
            this.zk = new ZooKeeper(zkServers, sessionTimeout, (Watcher)this);
            Stat stat = this.zk.exists(ROOT_PATH, false);
            if (stat == null) {
                this.zk.create(ROOT_PATH, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (Exception e) {
            throw new LockException(e);
        }
    }

    public void process(WatchedEvent event) {
        if (this.latch != null && event.getType() == Watcher.Event.EventType.NodeDeleted) {
            this.latch.countDown();
        }
    }

    @Override
    public void lock() {
        try {
            if (this.tryLock()) {
                return;
            }
            this.waitForLock(this.waitNode, this.sessionTimeout);
        }
        catch (KeeperException e) {
            throw new LockException(e);
        }
        catch (InterruptedException e) {
            throw new LockException(e);
        }
    }

    @Override
    public boolean tryLock() {
        try {
            this.myZnode = this.zk.create("/dlocks/" + this.lockName + LOCK_KEY_SUFFIX, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            List subNodes = this.zk.getChildren(ROOT_PATH, false);
            if (subNodes.size() == 1) {
                System.out.println("get lock");
                return true;
            }
            ArrayList<String> lockObjNodes = new ArrayList<String>();
            for (String node : subNodes) {
                if (!node.split(LOCK_KEY_SUFFIX)[0].equals(this.lockName)) continue;
                lockObjNodes.add(node);
            }
            Collections.sort(lockObjNodes);
            if (this.myZnode.equals("/dlocks/" + (String)lockObjNodes.get(0))) {
                return true;
            }
            String subMyZnode = this.myZnode.substring(this.myZnode.lastIndexOf("/") + 1);
            this.waitNode = (String)lockObjNodes.get(Collections.binarySearch(lockObjNodes, subMyZnode) - 1);
        }
        catch (KeeperException e) {
            throw new LockException(e);
        }
        catch (InterruptedException e) {
            throw new LockException(e);
        }
        return false;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) {
        try {
            if (this.tryLock()) {
                return true;
            }
            return this.waitForLock(this.waitNode, time);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean waitForLock(String waitNode, long waitTime) throws InterruptedException, KeeperException {
        Stat stat = this.zk.exists("/dlocks/" + waitNode, true);
        if (stat != null) {
            this.latch = new CountDownLatch(1);
            this.latch.await(waitTime, TimeUnit.MILLISECONDS);
            this.latch = null;
        }
        return true;
    }

    @Override
    public void unlock() {
        try {
            this.zk.delete(this.myZnode, -1);
            this.myZnode = null;
            this.zk.close();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (KeeperException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock();
    }

    @Override
    public Condition newCondition() {
        return null;
    }
}

