/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.lock.redis;

import com.mendmix.cache.redis.JedisProvider;
import com.mendmix.cache.redis.JedisProviderFactory;
import com.mendmix.cache.redis.sentinel.JedisSentinelProvider;
import com.mendmix.cache.redis.standalone.JedisStandaloneProvider;
import com.mendmix.common.util.ResourceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public class RedisLockCoordinator {
    private static final String DLOCK_GROUP_NAME = "_redisLock";
    private static final int HEALTH_CHECK_PERIOD = 30000;
    private static final String REDIS_LOCK_ACTIVE_NODES_KEY = "RedisLockActiveNodes";
    private static final long CLEAN_TIME = TimeUnit.SECONDS.toMillis(90L);
    private static final String SPLIT_STR = "$$";
    private static final String EVENT_NODE_ID = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
    private static String channelName = "redisLockCoordinator";
    private AtomicLong eventIdSeq = new AtomicLong(0L);
    private List<String> activeNodeIds = new ArrayList<String>();
    private ScheduledExecutorService checkerSchedule;
    private Jedis subClient;
    private Map<String, List<String>> getLockEventIds = new ConcurrentHashMap<String, List<String>>();

    public RedisLockCoordinator() {
        String mode = ResourceUtils.getProperty((String)"mendmix.lock.redis.mode", (String)ResourceUtils.getProperty((String)"mendmix.cache.mode", (String)"standalone"));
        String server = ResourceUtils.getProperty((String)"mendmix.lock.redis.servers", (String)ResourceUtils.getProperty((String)"mendmix.cache.servers"));
        String datebase = ResourceUtils.getProperty((String)"mendmix.lock.redis.datebase", (String)ResourceUtils.getProperty((String)"mendmix.cache.datebase", (String)"0"));
        String password = ResourceUtils.getProperty((String)"mendmix.lock.redis.password", (String)ResourceUtils.getProperty((String)"mendmix.cache.password"));
        String maxPoolSize = ResourceUtils.getProperty((String)"mendmix.lock.redis.maxPoolSize", (String)ResourceUtils.getProperty((String)"mendmix.cache.maxPoolSize", (String)"100"));
        Validate.notBlank((CharSequence)server, (String)"config[mendmix.lock.redis.servers] not found", (Object[])new Object[0]);
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(1);
        poolConfig.setMinEvictableIdleTimeMillis(1800000L);
        poolConfig.setMaxTotal(Integer.parseInt(maxPoolSize));
        poolConfig.setMaxWaitMillis(5000L);
        String[] servers = server.split(";|,");
        int timeout = 3000;
        if ("standalone".equals(mode)) {
            JedisStandaloneProvider provider = new JedisStandaloneProvider(DLOCK_GROUP_NAME, poolConfig, servers, timeout, password, Integer.parseInt(datebase), null);
            JedisProviderFactory.addProvider((JedisProvider)provider);
        } else if ("sentinel".equals(mode)) {
            String masterName = ResourceUtils.getProperty((String)"mendmix.lock.redis.masterName", (String)ResourceUtils.getProperty((String)"mendmix.cache.masterName"));
            Validate.notBlank((CharSequence)masterName, (String)"config[mendmix.lock.redis.masterName] not found", (Object[])new Object[0]);
            JedisSentinelProvider provider = new JedisSentinelProvider(DLOCK_GROUP_NAME, poolConfig, servers, timeout, password, Integer.parseInt(datebase), null, masterName);
            JedisProviderFactory.addProvider((JedisProvider)provider);
        }
        Jedis redisClient = this.getRedisClient();
        redisClient.hset(REDIS_LOCK_ACTIVE_NODES_KEY, EVENT_NODE_ID, String.valueOf(System.currentTimeMillis()));
        this.release(redisClient);
        this.activeNodeIds.add(EVENT_NODE_ID);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                RedisLockCoordinator.this.subClient = RedisLockCoordinator.this.getRedisClient();
                RedisLockCoordinator.this.subClient.subscribe((JedisPubSub)new LockStateListener(), new String[]{channelName});
            }
        }, channelName);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkActiveNode() {
        Jedis redisClient = this.getRedisClient();
        try {
            long currentTime = System.currentTimeMillis();
            Map map = redisClient.hgetAll(REDIS_LOCK_ACTIVE_NODES_KEY);
            for (Map.Entry entry : map.entrySet()) {
                if (currentTime - Long.parseLong((String)entry.getValue()) > 30000L) {
                    redisClient.hdel(REDIS_LOCK_ACTIVE_NODES_KEY, new String[]{(String)entry.getKey()});
                    continue;
                }
                redisClient.hset(REDIS_LOCK_ACTIVE_NODES_KEY, (String)entry.getKey(), String.valueOf(currentTime));
            }
            if (!map.containsKey(EVENT_NODE_ID)) {
                redisClient.hset(REDIS_LOCK_ACTIVE_NODES_KEY, EVENT_NODE_ID, String.valueOf(currentTime));
            }
        }
        finally {
            this.release(redisClient);
        }
    }

    public Jedis getRedisClient() {
        Jedis jedis = (Jedis)JedisProviderFactory.getJedisProvider((String)DLOCK_GROUP_NAME).get();
        if (!jedis.isConnected()) {
            jedis.connect();
        }
        return jedis;
    }

    public void release(Jedis jedis) {
        JedisProviderFactory.getJedisProvider((String)DLOCK_GROUP_NAME).release();
    }

    public String buildEvenId() {
        return EVENT_NODE_ID + System.currentTimeMillis() + this.eventIdSeq.incrementAndGet();
    }

    public void notifyNext(Jedis pubClient, String lockName) {
        String nextEventId;
        long currentTimeMillis = System.currentTimeMillis();
        do {
            if (!StringUtils.isBlank((CharSequence)(nextEventId = pubClient.rpop(lockName)))) continue;
            return;
        } while (!this.activeNodeIds.contains(nextEventId.substring(0, 8)) || currentTimeMillis - Long.parseLong(nextEventId.substring(8, 21)) >= CLEAN_TIME);
        pubClient.publish(channelName, lockName + SPLIT_STR + nextEventId);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean await(String lockName, String eventId, long timeoutMills) {
        List<String> eventIds = this.getGetLockEventIds(lockName);
        long start = System.currentTimeMillis();
        int deadLockCheckPoint = 0;
        while (true) {
            try {
                TimeUnit.MILLISECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (eventIds.contains(eventId)) {
                eventIds.remove(eventId);
                return true;
            }
            long useTime = System.currentTimeMillis() - start;
            if (useTime > timeoutMills) {
                return false;
            }
            int useTimeSeconds = (int)(useTime / 1000L);
            if (useTimeSeconds <= 0 || useTimeSeconds <= deadLockCheckPoint) continue;
            deadLockCheckPoint = useTimeSeconds;
            if (JedisProviderFactory.getJedisCommands((String)DLOCK_GROUP_NAME).llen(lockName) == 0L) return false;
            continue;
            break;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getGetLockEventIds(String lockName) {
        List<String> eventIds = this.getLockEventIds.get(lockName);
        if (eventIds == null) {
            Map<String, List<String>> map = this.getLockEventIds;
            synchronized (map) {
                eventIds = this.getLockEventIds.get(lockName);
                if (eventIds == null) {
                    eventIds = new Vector<String>();
                    this.getLockEventIds.put(lockName, eventIds);
                }
            }
        }
        return eventIds;
    }

    @PreDestroy
    public void close() {
        try {
            this.subClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.checkerSchedule != null) {
            this.checkerSchedule.shutdown();
        }
    }

    public static void main(String[] args) {
        System.out.println(500);
        System.out.println(1);
    }

    private class LockStateListener
    extends JedisPubSub {
        public void onMessage(String channel, String message) {
            super.onMessage(channel, message);
            if (StringUtils.isBlank((CharSequence)message)) {
                return;
            }
            String[] parts = StringUtils.splitByWholeSeparator((String)message, (String)RedisLockCoordinator.SPLIT_STR);
            String lockName = parts[0];
            String nextEventId = parts[1];
            if (!nextEventId.startsWith(EVENT_NODE_ID)) {
                return;
            }
            RedisLockCoordinator.this.getGetLockEventIds(lockName).add(nextEventId);
        }
    }
}

