/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.lock.redis;

import com.mendmix.common2.lock.LockException;
import com.mendmix.common2.lock.redis.RedisLockCoordinator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import redis.clients.jedis.Jedis;

public class RedisDistributeLockV2
implements Lock {
    private static RedisLockCoordinator coordinator = new RedisLockCoordinator();
    private static final String LOCK_KEY_PREFIX = "dlock:";
    private static final int _DEFAULT_MAX_WAIT = 30;
    private static final int _DEFAULT_MAX_WAIT_LIMIT = 20;
    private String lockName;
    private String eventId;
    private int maxWaitLimt;
    private int timeoutSeconds;
    private int maxLiveSeconds;
    private Jedis client;

    public RedisDistributeLockV2(String lockName) {
        this(lockName, 30, 20);
    }

    public RedisDistributeLockV2(String lockName, int timeoutSeconds) {
        this(lockName, timeoutSeconds, 20);
    }

    public RedisDistributeLockV2(String lockName, int timeoutSeconds, int maxWaitLimt) {
        this.lockName = LOCK_KEY_PREFIX + lockName;
        this.timeoutSeconds = timeoutSeconds;
        this.maxLiveSeconds = timeoutSeconds + 1;
        this.eventId = coordinator.buildEvenId();
        this.maxWaitLimt = maxWaitLimt;
    }

    @Override
    public void lock() {
        try {
            this.tryLock(this.timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(0L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        boolean getLock = true;
        this.client = coordinator.getRedisClient();
        try {
            Long waitCount = this.client.lpush(this.lockName, new String[]{this.eventId});
            this.client.expire(this.lockName, this.maxLiveSeconds);
            if (waitCount == 1L) {
                boolean bl = getLock;
                return bl;
            }
            if (waitCount > (long)this.maxWaitLimt) {
                getLock = false;
                throw new LockException(String.format("Lock[%s] Too many wait", this.lockName));
            }
            if (timeout == 0L) {
                boolean bl = getLock = false;
                return bl;
            }
            getLock = coordinator.await(this.lockName, this.eventId, unit.toMillis(timeout));
            if (!getLock) {
                throw new LockException(String.format("Lock[%s] Timeout", this.lockName));
            }
            boolean bl = getLock;
            return bl;
        }
        finally {
            if (!getLock) {
                this.client.lrem(this.lockName, 1L, this.eventId);
            }
        }
    }

    @Override
    public void unlock() {
        if (this.client == null) {
            throw new LockException("cant't unlock,because Lock not found");
        }
        try {
            this.client.lrem(this.lockName, 1L, this.eventId);
            coordinator.notifyNext(this.client, this.lockName);
        }
        finally {
            if (this.client != null) {
                coordinator.release(this.client);
            }
        }
    }

    @Override
    public Condition newCondition() {
        return null;
    }
}

