/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.lock.redis;

import com.mendmix.cache.CacheUtils;
import com.mendmix.cache.RedisTemplateGroups;
import com.mendmix.common.MendmixBaseException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;

public class RedisDistributeLock {
    private static final String KEY_PREFIX = "_dlock:";
    private static StringRedisTemplate stringRedisTemplate;
    private static String getLockLua;
    DefaultRedisScript<Long> lockScript = new DefaultRedisScript(getLockLua, Long.class);
    private static final long _DEFAULT_MAX_WAIT = 60000L;
    private String lockName;
    private long maxLiveMillis;

    private static StringRedisTemplate getRedisTemplate() {
        if (stringRedisTemplate != null) {
            return stringRedisTemplate;
        }
        if (stringRedisTemplate == null && CacheUtils.isRedis()) {
            try {
                stringRedisTemplate = RedisTemplateGroups.getDefaultStringRedisTemplate();
            }
            catch (Exception exception) {}
        } else {
            List groupNames = RedisTemplateGroups.getRedisTemplateGroupNames();
            if (groupNames.size() > 0) {
                try {
                    stringRedisTemplate = RedisTemplateGroups.getStringRedisTemplate((String)((String)groupNames.get(0)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return stringRedisTemplate;
    }

    public RedisDistributeLock(String resKey) {
        this(resKey, 60000L);
    }

    public RedisDistributeLock(String resKey, long maxLiveMillis) {
        this.lockName = KEY_PREFIX.concat(resKey);
        this.maxLiveMillis = maxLiveMillis;
    }

    public void lock() {
        boolean locked = this.tryLock(this.maxLiveMillis, TimeUnit.MILLISECONDS);
        if (!locked) {
            this.unlock();
            throw new MendmixBaseException("Lock[" + this.lockName + "] timeout");
        }
    }

    public boolean tryLock() {
        if (RedisDistributeLock.getRedisTemplate() == null) {
            return true;
        }
        Long result = (Long)stringRedisTemplate.execute(this.lockScript, Arrays.asList(this.lockName), new Object[]{String.valueOf(this.maxLiveMillis)});
        return result != null && result == 1L;
    }

    public boolean tryLock(long time, TimeUnit unit) {
        long start = System.currentTimeMillis();
        boolean res = this.tryLock();
        if (res) {
            return res;
        }
        long sleep = 100L;
        while (!res) {
            try {
                TimeUnit.MILLISECONDS.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            res = this.tryLock();
            if (res) {
                return res;
            }
            if (sleep > 20L) {
                sleep -= 10L;
            }
            if (System.currentTimeMillis() - start <= unit.toMillis(time)) continue;
            return false;
        }
        return false;
    }

    public boolean isIdle() {
        if (RedisDistributeLock.getRedisTemplate() == null) {
            return true;
        }
        return stringRedisTemplate.hasKey((Object)this.lockName) == false;
    }

    public long blockUtilIdle(long time, TimeUnit unit) {
        if (this.isIdle()) {
            return 0L;
        }
        long start = System.currentTimeMillis();
        boolean idle = false;
        long sleep = 100L;
        while (!idle) {
            try {
                TimeUnit.MILLISECONDS.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            idle = this.isIdle();
            if (idle) {
                return System.currentTimeMillis() - start;
            }
            if (sleep > 20L) {
                sleep -= 10L;
            }
            if (System.currentTimeMillis() - start <= unit.toMillis(time)) continue;
            return System.currentTimeMillis() - start;
        }
        return 0L;
    }

    public void unlock() {
        if (RedisDistributeLock.getRedisTemplate() == null) {
            return;
        }
        stringRedisTemplate.delete((Object)this.lockName);
    }

    static {
        getLockLua = "local res = redis.call('setnx', KEYS[1],'1')\nif tonumber(res) > 0 then\n\tredis.call('PEXPIRE', KEYS[1], ARGV[1])\n\treturn 1\nelse \n\treturn 0\nend";
    }
}

