/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.jdbc;

import com.mendmix.common.util.BeanUtils;
import com.mendmix.common.util.StringConverter;
import com.mendmix.common2.jdbc.DataSourceGroups;
import com.mendmix.common2.jdbc.ResultConverter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class JdbcExecutor {
    private static JdbcExecutor defaultExecutor;
    private DataSource dataSource;

    public JdbcExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JdbcExecutor getDefaultExecutor() {
        if (defaultExecutor != null) {
            return defaultExecutor;
        }
        Class<JdbcExecutor> clazz = JdbcExecutor.class;
        synchronized (JdbcExecutor.class) {
            if (defaultExecutor != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return defaultExecutor;
            }
            defaultExecutor = new JdbcExecutor(DataSourceGroups.getDefaultDataSource());
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultExecutor;
        }
    }

    public Connection getconnnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public int insert(String sql, Object[] args) {
        return this.execute(sql, args);
    }

    public int delete(String sql, Object[] args) {
        return this.execute(sql, args);
    }

    public int update(String sql, Object[] args) {
        return this.execute(sql, args);
    }

    public int execute(String sql, Object[] args) {
        int result = 0;
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getconnnection();
            ps = con.prepareStatement(sql);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    ps.setObject(i + 1, args[i]);
                }
            }
            result = ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.close(null, ps, con);
        }
        return result;
    }

    public Map<String, Object> queryForMap(String sql, Object[] args) {
        Map<String, Object> result = new HashMap<String, Object>();
        List<Map<String, Object>> list = this.queryForList(sql, args);
        if (list.size() > 0) {
            result = list.get(0);
        }
        return result;
    }

    public <T> T queryForObject(String sql, Object[] args, Class<T> clazz) {
        Object result = BeanUtils.mapToBean(this.queryForMap(sql, args), clazz);
        return (T)result;
    }

    public List<Map<String, Object>> queryForList(String sql, Object[] args) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            con = this.getconnnection();
            ps = con.prepareStatement(sql);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    ps.setObject(i + 1, args[i]);
                }
            }
            rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    Object value = rs.getObject(i);
                    if (value instanceof LocalDateTime) {
                        value = Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
                    }
                    map.put(StringConverter.toCamelCase((String)rsmd.getColumnLabel(i)), value);
                }
                result.add(map);
            }
            this.close(rs, ps, con);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, ps, con);
                throw throwable;
            }
        }
        return result;
    }

    public <T> List<T> queryForList(String sql, Object[] args, ResultConverter<T> converter) {
        ArrayList<T> result = new ArrayList<T>();
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            con = this.getconnnection();
            ps = con.prepareStatement(sql);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    ps.setObject(i + 1, args[i]);
                }
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(converter.convert(rs));
            }
            this.close(rs, ps, con);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, ps, con);
                throw throwable;
            }
        }
        return result;
    }

    public <T> List<T> queryForList(String sql, Object[] args, Class<T> clazz) {
        List<Map<String, Object>> mapList = this.queryForList(sql, args);
        ArrayList<Object> result = new ArrayList<Object>(mapList.size());
        for (Map<String, Object> map : mapList) {
            result.add(BeanUtils.mapToBean(map, clazz));
        }
        return result;
    }

    public long queryForCount(String sql, Object[] args) {
        PreparedStatement ps;
        ResultSet rs;
        Connection con;
        block7: {
            con = null;
            rs = null;
            ps = null;
            con = this.getconnnection();
            ps = con.prepareStatement(sql);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    ps.setObject(i + 1, args[i]);
                }
            }
            if (!(rs = ps.executeQuery()).next()) break block7;
            long i = rs.getLong(1);
            this.close(rs, ps, con);
            return i;
        }
        try {
            long i = 0L;
            this.close(rs, ps, con);
            return i;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, ps, con);
                throw throwable;
            }
        }
    }

    public String queryForString(String sql, Object[] args) {
        PreparedStatement ps;
        ResultSet rs;
        Connection con;
        block7: {
            con = null;
            rs = null;
            ps = null;
            con = this.getconnnection();
            ps = con.prepareStatement(sql);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    ps.setObject(i + 1, args[i]);
                }
            }
            if (!(rs = ps.executeQuery()).next()) break block7;
            String i = rs.getString(1);
            this.close(rs, ps, con);
            return i;
        }
        try {
            String i = null;
            this.close(rs, ps, con);
            return i;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, ps, con);
                throw throwable;
            }
        }
    }

    public void close(ResultSet rs, Statement st, Connection con) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

