/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.jdbc;

import com.alibaba.druid.pool.DruidDataSource;
import com.mendmix.common.MendmixBaseException;
import com.mendmix.common.util.ResourceUtils;
import com.mendmix.common.util.SimpleCryptUtils;
import com.mendmix.spring.InstanceFactory;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class DataSourceGroups {
    private static DataSource defaultDataSource;
    private static Map<String, DataSource> groupDataSources;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource getDefaultDataSource() {
        if (defaultDataSource != null) {
            return defaultDataSource;
        }
        Class<DataSourceGroups> clazz = DataSourceGroups.class;
        synchronized (DataSourceGroups.class) {
            Map map = InstanceFactory.getBeansOfType(DataSource.class);
            if (map.isEmpty()) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            defaultDataSource = map.size() == 1 ? (DataSource)map.values().stream().findFirst().get() : (DataSource)map.get("defaultDataSource");
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultDataSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource getDataSource(String group) {
        if (groupDataSources.containsKey(group)) {
            return groupDataSources.get(group);
        }
        if (!ResourceUtils.containsProperty((String)(group + ".dataSource.url"))) {
            throw new MendmixBaseException("\u672a\u627e\u5230[" + group + "]\u6570\u636e\u5e93\u914d\u7f6e");
        }
        Map<String, DataSource> map = groupDataSources;
        synchronized (map) {
            if (groupDataSources.containsKey(group)) {
                return groupDataSources.get(group);
            }
            DruidDataSource dataSource = new DruidDataSource();
            dataSource.setDriverClassName(ResourceUtils.getProperty((String)(group + ".dataSource.driverClassName"), (String)"com.mysql.cj.jdbc.Driver"));
            dataSource.setUrl(ResourceUtils.getProperty((String)(group + ".dataSource.url")));
            dataSource.setUsername(ResourceUtils.getAndValidateProperty((String)(group + ".dataSource.username")));
            String password = ResourceUtils.getAndValidateProperty((String)(group + ".dataSource.password"));
            if (password.startsWith("{Cipher}")) {
                password = SimpleCryptUtils.decrypt((String)password.replace("{Cipher}", ""));
            }
            dataSource.setPassword(password);
            dataSource.setMaxActive(ResourceUtils.getInt((String)(group + ".dataSource.maxActive"), (int)2));
            dataSource.setMinIdle(1);
            dataSource.setDefaultAutoCommit(true);
            dataSource.setTestOnBorrow(true);
            try {
                dataSource.init();
            }
            catch (SQLException e) {
                dataSource.close();
                throw new RuntimeException(e);
            }
            groupDataSources.put(group, (DataSource)dataSource);
            return dataSource;
        }
    }

    public static void close() {
        Collection<DataSource> dataSources = groupDataSources.values();
        for (DataSource dataSource : dataSources) {
            try {
                ((DruidDataSource)dataSource).close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        groupDataSources = new HashMap<String, DataSource>();
    }
}

