/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.jdbc;

import com.mendmix.common.MendmixBaseException;
import com.mendmix.common.util.StringConverter;
import com.mendmix.common2.jdbc.JdbcExecParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Condition {
    private static final String IS_NOT_NULL = "isNotNull";
    private static final String IS_NULL = "isNull";
    private static final List<String> OPERATORS = Arrays.asList("<>", "<=", "<", ">=", ">", "=", "IN", "isNull", "isNotNull");
    private String operator;
    private String column;
    private String value;

    public Condition() {
    }

    public Condition(String column, String operator, String value) {
        this.column = column;
        this.operator = operator;
        this.value = value;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static JdbcExecParam buildJdbcExecObject(String select, List<Condition> conditions, boolean camelToUnderscoreCase) {
        if (conditions == null || conditions.isEmpty()) {
            throw new MendmixBaseException("\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder builder = new StringBuilder(select);
        ArrayList<String> params = new ArrayList<String>();
        boolean withWhere = select.toUpperCase().contains("WHERE");
        if (!withWhere) {
            builder.append(" ").append("WHERE");
        } else {
            builder.append(" ").append("AND");
        }
        for (int i = 0; i < conditions.size(); ++i) {
            String column;
            Condition condition = conditions.get(i);
            if (!OPERATORS.contains(condition.getOperator())) {
                throw new MendmixBaseException("\u4e0d\u652f\u6301\u64cd\u4f5c\u7b26:" + condition.getOperator());
            }
            String string = column = camelToUnderscoreCase ? StringConverter.toUnderlineCase((String)condition.getColumn()) : condition.getColumn();
            if (i > 0) {
                builder.append(" ").append("AND");
            }
            builder.append(" ").append(column);
            if (IS_NULL.equals(condition.getOperator())) {
                builder.append(" IS NULL");
                continue;
            }
            if (IS_NOT_NULL.equals(condition.getOperator())) {
                builder.append(" IS NOT NULL");
                continue;
            }
            builder.append(condition.getOperator()).append("?");
            params.add(condition.getValue());
        }
        return new JdbcExecParam(builder.toString(), params.toArray());
    }
}

