/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.excel.model;

import com.mendmix.common2.excel.model.TitleMeta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ExcelMeta {
    private Class<?> beanClass;
    private int titleRowNum;
    private List<TitleMeta> titleCells;
    private String[] titles;
    private TitleMeta[][] titleMetaArray;

    public ExcelMeta(Class<?> beanClass, List<TitleMeta> titleCells, int titleRowNum) {
        List<TitleMeta> children;
        TitleMeta tit;
        int i;
        this.beanClass = beanClass;
        this.titleCells = titleCells;
        this.titleRowNum = titleRowNum;
        Comparator<TitleMeta> comparator = new Comparator<TitleMeta>(){

            @Override
            public int compare(TitleMeta o1, TitleMeta o2) {
                return o1.getColumnIndex() - o2.getColumnIndex();
            }
        };
        Collections.sort(titleCells, comparator);
        ArrayList<String> titleList = new ArrayList<String>();
        for (i = 0; i < titleCells.size(); ++i) {
            tit = titleCells.get(i);
            if (tit.getChildren().isEmpty()) {
                titleList.add(tit.getTitle());
                continue;
            }
            children = tit.getChildren();
            Collections.sort(children, comparator);
            for (TitleMeta titleCell : children) {
                titleList.add(titleCell.getTitle());
            }
        }
        this.titles = titleList.toArray(new String[0]);
        this.titleMetaArray = new TitleMeta[titleRowNum][this.getTitleColumnNum()];
        for (i = 0; i < titleCells.size(); ++i) {
            this.titleMetaArray[tit.getRowIndex() - 1][tit.getColumnIndex() - 1] = tit = titleCells.get(i);
            children = tit.getChildren();
            Iterator<TitleMeta> iterator = children.iterator();
            while (iterator.hasNext()) {
                TitleMeta titleCell;
                this.titleMetaArray[titleCell.getRowIndex() - 1][titleCell.getColumnIndex() - 1] = titleCell = iterator.next();
                this.titleMetaArray[titleCell.getRowIndex() - 2][titleCell.getColumnIndex() - 1] = tit;
            }
        }
        for (i = 0; i < titleRowNum; ++i) {
            for (int j = 0; j < this.getTitleColumnNum(); ++j) {
                TitleMeta titleMeta = this.titleMetaArray[i][j];
                if (titleMeta != null) continue;
                this.titleMetaArray[i][j] = this.titleMetaArray[i - 1][j];
            }
        }
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public int getTitleRowNum() {
        return this.titleRowNum;
    }

    public List<TitleMeta> getTitleCells() {
        return this.titleCells;
    }

    public String[] getFinalTitles() {
        return this.titles;
    }

    public int getTitleColumnNum() {
        return this.titles.length;
    }

    public TitleMeta getTitleMeta(int row, int column) {
        TitleMeta meta = this.titleMetaArray[row - 1][column - 1];
        return meta;
    }
}

