/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.excel.helper;

import com.mendmix.common2.excel.ExcelOperBaseException;
import com.mendmix.common2.excel.annotation.TitleCell;
import com.mendmix.common2.excel.model.ExcelMeta;
import com.mendmix.common2.excel.model.TitleMeta;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class ExcelBeanHelper {
    private static Map<String, Map<String, PropertyDescriptor>> aliasPropertyDescriptorCache = new ConcurrentHashMap<String, Map<String, PropertyDescriptor>>();
    private static Map<String, ExcelMeta> titleCellBeanCache = new ConcurrentHashMap<String, ExcelMeta>();

    public static <T> List<T> setRowValues(Class<T> clazz, List<String> contents) {
        try {
            int i;
            Map<String, PropertyDescriptor> pds = ExcelBeanHelper.getAliasPropertyDescriptors(clazz);
            ArrayList<T> results = new ArrayList<T>();
            if (contents.isEmpty()) {
                return results;
            }
            String[] titles = ExcelBeanHelper.getExcelMeta(clazz).getFinalTitles();
            int titleRowCount = ExcelBeanHelper.getExcelMeta(clazz).getTitleRowNum();
            ArrayList<String> contentTitles = new ArrayList<String>();
            for (i = 1; i <= titleRowCount; ++i) {
                contentTitles.addAll(Arrays.asList(contents.get(i).split("-@-")));
            }
            for (i = 0; i < titles.length; ++i) {
                if (!(titleRowCount == 1 ? !StringUtils.equals((CharSequence)titles[i], (CharSequence)((CharSequence)contentTitles.get(i))) : !contentTitles.contains(titles[i]))) continue;
                throw new ExcelOperBaseException("\u683c\u5f0f\u9519\u8bef\uff0c\u6ca1\u6709\u627e\u5230\u5217[" + titles[i] + "]");
            }
            String[] vals = null;
            for (int i2 = titleRowCount + 1; i2 < contents.size(); ++i2) {
                String line = contents.get(i2);
                if (line.startsWith("{sheet}:")) {
                    throw new ExcelOperBaseException("\u6a21\u677f\u9519\u8bef(\u6682\u4e0d\u652f\u6301\u591a\u4e2asheet)");
                }
                T instance = clazz.newInstance();
                vals = line.split("-@-");
                boolean anyColumnNotEmpty = false;
                for (int j = 0; j < titles.length && vals.length >= j + 1; ++j) {
                    anyColumnNotEmpty = anyColumnNotEmpty || StringUtils.isNotBlank((CharSequence)vals[j]);
                    PropertyDescriptor propertyDescriptor = pds.get(ExcelBeanHelper.clearWrapper(titles[j]).trim());
                    if (propertyDescriptor == null || vals[j] == null) continue;
                    try {
                        Object rawValue = ExcelBeanHelper.rawValue(vals[j], propertyDescriptor.getPropertyType());
                        propertyDescriptor.getWriteMethod().invoke(instance, rawValue);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!anyColumnNotEmpty) continue;
                results.add(instance);
            }
            return results;
        }
        catch (Exception e) {
            if (e instanceof ExcelOperBaseException) {
                throw (ExcelOperBaseException)e;
            }
            throw new BeanConverterException(e);
        }
    }

    public static <T> List<Object[]> beanToExcelValueArrays(List<T> datas, Class<T> clazz) {
        Map<String, PropertyDescriptor> pds = ExcelBeanHelper.getAliasPropertyDescriptors(clazz);
        ArrayList<Object[]> result = new ArrayList<Object[]>(datas.size() + 1);
        String[] titles = ExcelBeanHelper.getExcelMeta(clazz).getFinalTitles();
        if (datas == null || datas.isEmpty()) {
            return result;
        }
        int valNums = titles.length;
        for (T e : datas) {
            Object[] valArrs = new Object[valNums];
            try {
                for (int i = 0; i < titles.length; ++i) {
                    PropertyDescriptor descriptor = pds.get(titles[i]);
                    if (descriptor == null) continue;
                    valArrs[i] = descriptor.getReadMethod().invoke(e, new Object[0]);
                }
                result.add(valArrs);
            }
            catch (Exception e2) {
                throw new BeanConverterException(e2);
            }
        }
        return result;
    }

    public static ExcelMeta getExcelMeta(Class<?> clazz) {
        String key = clazz.getCanonicalName();
        if (!titleCellBeanCache.containsKey(key)) {
            ExcelBeanHelper.getAliasPropertyDescriptors(clazz);
        }
        return titleCellBeanCache.get(key);
    }

    private static Object rawValue(String value, Class<?> propertyType) {
        value = ExcelBeanHelper.clearWrapper(value);
        Object result = value;
        if (propertyType == String.class) {
            return result;
        }
        if (propertyType == BigDecimal.class) {
            result = new BigDecimal(value.replaceAll(",", ""));
        } else if (propertyType == Byte.TYPE || propertyType == Byte.class) {
            result = Byte.valueOf(value);
        } else if (propertyType == Short.TYPE || propertyType == Short.class) {
            result = Short.valueOf(value.replaceAll(",", ""));
        } else if (propertyType == Integer.TYPE || propertyType == Integer.class) {
            result = Integer.parseInt(value.replaceAll(",", ""));
        } else if (propertyType == Double.TYPE || propertyType == Double.class) {
            result = Double.valueOf(value.replaceAll(",", ""));
        } else if (propertyType == Float.TYPE || propertyType == Float.class) {
            result = Float.valueOf(Float.parseFloat(value.replaceAll(",", "")));
        } else if (propertyType == Date.class) {
            if (value != null) {
                // empty if block
            }
        } else if (propertyType == Boolean.TYPE || propertyType == Boolean.class) {
            result = Boolean.parseBoolean(value);
        }
        return result;
    }

    private static Map<String, PropertyDescriptor> getAliasPropertyDescriptors(Class<?> clazz) {
        try {
            String canonicalName = clazz.getCanonicalName();
            Map<String, PropertyDescriptor> map = aliasPropertyDescriptorCache.get(canonicalName);
            if (map == null) {
                ExcelBeanHelper.doCacheClass(clazz, canonicalName);
                map = aliasPropertyDescriptorCache.get(canonicalName);
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized void doCacheClass(Class<?> clazz, String canonicalName) throws Exception {
        if (aliasPropertyDescriptorCache.containsKey(canonicalName)) {
            return;
        }
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        HashMap<String, PropertyDescriptor> aliasMap = new HashMap<String, PropertyDescriptor>();
        ArrayList<TitleMeta> titleMetas = new ArrayList<TitleMeta>();
        BeanInfo srcBeanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] descriptors = srcBeanInfo.getPropertyDescriptors();
        HashMap<String, TitleMeta> parentMap = new HashMap<String, TitleMeta>();
        int maxRow = 1;
        for (PropertyDescriptor descriptor : descriptors) {
            String name = descriptor.getName();
            if ("class".equals(name)) continue;
            Method readMethod = descriptor.getReadMethod();
            Method writeMethod = descriptor.getWriteMethod();
            if (readMethod == null) {
                try {
                    readMethod = clazz.getMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
                    descriptor.setReadMethod(readMethod);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (writeMethod == null) {
                try {
                    writeMethod = clazz.getMethod("set" + name.substring(0, 1).toUpperCase() + name.substring(1), descriptor.getPropertyType());
                    descriptor.setWriteMethod(writeMethod);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (readMethod == null && writeMethod == null) continue;
            map.put(descriptor.getName(), descriptor);
            TitleCell annotation = null;
            try {
                annotation = clazz.getDeclaredField(name).getAnnotation(TitleCell.class);
            }
            catch (NoSuchFieldException e) {
                annotation = clazz.getSuperclass().getDeclaredField(name).getAnnotation(TitleCell.class);
            }
            if (annotation == null) continue;
            aliasMap.put(annotation.name().trim(), descriptor);
            TitleMeta cell = new TitleMeta(annotation.name());
            cell.setValueType(annotation.type());
            if (StringUtils.isBlank((CharSequence)annotation.parentName())) {
                cell.setColumnIndex(annotation.column());
                cell.setRowIndex(annotation.row());
                titleMetas.add(cell);
                continue;
            }
            TitleMeta cellParent = (TitleMeta)parentMap.get(annotation.parentName());
            if (cellParent == null) {
                cellParent = new TitleMeta(annotation.parentName());
                cellParent.setValueType(annotation.type());
                cellParent.setColumnIndex(annotation.column());
                parentMap.put(annotation.parentName(), cellParent);
                titleMetas.add(cellParent);
            }
            cell.setColumnIndex(annotation.column());
            cell.setRowIndex(annotation.row());
            cellParent.addChildren(cell);
            maxRow = annotation.row() > maxRow ? annotation.row() : maxRow;
        }
        ExcelMeta excelMeta = new ExcelMeta(clazz, titleMetas, maxRow);
        titleCellBeanCache.put(canonicalName, excelMeta);
        aliasPropertyDescriptorCache.put(canonicalName, aliasMap);
    }

    private static String clearWrapper(String orig) {
        return orig;
    }

    public static class BeanConverterException
    extends RuntimeException {
        private static final long serialVersionUID = 152873897614690397L;

        public BeanConverterException(Throwable cause) {
            super(cause);
        }
    }
}

