/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.excel.convert;

import com.mendmix.common2.excel.helper.ExcelValidator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.SAXHelper;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XLSX2CSV {
    private List<String> results = new ArrayList<String>();
    private StringBuilder _resultRowTmp = new StringBuilder();
    private int blankRowNum = 0;
    private final OPCPackage xlsxPackage;
    private final int minColumns;

    public XLSX2CSV(OPCPackage pkg, PrintStream output, int minColumns) {
        this.xlsxPackage = pkg;
        this.minColumns = minColumns;
    }

    public void processSheet(StylesTable styles, ReadOnlySharedStringsTable strings, XSSFSheetXMLHandler.SheetContentsHandler sheetHandler, InputStream sheetInputStream) throws IOException, ParserConfigurationException, SAXException {
        DataFormatter formatter = new DataFormatter();
        InputSource sheetSource = new InputSource(sheetInputStream);
        try {
            XMLReader sheetParser = SAXHelper.newXMLReader();
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(styles, null, strings, sheetHandler, formatter, false);
            sheetParser.setContentHandler((ContentHandler)handler);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    public List<String> process() throws IOException, OpenXML4JException, ParserConfigurationException, SAXException {
        ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(this.xlsxPackage);
        XSSFReader xssfReader = new XSSFReader(this.xlsxPackage);
        StylesTable styles = xssfReader.getStylesTable();
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        int index = 0;
        while (iter.hasNext() && this.blankRowNum != 10) {
            InputStream stream = iter.next();
            String sheetName = iter.getSheetName();
            this.results.add("{sheet}:" + sheetName);
            this.processSheet(styles, strings, new SheetToCSV(), stream);
            stream.close();
            ++index;
        }
        return this.results;
    }

    private class SheetToCSV
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private boolean firstCellOfRow = false;
        private int currentRow = -1;
        private int currentCol = -1;

        private SheetToCSV() {
        }

        private void outputMissingRows(int number) {
            for (int i = 0; i < number; ++i) {
                for (int j = 0; j < XLSX2CSV.this.minColumns; ++j) {
                    XLSX2CSV.this._resultRowTmp.append("-@-");
                }
            }
        }

        public void startRow(int rowNum) {
            this.outputMissingRows(rowNum - this.currentRow - 1);
            this.firstCellOfRow = true;
            this.currentRow = rowNum;
            this.currentCol = -1;
        }

        public void endRow(int rowNum) {
            for (int i = this.currentCol; i < XLSX2CSV.this.minColumns; ++i) {
                XLSX2CSV.this._resultRowTmp.append("-@-");
            }
            if (!ExcelValidator.isBlankCSVRow(XLSX2CSV.this._resultRowTmp.toString())) {
                XLSX2CSV.this.results.add(XLSX2CSV.this._resultRowTmp.toString());
            } else {
                XLSX2CSV.this.blankRowNum++;
            }
            XLSX2CSV.this._resultRowTmp.setLength(0);
        }

        public void cell(String cellReference, String formattedValue, XSSFComment comment) {
            if (this.firstCellOfRow) {
                this.firstCellOfRow = false;
            } else {
                XLSX2CSV.this._resultRowTmp.append("-@-");
            }
            if (cellReference == null) {
                cellReference = new CellAddress(this.currentRow, this.currentCol).formatAsString();
            }
            short thisCol = new CellReference(cellReference).getCol();
            int missedCols = thisCol - this.currentCol - 1;
            for (int i = 0; i < missedCols; ++i) {
                XLSX2CSV.this._resultRowTmp.append("-@-");
            }
            this.currentCol = thisCol;
            try {
                Double.parseDouble(formattedValue);
                XLSX2CSV.this._resultRowTmp.append(formattedValue);
            }
            catch (NumberFormatException e) {
                XLSX2CSV.this._resultRowTmp.append(formattedValue);
            }
        }

        public void headerFooter(String text, boolean isHeader, String tagName) {
        }
    }
}

