/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.excel;

import com.mendmix.common2.excel.helper.ExcelBeanHelper;
import com.mendmix.common2.excel.model.ExcelMeta;
import com.mendmix.common2.excel.model.TitleMeta;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelWriter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ExcelWriter.class);
    private String sheetName;
    private OutputStream outputStream;
    private final SXSSFWorkbook workbook;

    public ExcelWriter(String excelFilePath, String sheetName) throws IOException, InvalidFormatException {
        this.sheetName = sheetName;
        File file = new File(excelFilePath);
        boolean exists = file.exists();
        if (!exists) {
            file.createNewFile();
        }
        this.outputStream = new FileOutputStream(file);
        this.workbook = this.createWorkbook(exists ? file : null);
    }

    public ExcelWriter(String excelFilePath) throws IOException, InvalidFormatException {
        this(excelFilePath, "Sheet1");
    }

    public ExcelWriter(OutputStream outputStream) throws IOException, InvalidFormatException {
        this(outputStream, "Sheet1");
    }

    public ExcelWriter(OutputStream outputStream, String sheetName) throws InvalidFormatException, IOException {
        this.outputStream = outputStream;
        this.sheetName = sheetName;
        this.workbook = this.createWorkbook(null);
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    private SXSSFWorkbook createWorkbook(File existFile) throws IOException, InvalidFormatException {
        SXSSFWorkbook workbook = existFile == null ? new SXSSFWorkbook(1000) : new SXSSFWorkbook(new XSSFWorkbook(existFile), 1000);
        return workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> boolean write(List<T> list, Class<T> clazz) {
        ExcelMeta excelMeta = ExcelBeanHelper.getExcelMeta(clazz);
        try {
            SXSSFSheet sheet = this.workbook.createSheet(this.sheetName);
            sheet.setDefaultColumnWidth(15);
            CellStyle titleStyle = this.workbook.createCellStyle();
            titleStyle.setAlignment(HorizontalAlignment.CENTER);
            titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            titleStyle.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
            titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            titleStyle.setBorderBottom(BorderStyle.THIN);
            titleStyle.setBorderLeft(BorderStyle.THIN);
            Font font = this.workbook.createFont();
            font.setFontName("\u5b8b\u4f53");
            font.setFontHeightInPoints((short)13);
            titleStyle.setFont(font);
            Class[] cellValueTypes = new Class[excelMeta.getTitleColumnNum()];
            int i = 1;
            while (true) {
                if (i > excelMeta.getTitleRowNum()) break;
                Row excelRow = sheet.createRow(i - 1);
                for (int j = 1; j <= excelMeta.getTitleColumnNum(); ++j) {
                    TitleMeta titleMeta = excelMeta.getTitleMeta(i, j);
                    Cell cell = excelRow.createCell(j - 1);
                    cell.setCellValue(titleMeta == null ? "" : titleMeta.getTitle());
                    cell.setCellStyle(titleStyle);
                    cellValueTypes[j - 1] = titleMeta.getValueType();
                }
                ++i;
            }
            this.mergeColumns((Sheet)sheet, titleStyle);
            this.mergeRows((Sheet)sheet, titleStyle, excelMeta);
            int rowsCount = sheet.getPhysicalNumberOfRows();
            List<Object[]> rows = ExcelBeanHelper.beanToExcelValueArrays(list, clazz);
            int i2 = 0;
            while (true) {
                if (i2 >= rows.size()) {
                    this.workbook.write(this.outputStream);
                    return true;
                }
                Row excelRow = sheet.createRow(i2 + rowsCount);
                Object[] vals = rows.get(i2);
                for (int j = 0; j < vals.length; ++j) {
                    Cell cell = excelRow.createCell(j);
                    if (cellValueTypes[j] == Integer.TYPE || cellValueTypes[j] == Integer.class) {
                        cell.setCellValue(vals[j] == null ? 0.0 : (double)Integer.parseInt(vals[j].toString()));
                        continue;
                    }
                    if (cellValueTypes[j] == Float.TYPE || cellValueTypes[j] == Float.class || cellValueTypes[j] == Double.TYPE || cellValueTypes[j] == Double.class || cellValueTypes[j] == BigDecimal.class) {
                        cell.setCellValue(vals[j] == null ? 0.0 : Double.parseDouble(vals[j].toString()));
                        continue;
                    }
                    cell.setCellValue(vals[j] == null ? "" : vals[j].toString());
                }
                ++i2;
            }
        }
        catch (IOException e) {
            LOG.error("\u6d41\u5f02\u5e38", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOG.error("\u5176\u4ed6\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    private void mergeColumns(Sheet sheet, CellStyle cellStyle) {
        int rowsCount = sheet.getPhysicalNumberOfRows();
        int colsCount = sheet.getRow(0).getPhysicalNumberOfCells();
        Row row = null;
        Cell cell1 = null;
        Cell cell2 = null;
        int colSpan = 0;
        block0: for (int r = 0; r < rowsCount; ++r) {
            row = sheet.getRow(r);
            colSpan = 0;
            row = sheet.getRow(r);
            for (int c = 0; c < colsCount; ++c) {
                cell1 = row.getCell(c);
                cell2 = row.getCell(c + 1);
                if (cell1 == null) {
                    if (c != colsCount - 1) continue;
                    continue block0;
                }
                if (cell2 == null && colSpan >= 1) {
                    sheet.addMergedRegion(new CellRangeAddress(r, r, c - colSpan, c));
                    continue block0;
                }
                if (cell1 == null || cell2 == null) continue;
                if (cell1.getStringCellValue().equals(cell2.getStringCellValue())) {
                    ++colSpan;
                    continue;
                }
                if (colSpan < 1) continue;
                sheet.addMergedRegion(new CellRangeAddress(r, r, c - colSpan, c));
                Cell nowCell = sheet.getRow(r).getCell(c - colSpan);
                nowCell.setCellStyle(cellStyle);
                colSpan = 0;
            }
        }
    }

    private void mergeRows(Sheet sheet, CellStyle cellStyle, ExcelMeta excelMeta) {
        Row row = null;
        Cell cell = null;
        String[] lastRowVals = new String[excelMeta.getTitleColumnNum()];
        for (int r = 0; r < excelMeta.getTitleRowNum(); ++r) {
            for (int c = 0; c < excelMeta.getTitleColumnNum(); ++c) {
                row = sheet.getRow(r);
                cell = row.getCell(c);
                if (r == 0) {
                    lastRowVals[c] = cell.getStringCellValue();
                    continue;
                }
                if (!StringUtils.equals((CharSequence)lastRowVals[c], (CharSequence)cell.getStringCellValue())) continue;
                cell.setCellValue("");
                sheet.addMergedRegion(new CellRangeAddress(0, r, c, c));
                Cell nowCell = sheet.getRow(0).getCell(c);
                nowCell.setCellStyle(cellStyle);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.workbook.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

