/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.excel;

import com.mendmix.common2.excel.helper.ExcelBeanHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelTemplateWriter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ExcelTemplateWriter.class);
    private String templatePath;
    private OutputStream outputStream;
    private final SXSSFWorkbook workbook;

    public ExcelTemplateWriter(String templatePath, String outputPath) throws IOException, InvalidFormatException {
        this.templatePath = templatePath;
        File file = new File(outputPath);
        boolean exists = file.exists();
        if (!exists) {
            file.createNewFile();
        }
        this.outputStream = new FileOutputStream(file);
        this.workbook = this.createWorkbook();
    }

    public ExcelTemplateWriter(String templatePath, OutputStream outputStream) throws InvalidFormatException, IOException {
        this.templatePath = templatePath;
        this.outputStream = outputStream;
        this.workbook = this.createWorkbook();
    }

    private SXSSFWorkbook createWorkbook() throws IOException, InvalidFormatException {
        File templateFile = new File(this.templatePath);
        if (!templateFile.exists()) {
            throw new FileNotFoundException("Template[" + this.templatePath + "] not found");
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook(new XSSFWorkbook(templateFile), 1000);
        return workbook;
    }

    public <T> boolean write(List<T> list, Class<T> clazz) {
        List<Object[]> rows = ExcelBeanHelper.beanToExcelValueArrays(list, clazz);
        try {
            SXSSFSheet sheet = this.workbook.getSheetAt(0);
            for (int i = 2; i < rows.size(); ++i) {
                Row excelRow = sheet.getRow(i);
                Object[] vals = rows.get(i);
                for (int j = 0; j < vals.length; ++j) {
                    Cell cell = excelRow.getCell(j);
                    cell.setCellValue(vals[j] == null ? "" : vals[j].toString());
                }
            }
            this.workbook.write(this.outputStream);
            return true;
        }
        catch (IOException e) {
            LOG.error("\u6d41\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("\u5176\u4ed6\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        try {
            this.outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.workbook.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

