/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.excel;

import com.mendmix.common2.excel.annotation.TitleCell;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelReader
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ExcelReader.class);
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int startRow = 0;
    private String sheetName = "Sheet1";
    private final String excelFilePath;
    private final Workbook workbook;

    public ExcelReader(String excelFilePath) throws IOException, InvalidFormatException {
        this.excelFilePath = excelFilePath;
        this.workbook = this.createWorkbook();
    }

    public ExcelReader(InputStream inputStream) throws IOException, InvalidFormatException {
        this.excelFilePath = "";
        this.workbook = WorkbookFactory.create((InputStream)inputStream);
    }

    public ExcelReader(InputStream inputStream, String outFilePath) throws IOException, InvalidFormatException {
        this.excelFilePath = outFilePath;
        this.workbook = WorkbookFactory.create((InputStream)inputStream);
    }

    public void setStartRow(int startRow) {
        if (startRow < 1) {
            throw new RuntimeException("\u6700\u5c0f\u4e3a1");
        }
        this.startRow = --startRow;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void setFormat(String format) {
        this.format = new SimpleDateFormat(format);
    }

    public <T> List<T> parse(Class<T> clazz) {
        ArrayList<T> resultList;
        block10: {
            resultList = null;
            try {
                Sheet sheet = this.workbook.getSheet(this.sheetName);
                if (null != sheet) {
                    resultList = new ArrayList<T>(sheet.getLastRowNum() - 1);
                    Row row = sheet.getRow(this.startRow);
                    HashMap<String, Field> fieldMap = new HashMap<String, Field>();
                    HashMap<String, String> titleMap = new HashMap<String, String>();
                    Field[] fields = clazz.getDeclaredFields();
                    for (Field field : fields) {
                        if (!field.isAnnotationPresent(TitleCell.class)) continue;
                        TitleCell mapperCell = field.getAnnotation(TitleCell.class);
                        fieldMap.put(mapperCell.name(), field);
                    }
                    for (Cell title : row) {
                        CellReference cellRef = new CellReference(title);
                        titleMap.put(cellRef.getCellRefParts()[2], title.getRichStringCellValue().getString());
                    }
                    for (int i = this.startRow + 1; i <= sheet.getLastRowNum(); ++i) {
                        T t = clazz.newInstance();
                        Row dataRow = sheet.getRow(i);
                        for (Cell data : dataRow) {
                            CellReference cellRef = new CellReference(data);
                            String cellTag = cellRef.getCellRefParts()[2];
                            String name = (String)titleMap.get(cellTag);
                            Field field = (Field)fieldMap.get(name);
                            if (null == field) continue;
                            field.setAccessible(true);
                            this.getCellValue(data, t, field);
                        }
                        resultList.add(t);
                    }
                    break block10;
                }
                throw new RuntimeException("sheetName:" + this.sheetName + " is not exist");
            }
            catch (InstantiationException e) {
                LOG.error("\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
            }
            catch (ParseException e) {
                LOG.error("\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38:{}", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("\u5176\u4ed6\u5f02\u5e38", (Throwable)e);
            }
        }
        return resultList;
    }

    private void getCellValue(Cell cell, Object o, Field field) throws IllegalAccessException, ParseException {
        LOG.debug("MENDMIX-TRACE-LOGGGING-->> cell:{}, field:{}, type:{}", new Object[]{cell.getCellTypeEnum(), field.getName(), field.getType().getName()});
        switch (cell.getCellTypeEnum()) {
            case BLANK: {
                break;
            }
            case BOOLEAN: {
                field.setBoolean(o, cell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                field.setByte(o, cell.getErrorCellValue());
                break;
            }
            case FORMULA: {
                field.set(o, cell.getCellFormula());
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    if (field.getType().getName().equals(Date.class.getName())) {
                        field.set(o, cell.getDateCellValue());
                        break;
                    }
                    field.set(o, this.format.format(cell.getDateCellValue()));
                    break;
                }
                if (field.getType().isAssignableFrom(Integer.class) || field.getType().getName().equals("int")) {
                    field.setInt(o, (int)cell.getNumericCellValue());
                    break;
                }
                if (field.getType().isAssignableFrom(Short.class) || field.getType().getName().equals("short")) {
                    field.setShort(o, (short)cell.getNumericCellValue());
                    break;
                }
                if (field.getType().isAssignableFrom(Float.class) || field.getType().getName().equals("float")) {
                    field.setFloat(o, (float)cell.getNumericCellValue());
                    break;
                }
                if (field.getType().isAssignableFrom(Byte.class) || field.getType().getName().equals("byte")) {
                    field.setByte(o, (byte)cell.getNumericCellValue());
                    break;
                }
                if (field.getType().isAssignableFrom(Double.class) || field.getType().getName().equals("double")) {
                    field.setDouble(o, cell.getNumericCellValue());
                    break;
                }
                if (field.getType().isAssignableFrom(String.class)) {
                    String s = String.valueOf(cell.getNumericCellValue());
                    if (s.contains("E")) {
                        s = s.trim();
                        BigDecimal bigDecimal = new BigDecimal(s);
                        s = bigDecimal.toPlainString();
                    }
                    if (s.endsWith(".0")) {
                        s = s.substring(0, s.indexOf(".0"));
                    }
                    field.set(o, s);
                    break;
                }
                field.set(o, cell.getNumericCellValue());
                break;
            }
            case STRING: {
                if (field.getType().getName().equals(Date.class.getName())) {
                    field.set(o, this.format.parse(cell.getRichStringCellValue().getString()));
                    break;
                }
                field.set(o, cell.getRichStringCellValue().getString());
                break;
            }
            default: {
                field.set(o, cell.getStringCellValue());
            }
        }
    }

    private Workbook createWorkbook() throws IOException, InvalidFormatException {
        Workbook workbook;
        File file = new File(this.excelFilePath);
        if (!file.exists()) {
            LOG.warn("MENDMIX-TRACE-LOGGGING-->> \u6587\u4ef6:{} \u4e0d\u5b58\u5728\uff01\u521b\u5efa\u6b64\u6587\u4ef6\uff01", (Object)this.excelFilePath);
            if (!file.createNewFile()) {
                throw new IOException("\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
            }
            workbook = new XSSFWorkbook();
        } else {
            workbook = WorkbookFactory.create((File)file);
        }
        return workbook;
    }

    public String getCellValue(int rowNumber, int cellNumber) {
        String result;
        this.checkRowAndCell(rowNumber, cellNumber);
        Sheet sheet = this.workbook.getSheet(this.sheetName);
        Row row = sheet.getRow(--rowNumber);
        Cell cell = row.getCell(--cellNumber);
        switch (cell.getCellTypeEnum()) {
            case BLANK: {
                result = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                result = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                result = String.valueOf(cell.getErrorCellValue());
                break;
            }
            case FORMULA: {
                result = cell.getCellFormula();
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    result = this.format.format(cell.getDateCellValue());
                    break;
                }
                result = String.valueOf(cell.getNumericCellValue());
                break;
            }
            case STRING: {
                result = cell.getRichStringCellValue().getString();
                break;
            }
            default: {
                result = cell.getStringCellValue();
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.workbook.close();
    }

    private void checkRowAndCell(int rowNumber, int cellNumber) {
        if (rowNumber < 1) {
            throw new RuntimeException("rowNumber less than 1");
        }
        if (cellNumber < 1) {
            throw new RuntimeException("cellNumber less than 1");
        }
    }
}

