/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.common2.excel;

import com.mendmix.common2.excel.ExcelOperBaseException;
import com.mendmix.common2.excel.convert.XLS2CSV;
import com.mendmix.common2.excel.convert.XLSX2CSV;
import com.mendmix.common2.excel.helper.ExcelBeanHelper;
import java.io.IOException;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.openxml4j.exceptions.OLE2NotOfficeXmlFileException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.filesystem.NotOLE2FileException;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;

public class ExcelPerfModeReader {
    private final String excelFilePath;
    private int titleStartAt = 1;

    public ExcelPerfModeReader(String excelFilePath) {
        this.excelFilePath = excelFilePath;
    }

    public ExcelPerfModeReader titleStartAt(int start) {
        this.titleStartAt = start;
        return this;
    }

    private List<String> read() {
        List<String> result = null;
        if (this.excelFilePath.toLowerCase().endsWith("xls")) {
            try {
                result = this.readAsXLS(this.excelFilePath);
            }
            catch (OfficeXmlFileException e) {
                result = this.readAsXLSX(this.excelFilePath);
            }
        } else {
            try {
                result = this.readAsXLSX(this.excelFilePath);
            }
            catch (OLE2NotOfficeXmlFileException e) {
                result = this.readAsXLS(this.excelFilePath);
            }
        }
        this.removeLineBeforeTitle(result);
        return result;
    }

    public <T> List<T> read(Class<T> clazz) {
        List<String> rows = this.read();
        if (rows == null || rows.size() <= 1) {
            throw new ExcelOperBaseException("\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        return ExcelBeanHelper.setRowValues(clazz, rows);
    }

    private List<String> readAsXLS(String path) {
        try {
            XLS2CSV xls2csv = new XLS2CSV(path, -1);
            return xls2csv.process();
        }
        catch (Exception e) {
            if (e instanceof NotOLE2FileException || e instanceof NotOfficeXmlFileException || e instanceof OfficeXmlFileException) {
                throw new ExcelOperBaseException("\u8bf7\u9009\u62e9\u6b63\u786e\u683c\u5f0fexcel\u6587\u4ef6");
            }
            if (e instanceof IOException) {
                throw new ExcelOperBaseException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
            }
            throw new RuntimeException(e);
        }
    }

    private List<String> readAsXLSX(String path) {
        OPCPackage opcPackage = null;
        try {
            opcPackage = OPCPackage.open((String)path, (PackageAccess)PackageAccess.READ);
            XLSX2CSV xlsx2csv = new XLSX2CSV(opcPackage, System.out, -1);
            List<String> list = xlsx2csv.process();
            return list;
        }
        catch (Exception e) {
            if (e instanceof OLE2NotOfficeXmlFileException || e instanceof NotOLE2FileException || e instanceof NotOfficeXmlFileException || e instanceof OfficeXmlFileException) {
                throw new ExcelOperBaseException("\u8bf7\u9009\u62e9\u6b63\u786e\u683c\u5f0fexcel\u6587\u4ef6");
            }
            if (e instanceof IOException) {
                throw new ExcelOperBaseException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
            }
            if (e instanceof InvalidOperationException) {
                throw new ExcelOperBaseException(e);
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                opcPackage.close();
            }
            catch (Exception exception) {}
        }
    }

    private void removeLineBeforeTitle(List<String> lines) {
        if (this.titleStartAt == 1 || lines == null || lines.size() - 1 <= this.titleStartAt) {
            return;
        }
        for (int i = 1; i < this.titleStartAt; ++i) {
            lines.remove(1);
        }
    }
}

