/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.pqc.jcajce.provider.util;

import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import org.spongycastle.pqc.jcajce.provider.util.CipherSpiExt;

public abstract class AsymmetricBlockCipher
extends CipherSpiExt {
    protected AlgorithmParameterSpec paramSpec;
    protected ByteArrayOutputStream buf = new ByteArrayOutputStream();
    protected int maxPlainTextSize;
    protected int cipherTextSize;

    public final int getBlockSize() {
        return this.opMode == 1 ? this.maxPlainTextSize : this.cipherTextSize;
    }

    public final byte[] getIV() {
        return null;
    }

    public final int getOutputSize(int inLen) {
        int maxLen;
        int totalLen = inLen + this.buf.size();
        if (totalLen > (maxLen = this.getBlockSize())) {
            return 0;
        }
        return maxLen;
    }

    public final AlgorithmParameterSpec getParameters() {
        return this.paramSpec;
    }

    public final void initEncrypt(Key key) throws InvalidKeyException {
        try {
            this.initEncrypt(key, null, new SecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
    }

    public final void initEncrypt(Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.initEncrypt(key, null, random);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
    }

    public final void initEncrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initEncrypt(key, params, new SecureRandom());
    }

    public final void initEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.opMode = 1;
        this.initCipherEncrypt(key, params, secureRandom);
    }

    public final void initDecrypt(Key key) throws InvalidKeyException {
        try {
            this.initDecrypt(key, null);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
    }

    public final void initDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.opMode = 2;
        this.initCipherDecrypt(key, params);
    }

    public final byte[] update(byte[] input, int inOff, int inLen) {
        if (inLen != 0) {
            this.buf.write(input, inOff, inLen);
        }
        return new byte[0];
    }

    public final int update(byte[] input, int inOff, int inLen, byte[] output, int outOff) {
        this.update(input, inOff, inLen);
        return 0;
    }

    public final byte[] doFinal(byte[] input, int inOff, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        this.checkLength(inLen);
        this.update(input, inOff, inLen);
        byte[] mBytes = this.buf.toByteArray();
        this.buf.reset();
        switch (this.opMode) {
            case 1: {
                return this.messageEncrypt(mBytes);
            }
            case 2: {
                return this.messageDecrypt(mBytes);
            }
        }
        return null;
    }

    public final int doFinal(byte[] input, int inOff, int inLen, byte[] output, int outOff) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (output.length < this.getOutputSize(inLen)) {
            throw new ShortBufferException("Output buffer too short.");
        }
        byte[] out = this.doFinal(input, inOff, inLen);
        System.arraycopy(out, 0, output, outOff, out.length);
        return out.length;
    }

    protected final void setMode(String modeName) {
    }

    protected final void setPadding(String paddingName) {
    }

    protected void checkLength(int inLen) throws IllegalBlockSizeException {
        int inLength = inLen + this.buf.size();
        if (this.opMode == 1) {
            if (inLength > this.maxPlainTextSize) {
                throw new IllegalBlockSizeException("The length of the plaintext (" + inLength + " bytes) is not supported by the cipher (max. " + this.maxPlainTextSize + " bytes).");
            }
        } else if (this.opMode == 2 && inLength != this.cipherTextSize) {
            throw new IllegalBlockSizeException("Illegal ciphertext length (expected " + this.cipherTextSize + " bytes, was " + inLength + " bytes).");
        }
    }

    protected abstract void initCipherEncrypt(Key var1, AlgorithmParameterSpec var2, SecureRandom var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void initCipherDecrypt(Key var1, AlgorithmParameterSpec var2) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract byte[] messageEncrypt(byte[] var1) throws IllegalBlockSizeException, BadPaddingException;

    protected abstract byte[] messageDecrypt(byte[] var1) throws IllegalBlockSizeException, BadPaddingException;
}

