/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jcajce.provider.drbg;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.digests.SHA512Digest;
import org.spongycastle.crypto.prng.EntropySource;
import org.spongycastle.crypto.prng.EntropySourceProvider;
import org.spongycastle.crypto.prng.SP800SecureRandomBuilder;
import org.spongycastle.jcajce.provider.config.ConfigurableProvider;
import org.spongycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import org.spongycastle.util.Arrays;
import org.spongycastle.util.Pack;
import org.spongycastle.util.Strings;

public class DRBG {
    private static final String PREFIX = DRBG.class.getName();
    private static final String[][] initialEntropySourceNames = new String[][]{{"sun.security.provider.Sun", "sun.security.provider.SecureRandom"}, {"org.apache.harmony.security.provider.crypto.CryptoProvider", "org.apache.harmony.security.provider.crypto.SHA1PRNG_SecureRandomImpl"}, {"com.android.org.conscrypt.OpenSSLProvider", "com.android.org.conscrypt.OpenSSLRandom"}, {"org.conscrypt.OpenSSLProvider", "org.conscrypt.OpenSSLRandom"}};
    private static final Object[] initialEntropySourceAndSpi = DRBG.findSource();

    private static final Object[] findSource() {
        for (int t = 0; t < initialEntropySourceNames.length; ++t) {
            String[] pair = initialEntropySourceNames[t];
            try {
                Object[] r = new Object[]{Class.forName(pair[0]).newInstance(), Class.forName(pair[1]).newInstance()};
                return r;
            }
            catch (Throwable ex) {
                continue;
            }
        }
        return null;
    }

    private static SecureRandom createInitialEntropySource() {
        if (initialEntropySourceAndSpi != null) {
            return new CoreSecureRandom();
        }
        return new SecureRandom();
    }

    private static EntropySourceProvider createEntropySource() {
        final String sourceClass = System.getProperty("org.spongycastle.drbg.entropysource");
        return AccessController.doPrivileged(new PrivilegedAction<EntropySourceProvider>(){

            @Override
            public EntropySourceProvider run() {
                try {
                    Class<?> clazz = DRBG.class.getClassLoader().loadClass(sourceClass);
                    return (EntropySourceProvider)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("entropy source " + sourceClass + " not created: " + e.getMessage(), e);
                }
            }
        });
    }

    private static SecureRandom createBaseRandom(boolean isPredictionResistant) {
        if (System.getProperty("org.spongycastle.drbg.entropysource") != null) {
            EntropySourceProvider entropyProvider = DRBG.createEntropySource();
            EntropySource initSource = entropyProvider.get(128);
            return new SP800SecureRandomBuilder(entropyProvider).setPersonalizationString(DRBG.generateDefaultPersonalizationString(initSource.getEntropy())).buildHash((Digest)new SHA512Digest(), Arrays.concatenate((byte[])initSource.getEntropy(), (byte[])initSource.getEntropy()), isPredictionResistant);
        }
        SecureRandom randomSource = DRBG.createInitialEntropySource();
        return new SP800SecureRandomBuilder(randomSource, true).setPersonalizationString(DRBG.generateDefaultPersonalizationString(randomSource.generateSeed(16))).buildHash((Digest)new SHA512Digest(), randomSource.generateSeed(32), isPredictionResistant);
    }

    private static byte[] generateDefaultPersonalizationString(byte[] seed) {
        return Arrays.concatenate((byte[])Strings.toByteArray((String)"Default"), (byte[])seed, (byte[])Pack.longToBigEndian((long)Thread.currentThread().getId()), (byte[])Pack.longToBigEndian((long)System.currentTimeMillis()));
    }

    private static byte[] generateNonceIVPersonalizationString(byte[] seed) {
        return Arrays.concatenate((byte[])Strings.toByteArray((String)"Nonce"), (byte[])seed, (byte[])Pack.longToLittleEndian((long)Thread.currentThread().getId()), (byte[])Pack.longToLittleEndian((long)System.currentTimeMillis()));
    }

    static /* synthetic */ SecureRandom access$100(boolean x0) {
        return DRBG.createBaseRandom(x0);
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("SecureRandom.DEFAULT", PREFIX + "$Default");
            provider.addAlgorithm("SecureRandom.NONCEANDIV", PREFIX + "$NonceAndIV");
        }
    }

    public static class NonceAndIV
    extends SecureRandomSpi {
        private static final SecureRandom random = DRBG.access$100(false);

        protected void engineSetSeed(byte[] bytes) {
            random.setSeed(bytes);
        }

        protected void engineNextBytes(byte[] bytes) {
            random.nextBytes(bytes);
        }

        protected byte[] engineGenerateSeed(int numBytes) {
            return random.generateSeed(numBytes);
        }
    }

    public static class Default
    extends SecureRandomSpi {
        private static final SecureRandom random = DRBG.access$100(true);

        protected void engineSetSeed(byte[] bytes) {
            random.setSeed(bytes);
        }

        protected void engineNextBytes(byte[] bytes) {
            random.nextBytes(bytes);
        }

        protected byte[] engineGenerateSeed(int numBytes) {
            return random.generateSeed(numBytes);
        }
    }

    private static class CoreSecureRandom
    extends SecureRandom {
        CoreSecureRandom() {
            super((SecureRandomSpi)initialEntropySourceAndSpi[1], (Provider)initialEntropySourceAndSpi[0]);
        }
    }
}

