/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder;

import android.content.Context;
import android.text.method.MovementMethod;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.ContextualMovementMethod;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.ui.view.adapter.viewholder.StartViewHolder;
import com.liveperson.infra.ui.view.resources.ResourceHelper;

public class AmsBrandMsgViewHolder
extends StartViewHolder {
    private ImageView mAgentAvatar;
    protected ContextualActionBehavior mContextualActionBehavior;

    public AmsBrandMsgViewHolder(View itemView, ContextualActionBehavior contextualActionBehavior) {
        super(itemView);
        this.mContextualActionBehavior = contextualActionBehavior;
        this.mAgentAvatar = (ImageView)itemView.findViewById(R.id.lpui_brand_bubbleAvatar);
        this.applyColors();
    }

    public void applyColors() {
        ResourceHelper.updateBackgroundStrokeColor((View)this.mMessageTextView, (int)R.color.brand_bubble_stroke_color, (int)R.dimen.brand_bubble_stroke_width);
        ResourceHelper.updateBackgroundSolidColor((View)this.mMessageTextView, (int)R.color.brand_bubble_background_color);
        ResourceHelper.updateTextColor((TextView)this.mMessageTextView, (int)R.color.brand_bubble_message_text_color);
        ResourceHelper.updateTextColor((TextView)this.mTimestampTextView, (int)R.color.brand_bubble_timestamp_text_color);
        ResourceHelper.updateTextColorLink((TextView)this.mMessageTextView, (int)R.color.brand_bubble_message_link_text_color);
        this.mAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_brand_logo);
    }

    public void updateContentDescription() {
        Context context = this.getContext();
        if (context != null) {
            String agentWord = context.getResources().getString(R.string.lp_accessibility_agent);
            String receivedWord = context.getResources().getString(R.string.lp_accessibility_received);
            this.setContentDescription(agentWord + ": " + this.mMessageTextView.getText().toString() + ", " + receivedWord + " " + this.mTimestampAccessibilityString);
        }
    }

    public void setMessageText(String text, boolean enabled) {
        this.mMessageTextView.setLinksClickable(enabled);
        if (enabled) {
            this.mMessageTextView.setMovementMethod((MovementMethod)new ContextualMovementMethod(this.mContextualActionBehavior));
            this.setMessageTextView(text);
            if (this.linkifyText(this.mMessageTextView)) {
                ViewCompat.enableAccessibleClickableSpanSupport((View)this.mMessageTextView);
            }
        } else {
            this.setMessageTextView(text);
        }
    }
}

