/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.View;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.utils.markdownlink.HyperLinkUtils;
import com.liveperson.infra.messaging_ui.utils.markdownlink.MarkdownHyperlinkItem;
import com.liveperson.infra.messaging_ui.view.adapter.ContextualMovementMethod;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsAgentViewHolder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\tH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/liveperson/infra/messaging_ui/view/adapter/viewholder/AmsAgentMarkdownHyperlinkViewHolder;", "Lcom/liveperson/infra/messaging_ui/view/adapter/viewholder/AmsAgentViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "hyperlinkList", "", "Lcom/liveperson/infra/messaging_ui/utils/markdownlink/MarkdownHyperlinkItem;", "markdownFormatText", "", "getTextToCopy", "setMessageText", "", "text", "enabled", "", "updateContentDescription", "messaging_ui_release"})
public final class AmsAgentMarkdownHyperlinkViewHolder
extends AmsAgentViewHolder {
    private String markdownFormatText;
    private List<MarkdownHyperlinkItem> hyperlinkList;

    @Override
    public void setMessageText(@Nullable String text, boolean enabled) {
        block0: {
            super.setMessageText(text, enabled);
            String string2 = text;
            if (string2 == null) break block0;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            this.markdownFormatText = text;
            this.hyperlinkList = HyperLinkUtils.INSTANCE.buildHyperlinkList(text);
            TextView textView = this.mMessageTextView;
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"mMessageTextView");
            SpannableStringBuilder formattedMessage = HyperLinkUtils.INSTANCE.buildFormattedMessage(text, this.hyperlinkList, ContextCompat.getColor((Context)textView.getContext(), (int)R.color.agent_bubble_message_markdown_hyperlink_text_color));
            TextView textView2 = this.mMessageTextView;
            Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"mMessageTextView");
            textView2.setMovementMethod((MovementMethod)new ContextualMovementMethod(this.mContextualActionBehavior));
            TextView textView3 = this.mMessageTextView;
            Intrinsics.checkExpressionValueIsNotNull((Object)textView3, (String)"mMessageTextView");
            textView3.setText((CharSequence)formattedMessage);
            ViewCompat.enableAccessibleClickableSpanSupport((View)((View)this.mMessageTextView));
        }
    }

    @NotNull
    public String getTextToCopy() {
        if (Configuration.getBoolean((int)R.bool.lp_markdown_hyperlink_copy_text_only)) {
            String string2 = super.getTextToCopy();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"super.getTextToCopy()");
            return string2;
        }
        return this.markdownFormatText;
    }

    @Override
    public void updateContentDescription() {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        String string2 = context.getResources().getString(R.string.lp_accessibility_agent);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.resources.getStr\u2026g.lp_accessibility_agent)");
        String agentWord = string2;
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        String string3 = context2.getResources().getQuantityString(R.plurals.lp_accessibility_links, this.hyperlinkList.size(), new Object[]{this.hyperlinkList.size()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"context.resources.getQua\u2026size, hyperlinkList.size)");
        String linkWord = string3;
        String receivedWord = this.getStatusText();
        TextView textView = this.mMessageTextView;
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"mMessageTextView");
        StringBuilder stringBuilder = new StringBuilder();
        TextView textView2 = this.mMessageTextView;
        Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"mMessageTextView");
        textView.setContentDescription((CharSequence)stringBuilder.append(textView2.getText()).append(", ").append(linkWord).append(", ").append(receivedWord).append(' ').append(this.mTimestampAccessibilityString).toString());
        String agentNickNameText = null;
        if (TextUtils.isEmpty((CharSequence)this.mAgentNickName)) {
            agentNickNameText = "";
        } else {
            String string4 = this.mAgentNickName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"mAgentNickName");
            agentNickNameText = string4;
        }
        StringBuilder stringBuilder2 = new StringBuilder().append(agentWord).append(' ').append(agentNickNameText).append(" : ");
        TextView textView3 = this.mMessageTextView;
        Intrinsics.checkExpressionValueIsNotNull((Object)textView3, (String)"mMessageTextView");
        this.setContentDescription(stringBuilder2.append(textView3.getText()).append(", ").append(linkWord).append(' ').append(receivedWord).append(' ').append(this.mTimestampAccessibilityString).toString());
    }

    public AmsAgentMarkdownHyperlinkViewHolder(@NotNull View itemView) {
        Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
        super(itemView);
        this.markdownFormatText = "";
        this.hyperlinkList = new ArrayList();
    }
}

