/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils.markdownlink;

import android.text.SpannableStringBuilder;
import androidx.annotation.ColorInt;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.utils.markdownlink.HyperlinkClickableSpan;
import com.liveperson.infra.messaging_ui.utils.markdownlink.MarkdownHyperlinkItem;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0001\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/liveperson/infra/messaging_ui/utils/markdownlink/HyperLinkUtils;", "", "()V", "TAG", "", "buildFormattedMessage", "Landroid/text/SpannableStringBuilder;", "message", "hyperlinkList", "", "Lcom/liveperson/infra/messaging_ui/utils/markdownlink/MarkdownHyperlinkItem;", "hyperLinkColor", "", "buildHyperlinkList", "buildMessageString", "messaging_ui_release"})
public final class HyperLinkUtils {
    private static final String TAG = "HyperLinkUtils";
    public static final HyperLinkUtils INSTANCE;

    @NotNull
    public final List<MarkdownHyperlinkItem> buildHyperlinkList(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        List tempHyperlinkList = new ArrayList();
        boolean indexInsideTag = false;
        int index = 0;
        while (index <= message.length() - "#/md#".length()) {
            Object linkItem;
            boolean bl;
            int n;
            if (!indexInsideTag) {
                String string2 = message;
                n = index + "#md#".length();
                bl = false;
                String string3 = string2.substring(index, n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (Intrinsics.areEqual((Object)string3, (Object)"#md#")) {
                    linkItem = new MarkdownHyperlinkItem();
                    ((MarkdownHyperlinkItem)linkItem).setStart(index);
                    tempHyperlinkList.add(linkItem);
                    indexInsideTag = true;
                    index += "#md#".length();
                    continue;
                }
            }
            if (indexInsideTag) {
                linkItem = message;
                n = index + "#/md#".length();
                bl = false;
                String string4 = ((String)linkItem).substring(index, n);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (Intrinsics.areEqual((Object)string4, (Object)"#/md#")) {
                    linkItem = (MarkdownHyperlinkItem)CollectionsKt.last((List)tempHyperlinkList);
                    ((MarkdownHyperlinkItem)linkItem).setEnd(index += "#/md#".length());
                    ((MarkdownHyperlinkItem)linkItem).buildHyperlinkItem(message);
                    indexInsideTag = false;
                    continue;
                }
            }
            ++index;
        }
        List hyperlinkList = new ArrayList();
        for (MarkdownHyperlinkItem item : tempHyperlinkList) {
            if (item.isValid()) {
                hyperlinkList.add(item);
                continue;
            }
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000149, "Invalid markdown hyperlink format.");
        }
        return hyperlinkList;
    }

    @NotNull
    public final SpannableStringBuilder buildFormattedMessage(@NotNull String message, @NotNull List<MarkdownHyperlinkItem> hyperlinkList, @ColorInt int hyperLinkColor) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(hyperlinkList, (String)"hyperlinkList");
        SpannableStringBuilder formattedMessage = new SpannableStringBuilder();
        int linkItemIndex = 0;
        int index = 0;
        while (index < message.length()) {
            if (linkItemIndex < hyperlinkList.size()) {
                String textBeforeOpenTag;
                MarkdownHyperlinkItem linkItem = hyperlinkList.get(linkItemIndex);
                String string2 = message;
                int n = linkItem.getStart();
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)string2.substring(index, n), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                formattedMessage.append((CharSequence)textBeforeOpenTag);
                String title = linkItem.getTitle();
                formattedMessage.append((CharSequence)title);
                HyperlinkClickableSpan hyperlinkClickableSpan = new HyperlinkClickableSpan(linkItem.getLink(), hyperLinkColor);
                int n2 = formattedMessage.length();
                String string3 = title;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                formattedMessage.setSpan((Object)hyperlinkClickableSpan, n2 - string3.length(), formattedMessage.length(), 33);
                ++linkItemIndex;
                index = linkItem.getEnd();
                continue;
            }
            String string4 = message;
            SpannableStringBuilder spannableStringBuilder = formattedMessage;
            boolean bl = false;
            String string5 = string4.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String string6 = string5;
            spannableStringBuilder.append((CharSequence)string6);
            break;
        }
        return formattedMessage;
    }

    @NotNull
    public final String buildMessageString(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        List<MarkdownHyperlinkItem> hyperlinkList = this.buildHyperlinkList(message);
        StringBuilder messageBuilder = new StringBuilder();
        int linkItemIndex = 0;
        int index = 0;
        while (index < message.length()) {
            if (linkItemIndex < hyperlinkList.size()) {
                String textBeforeOpenTag;
                MarkdownHyperlinkItem linkItem = hyperlinkList.get(linkItemIndex);
                String string2 = message;
                int n = linkItem.getStart();
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)string2.substring(index, n), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                messageBuilder.append(textBeforeOpenTag).append(linkItem.getTitle());
                ++linkItemIndex;
                index = linkItem.getEnd();
                continue;
            }
            String string3 = message;
            StringBuilder stringBuilder = messageBuilder;
            boolean bl = false;
            String string4 = string3.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String string5 = string4;
            stringBuilder.append(string5);
            break;
        }
        String string6 = messageBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"messageBuilder.toString()");
        return string6;
    }

    private HyperLinkUtils() {
    }

    static {
        HyperLinkUtils hyperLinkUtils;
        INSTANCE = hyperLinkUtils = new HyperLinkUtils();
    }
}

