/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils;

import android.text.TextUtils;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/liveperson/infra/messaging_ui/utils/StringUtils;", "", "()V", "DEFAULT_DATE_FORMAT_SINGLE", "", "getDEFAULT_DATE_FORMAT_SINGLE", "()Ljava/lang/String;", "TAG", "getTAG", "createAppointmentSelectionMessage", "startTime", "", "endTime", "dateFormat", "timeFormat", "locale", "Ljava/util/Locale;", "createDatePickerMessage", "dateInSecond", "startInSecond", "endInSecond", "messaging_ui_release"})
public final class StringUtils {
    @NotNull
    private static final String TAG = "MessagingUI.StringUtils";
    @NotNull
    private static final String DEFAULT_DATE_FORMAT_SINGLE = "MMMM dd, yyyy";
    public static final StringUtils INSTANCE;

    @NotNull
    public final String getTAG() {
        return TAG;
    }

    @NotNull
    public final String getDEFAULT_DATE_FORMAT_SINGLE() {
        return DEFAULT_DATE_FORMAT_SINGLE;
    }

    @NotNull
    public final String createDatePickerMessage(long dateInSecond, @NotNull Locale locale) {
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        String message = "";
        Date date = new Date(dateInSecond * 1000L);
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_DATE_FORMAT_SINGLE, locale);
        String string2 = df.format(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"df.format(date)");
        message = string2;
        return message;
    }

    @NotNull
    public final String createDatePickerMessage(long dateInSecond, @NotNull String dateFormat, @NotNull Locale locale) {
        SimpleDateFormat simpleDateFormat;
        Intrinsics.checkParameterIsNotNull((Object)dateFormat, (String)"dateFormat");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        if (TextUtils.isEmpty((CharSequence)dateFormat)) {
            return this.createDatePickerMessage(dateInSecond, locale);
        }
        String message = "";
        Date date = new Date(dateInSecond * 1000L);
        try {
            simpleDateFormat = new SimpleDateFormat(dateFormat, locale);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000160, String.valueOf(e.getMessage()), (Throwable)e);
            simpleDateFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT_SINGLE, locale);
        }
        SimpleDateFormat df = simpleDateFormat;
        String string2 = df.format(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"df.format(date)");
        message = string2;
        return message;
    }

    @NotNull
    public final String createDatePickerMessage(long startInSecond, long endInSecond, @NotNull String dateFormat, @NotNull Locale locale) {
        Intrinsics.checkParameterIsNotNull((Object)dateFormat, (String)"dateFormat");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        String FORMAT_RANGE_SELECTION = "%1$s - %2$s";
        String message = "";
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = new Object[]{this.createDatePickerMessage(startInSecond, dateFormat, locale), this.createDatePickerMessage(endInSecond, dateFormat, locale)};
        boolean bl = false;
        String string2 = String.format(FORMAT_RANGE_SELECTION, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        message = string2;
        return message;
    }

    @NotNull
    public final String createAppointmentSelectionMessage(long startTime, long endTime, @NotNull String dateFormat, @NotNull String timeFormat, @NotNull Locale locale) {
        Intrinsics.checkParameterIsNotNull((Object)dateFormat, (String)"dateFormat");
        Intrinsics.checkParameterIsNotNull((Object)timeFormat, (String)"timeFormat");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        StringBuilder dateTime = new StringBuilder();
        dateTime.append(new SimpleDateFormat(dateFormat, locale).format(new Date(startTime)));
        dateTime.append("\n");
        dateTime.append(new SimpleDateFormat(timeFormat, locale).format(new Date(startTime)));
        if (endTime > 0L) {
            dateTime.append(" - ");
            dateTime.append(new SimpleDateFormat(timeFormat, locale).format(new Date(endTime)));
        }
        String string2 = dateTime.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dateTime.toString()");
        return string2;
    }

    private StringUtils() {
    }

    static {
        StringUtils stringUtils;
        INSTANCE = stringUtils = new StringUtils();
        TAG = TAG;
        DEFAULT_DATE_FORMAT_SINGLE = DEFAULT_DATE_FORMAT_SINGLE;
    }
}

