/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents.list.header;

import android.content.Context;
import com.liveperson.infra.messaging_ui.uicomponents.list.header.DateHeaderUtilsKt;
import com.liveperson.infra.utils.DateUtils;
import com.liveperson.messaging.model.FullMessageRow;
import com.liveperson.messaging.model.MessagingChatMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020 J\u001c\u0010!\u001a\u00020 2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010\"\u001a\u00020\u0014*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0015\u0010#\u001a\u00020\u0013*\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H\u0082\u0004R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\u0007*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0015R\u0018\u0010\u0016\u001a\u00020\u0007*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lcom/liveperson/infra/messaging_ui/uicomponents/list/header/DateHeaderHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "_headersPositionsMap", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "_knownListSize", "headers", "", "getHeaders", "()Ljava/util/Map;", "asDayTimestamp", "getAsDayTimestamp", "(J)J", "isDateHeader", "", "Lcom/liveperson/messaging/model/FullMessageRow;", "(Lcom/liveperson/messaging/model/FullMessageRow;)Z", "timestamp", "getTimestamp", "(Lcom/liveperson/messaging/model/FullMessageRow;)J", "applyListChanges", "diff", "rows", "", "onDateHeaderChangedListener", "Lcom/liveperson/infra/messaging_ui/uicomponents/list/header/DateHeaderHelper$OnDateHeaderChangedListener;", "clearDateHeaders", "", "observeHeaderChanging", "headerOfTimeStamp", "isSentInTheSameDayAs", "row", "OnDateHeaderChangedListener", "messaging_ui_release"})
public final class DateHeaderHelper {
    private final HashMap<Long, Integer> _headersPositionsMap;
    private int _knownListSize;
    private final Context context;

    public final void observeHeaderChanging(@NotNull List<? extends FullMessageRow> rows, @NotNull OnDateHeaderChangedListener onDateHeaderChangedListener) {
        int n;
        Intrinsics.checkParameterIsNotNull(rows, (String)"rows");
        Intrinsics.checkParameterIsNotNull((Object)onDateHeaderChangedListener, (String)"onDateHeaderChangedListener");
        int n2 = rows.size() - this._knownListSize;
        boolean bl = false;
        int diff = n = Math.abs(n2);
        Object object = (FullMessageRow)CollectionsKt.firstOrNull(rows);
        if (object != null) {
            FullMessageRow fullMessageRow = object;
            bl = false;
            boolean bl2 = false;
            FullMessageRow it = fullMessageRow;
            boolean bl3 = false;
            object = !this.isDateHeader(it) ? fullMessageRow : null;
            if (object != null) {
                fullMessageRow = object;
                bl = false;
                bl2 = false;
                it = fullMessageRow;
                boolean bl4 = false;
                MessagingChatMessage messagingChatMessage = it.getMessagingChatMessage();
                Intrinsics.checkExpressionValueIsNotNull((Object)messagingChatMessage, (String)"it.messagingChatMessage");
                object = !(messagingChatMessage.getMessageType() == MessagingChatMessage.MessageType.LOADING) ? fullMessageRow : null;
                if (object != null) {
                    fullMessageRow = object;
                    bl = false;
                    bl2 = false;
                    it = fullMessageRow;
                    boolean bl5 = false;
                    MessagingChatMessage messagingChatMessage2 = it.getMessagingChatMessage();
                    Intrinsics.checkExpressionValueIsNotNull((Object)messagingChatMessage2, (String)"it.messagingChatMessage");
                    object = !(messagingChatMessage2.getMessageType() == MessagingChatMessage.MessageType.UNREAD_INDICATOR) ? fullMessageRow : null;
                    if (object != null) {
                        fullMessageRow = object;
                        bl = false;
                        bl2 = false;
                        it = fullMessageRow;
                        boolean bl6 = false;
                        long currentTimeStamp = this.getAsDayTimestamp(this.getTimestamp(it));
                        Integer knownPosition = this._headersPositionsMap.get(currentTimeStamp);
                        if (knownPosition == null) {
                            FullMessageRow message = this.headerOfTimeStamp(this.context, currentTimeStamp);
                            onDateHeaderChangedListener.onDateHeaderAdded(0, message);
                            ((Map)this._headersPositionsMap).put(currentTimeStamp, 0);
                            int n3 = diff;
                            diff = n3 + 1;
                        } else if (knownPosition != 0) {
                            onDateHeaderChangedListener.onDateHeaderMoved(knownPosition + diff, 0);
                            ((Map)this._headersPositionsMap).put(currentTimeStamp, 0);
                        }
                    }
                }
            }
        }
        int addedItems = this.applyListChanges(diff, rows, onDateHeaderChangedListener);
        this._knownListSize = rows.size() + addedItems;
    }

    @NotNull
    public final Map<Long, Integer> getHeaders() {
        return this._headersPositionsMap;
    }

    public final void clearDateHeaders() {
        this._headersPositionsMap.clear();
    }

    private final FullMessageRow headerOfTimeStamp(@NotNull Context $this$headerOfTimeStamp, long timestamp) {
        FullMessageRow fullMessageRow = FullMessageRow.createDateHeader((long)timestamp, (String)DateHeaderUtilsKt.getFormattedTimestamp($this$headerOfTimeStamp, timestamp));
        Intrinsics.checkExpressionValueIsNotNull((Object)fullMessageRow, (String)"FullMessageRow.createDat\u2026ttedTimestamp(timestamp))");
        return fullMessageRow;
    }

    /*
     * WARNING - void declaration
     */
    private final int applyListChanges(int diff, List<? extends FullMessageRow> rows, OnDateHeaderChangedListener onDateHeaderChangedListener) {
        int added = 0;
        int n = CollectionsKt.getLastIndex(rows);
        int n2 = 1;
        while (n >= n2) {
            void index;
            FullMessageRow current = rows.get((int)index);
            FullMessageRow previous = rows.get((int)(index - true));
            if (!this.isDateHeader(current) && !this.isSentInTheSameDayAs(current, previous)) {
                long currentTimeStamp = this.getAsDayTimestamp(this.getTimestamp(current));
                Integer knownPosition = this._headersPositionsMap.get(currentTimeStamp);
                if (knownPosition == null) {
                    FullMessageRow message = this.headerOfTimeStamp(this.context, currentTimeStamp);
                    onDateHeaderChangedListener.onDateHeaderAdded((int)index, message);
                    ((Map)this._headersPositionsMap).put(currentTimeStamp, (int)index);
                    ++added;
                } else if (diff + knownPosition - added != index) {
                    onDateHeaderChangedListener.onDateHeaderMoved(knownPosition + diff, (int)(index - added));
                    ((Map)this._headersPositionsMap).put(currentTimeStamp, (int)index);
                }
            }
            --index;
        }
        return added;
    }

    private final boolean isSentInTheSameDayAs(@NotNull FullMessageRow $this$isSentInTheSameDayAs, FullMessageRow row) {
        long next;
        long current = this.getAsDayTimestamp(this.getTimestamp($this$isSentInTheSameDayAs));
        return current == (next = this.getAsDayTimestamp(this.getTimestamp(row)));
    }

    private final long getAsDayTimestamp(long $this$asDayTimestamp) {
        return DateUtils.getBeginningOfDayTime((long)$this$asDayTimestamp);
    }

    private final long getTimestamp(@NotNull FullMessageRow $this$timestamp) {
        MessagingChatMessage messagingChatMessage = $this$timestamp.getMessagingChatMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)messagingChatMessage, (String)"messagingChatMessage");
        return messagingChatMessage.getTimeStamp();
    }

    private final boolean isDateHeader(@NotNull FullMessageRow $this$isDateHeader) {
        MessagingChatMessage messagingChatMessage = $this$isDateHeader.getMessagingChatMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)messagingChatMessage, (String)"messagingChatMessage");
        return messagingChatMessage.getMessageType() == MessagingChatMessage.MessageType.DATE_HEADER;
    }

    public DateHeaderHelper(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        DateHeaderHelper dateHeaderHelper = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        dateHeaderHelper._headersPositionsMap = hashMap;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\f"}, d2={"Lcom/liveperson/infra/messaging_ui/uicomponents/list/header/DateHeaderHelper$OnDateHeaderChangedListener;", "", "onDateHeaderAdded", "", "position", "", "messageRow", "Lcom/liveperson/messaging/model/FullMessageRow;", "onDateHeaderMoved", "oldPosition", "newPosition", "onDateHeaderRemoved", "messaging_ui_release"})
    public static interface OnDateHeaderChangedListener {
        public void onDateHeaderRemoved(int var1);

        public void onDateHeaderAdded(int var1, @NotNull FullMessageRow var2);

        public void onDateHeaderMoved(int var1, int var2);
    }
}

