/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.uicomponents.IScrollDownIndicator;
import java.util.IllegalFormatException;

public class ScrollDownIndicator
extends ConstraintLayout
implements IScrollDownIndicator {
    private static String TAG = "ScrollDownIndicator";
    private TextView mCounter;
    private TextView mSummary;
    private MODE mMode = MODE.CLOSE;
    private boolean isSummaryEnabled = true;
    private ImageView mBackground;
    private ViewPropertyAnimator animator;

    public ScrollDownIndicator(Context context) {
        super(context);
        this.init(context);
    }

    public ScrollDownIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ScrollDownIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.lpmessaging_ui_scroll_indicator, (ViewGroup)this);
        this.isSummaryEnabled = Configuration.getBoolean((int)R.bool.scroll_down_indicator_unread_summary_enabled);
        this.setVisibility(4);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mCounter = (TextView)this.findViewById(R.id.scroll_down_indicator_unread_counter);
        this.mSummary = (TextView)this.findViewById(R.id.scroll_down_indicator_unread_summary);
        this.mBackground = (ImageView)this.findViewById(R.id.scroll_down_indicator_background);
    }

    @Override
    public void setOnClickListener(View.OnClickListener l) {
        this.mBackground.setOnClickListener(l);
    }

    private void hideExtraData() {
        this.mCounter.setVisibility(4);
        this.mSummary.setVisibility(4);
    }

    @Override
    public boolean isExpand() {
        return this.mMode == MODE.OPEN_EXPAND;
    }

    @Override
    public void resetAndHide() {
        if (this.mMode != MODE.CLOSE) {
            this.mMode = MODE.CLOSE;
            this.hideExtraData();
            if (this.animator != null) {
                this.animator.cancel();
            }
            this.animator = this.animate().setStartDelay(100L).translationX((float)this.getWidth());
        }
    }

    @Override
    public void resetAndShowCollapsed() {
        if (this.mMode != MODE.OPEN_COLLAPSED) {
            if (this.animator != null) {
                this.animator.cancel();
            }
            if (this.mMode == MODE.CLOSE) {
                this.setTranslationX(this.getWidth());
            }
            this.mMode = MODE.OPEN_COLLAPSED;
            this.hideExtraData();
            this.animator = this.animate().translationX((float)(this.mSummary.getWidth() + this.mCounter.getWidth()));
            this.setVisibility(0);
            this.mBackground.setContentDescription((CharSequence)this.getResources().getString(R.string.lp_accessibility_scroll_down_indicator_description));
        }
    }

    @Override
    public void show(int numOfUnreadAgentMessages, String lastMessage) {
        if (numOfUnreadAgentMessages > 0) {
            this.mCounter.setVisibility(0);
            String unread = String.valueOf(numOfUnreadAgentMessages);
            this.mCounter.setText((CharSequence)unread);
            this.mCounter.announceForAccessibility((CharSequence)this.getUnreadMessageAnnouncement(numOfUnreadAgentMessages));
            this.mBackground.setContentDescription((CharSequence)this.getContentDescriptionForUnread(numOfUnreadAgentMessages));
            if (this.animator != null) {
                this.animator.cancel();
            }
            if (this.isSummaryEnabled) {
                this.mSummary.setText((CharSequence)lastMessage);
                this.mSummary.setVisibility(0);
                this.setVisibility(0);
                float textWidth = this.mSummary.getPaint().measureText(this.mSummary.getText().toString());
                float excessTextViewWidth = (float)this.mSummary.getWidth() - textWidth;
                float xTranslation = excessTextViewWidth > 0.0f ? excessTextViewWidth : 0.0f;
                this.animator = this.animate().translationX(xTranslation);
            } else {
                this.mSummary.setText(null);
                this.mSummary.setVisibility(8);
                this.setVisibility(0);
                this.animator = this.animate().translationX((float)this.mSummary.getWidth());
            }
            this.mMode = MODE.OPEN_EXPAND;
        } else {
            this.resetAndHide();
        }
    }

    @NonNull
    private String getContentDescriptionForUnread(int unread) {
        return this.getResources().getString(R.string.lp_accessibility_scroll_down_indicator_description) + " " + this.getUnreadMessageAnnouncement(unread);
    }

    private String getUnreadMessageAnnouncement(int unreadCnt) {
        String unreadMsgBase = this.getResources().getQuantityString(R.plurals.lp_unread_message, unreadCnt);
        try {
            return String.format(unreadMsgBase, unreadCnt);
        }
        catch (IllegalFormatException ex) {
            LPLog.INSTANCE.d(TAG, "Failed to format lp_unread_message", (Throwable)ex);
            return "";
        }
    }

    private static enum MODE {
        CLOSE,
        OPEN_COLLAPSED,
        OPEN_EXPAND;

    }
}

