/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import com.liveperson.infra.log.LPLog;

public class ListBehavior
extends CoordinatorLayout.Behavior<View> {
    public ListBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean layoutDependsOn(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View dependency) {
        return dependency instanceof Snackbar.SnackbarLayout;
    }

    public boolean onDependentViewChanged(@NonNull CoordinatorLayout parent, View child, View dependency) {
        float translationY = Math.min(0.0f, dependency.getTranslationY() - (float)dependency.getHeight());
        child.setTranslationY(translationY);
        return true;
    }

    public void onDependentViewRemoved(CoordinatorLayout parent, View child, @NonNull View dependency) {
        LPLog.INSTANCE.d("ListBehavior", "onDependentViewRemoved parent.getBottom() = " + parent.getBottom() + " child.getBottom() = " + child.getBottom());
        super.onDependentViewRemoved(parent, child, dependency);
        float translationY = Math.min(0, parent.getBottom() - child.getBottom());
        child.setTranslationY(translationY);
    }
}

