/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.fragment;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.Fragment;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.NestedFragmentsContainerCallbacks;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualItemAction;
import com.liveperson.infra.utils.PicassoUtils;
import com.squareup.picasso.Callback;
import java.io.File;

public class FullImageFragment
extends Fragment
implements MenuItem.OnMenuItemClickListener {
    public static final String TAG = FullImageFragment.class.getSimpleName();
    public static String KEY_IMAGE_URI_STRING = "imageUri";
    private String mImageUriString;
    private ContextualItemAction mContextualItemAction;
    private NestedFragmentsContainerCallbacks mNestedFragmentsContainerCallbacks;

    public static FullImageFragment newInstance(String imageUriString) {
        Bundle args = new Bundle();
        args.putString(KEY_IMAGE_URI_STRING, imageUriString);
        FullImageFragment fragment = new FullImageFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.onFragmentCreated();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.getArguments() != null) {
            this.mImageUriString = this.getArguments().getString(KEY_IMAGE_URI_STRING);
        }
        return inflater.inflate(R.layout.lpmessaging_ui_fragment_full_image, container, false);
    }

    private void onFragmentCreated() {
        if (this.getParentFragment() instanceof ContextualItemAction && this.getParentFragment() instanceof NestedFragmentsContainerCallbacks) {
            this.mContextualItemAction = (ContextualItemAction)this.getParentFragment();
        }
        if (this.getParentFragment() instanceof NestedFragmentsContainerCallbacks) {
            this.mNestedFragmentsContainerCallbacks = (NestedFragmentsContainerCallbacks)this.getParentFragment();
            return;
        }
        this.mNestedFragmentsContainerCallbacks = new NestedFragmentsContainerCallbacks.NullNestedFragmentsContainerCallbacks();
    }

    public void onViewCreated(final @NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.getActivity() == null) {
            return;
        }
        LPLog.INSTANCE.d(TAG, "onViewCreated: ImageUriString: " + this.mImageUriString);
        InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        ImageView fullImageView = (ImageView)view.findViewById(R.id.lpui_full_image_view);
        fullImageView.setOnCreateContextMenuListener((menu2, v, menuInfo) -> {
            MenuInflater inflater = this.getActivity().getMenuInflater();
            inflater.inflate(R.menu.lpmessaging_ui_item_copy_menu, (Menu)menu2);
            if (!TextUtils.isEmpty((CharSequence)this.mImageUriString)) {
                menu2.findItem(R.id.context_menu_share).setVisible(true);
                menu2.findItem(R.id.context_menu_share).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this);
                menu2.findItem(R.id.context_menu_save).setVisible(true);
                menu2.findItem(R.id.context_menu_save).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this);
                menu2.findItem(R.id.context_menu_copy).setVisible(false);
            }
        });
        ViewCompat.setAccessibilityDelegate((View)fullImageView, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
                super.onPopulateAccessibilityEvent(host, event);
                host.setClickable(false);
                host.setLongClickable(true);
            }
        });
        PicassoUtils.get((Context)this.requireContext()).load(new File(this.mImageUriString)).into(fullImageView, new Callback(){

            public void onSuccess() {
                view.findViewById(R.id.lpui_full_image_progress_bar).setVisibility(8);
                view.findViewById(R.id.lpui_full_image_view).setVisibility(0);
            }

            public void onError(Exception e) {
            }
        });
    }

    public boolean onMenuItemClick(MenuItem item) {
        if (item.getItemId() == R.id.context_menu_share) {
            this.mContextualItemAction.performFileAction(this.mImageUriString, ContextualItemAction.Action.SHARE);
            return true;
        }
        if (item.getItemId() == R.id.context_menu_save) {
            this.mContextualItemAction.performSaveFile(this.mImageUriString);
            return true;
        }
        return false;
    }

    public void onResume() {
        super.onResume();
        this.mNestedFragmentsContainerCallbacks.setFullImageMode(true);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mNestedFragmentsContainerCallbacks.setFullImageMode(false);
    }
}

