/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.fragment;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PorterDuff;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.MimeTypeMap;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentTransaction;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.api.response.types.CSAT;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.api.sdk.PermissionType;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.IPermissionCallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging_ui.MessagingUIFactory;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.dialog.NewUserDialog;
import com.liveperson.infra.messaging_ui.fragment.CaptionPreviewFragment;
import com.liveperson.infra.messaging_ui.fragment.CobrowseFragment;
import com.liveperson.infra.messaging_ui.fragment.ConnectionStatusController;
import com.liveperson.infra.messaging_ui.fragment.ConversationFragmentCallbacks;
import com.liveperson.infra.messaging_ui.fragment.ConversationViewCallback;
import com.liveperson.infra.messaging_ui.fragment.FeedbackFragment;
import com.liveperson.infra.messaging_ui.fragment.FullImageFragment;
import com.liveperson.infra.messaging_ui.fragment.IConnectable;
import com.liveperson.infra.messaging_ui.fragment.NestedFragmentsContainerCallbacks;
import com.liveperson.infra.messaging_ui.fragment.SecuredFormFragment;
import com.liveperson.infra.messaging_ui.notification.NotificationController;
import com.liveperson.infra.messaging_ui.uicomponents.AmsEnterMessage;
import com.liveperson.infra.messaging_ui.uicomponents.AttachmentMenu;
import com.liveperson.infra.messaging_ui.uicomponents.IScrollDownIndicator;
import com.liveperson.infra.messaging_ui.uicomponents.ScrollDownIndicator;
import com.liveperson.infra.messaging_ui.uicomponents.inlinemessages.InlineMessagesController;
import com.liveperson.infra.messaging_ui.uicomponents.list.ChatMessageListRecyclerView;
import com.liveperson.infra.messaging_ui.utils.ConversationInBackgroundService;
import com.liveperson.infra.messaging_ui.utils.ConversationStateHandler;
import com.liveperson.infra.messaging_ui.utils.LpFileProvider;
import com.liveperson.infra.messaging_ui.utils.StringUtils;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualItemAction;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.IActivityProvider;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.MessagingContextualActionModeBehavior;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.MessagingContextualSimpleMenuBehavior;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.ui.view.adapter.viewholder.BaseViewHolder;
import com.liveperson.infra.ui.view.uicomponents.IConnectionChangedCustomView;
import com.liveperson.infra.ui.view.uicomponents.IConversationProvider;
import com.liveperson.infra.ui.view.uicomponents.IEnterMessageListener;
import com.liveperson.infra.utils.AccessibilityChecker;
import com.liveperson.infra.utils.FileUtils;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.LocaleUtils;
import com.liveperson.infra.utils.UIUtils;
import com.liveperson.lpappointmentscheduler.AppointmentSchedulerFragment;
import com.liveperson.lpappointmentscheduler.models.LPAppointmentInfo;
import com.liveperson.lpdatepicker.CalendarInitInfo;
import com.liveperson.lpdatepicker.DatePickerActivity;
import com.liveperson.lpdatepicker.Type;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.CoBrowseManager;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.utils.FileSharingUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConversationFragment
extends Fragment
implements NestedFragmentsContainerCallbacks,
ContextualItemAction,
ConversationViewCallback,
IConnectable {
    public static final String TAG = "ConversationFragment";
    public static final String BUNDLE_CONVERSATION_ID = "bundle_conversation_id";
    private static final String BUNDLE_RECYCLER_LAYOUT_STATE = "chat_messaging_list_recycler_view_state";
    private static final String BUNDLE_CONTEXTUAL_BEHAVIOR_STATE = "bundle_contextual_behavior_state";
    private static final String BUNDLE_CONTEXTUAL_BEHAVIOR_STATE_FILE = "bundle_contextual_behavior_state_file";
    public static final int PICK_PHOTO_FOR_MESSAGE = 1545;
    public static final int REQUEST_TAKE_PHOTO = 1546;
    public static final int PICK_DOCUMENT_FOR_MESSAGE = 1547;
    private static final String SDK_MODE = "SDKMode";
    private static final int REQUEST_EXTERNAL_STORAGE = 1;
    private static final int REQUEST_CAMERA = 2;
    private static final int REQUEST_RECORD = 3;
    private static final int REQUEST_CREATE_NEW_FILE = 4;
    private static final int REQUEST_CAMERA_COBROWSE = 5;
    private static final int REQUEST_RECORD_COBROWSE = 6;
    private static final int REQUEST_DATE_PICKER = 7;
    private static final String PREF_LP_PHOTO = "pref_lp_photo";
    private static final String PREF_SAVE_FILE_WITH_PERMISSIONS = "pref_save_file_with_permissions";
    private static final String PREF_SAVE_FILE_PATH = "pref_save_file_path";
    private static final String PREF_STORAGE_PERMISSION_DIALOG_STATUS = "pref_storage_permission_dialog_status";
    private static final String PREF_CAMERA_PERMISSION_DIALOG_STATUS = "pref_camera_permission_dialog_status";
    private static final String PREF_RECORD_PERMISSION_DIALOG_STATUS = "pref_record_permission_dialog_status";
    protected ChatMessageListRecyclerView mRecyclerView;
    protected TextView mEmptyView;
    protected AmsEnterMessage mEnterMessageLayout;
    protected RelativeLayout mConversationLayout;
    protected LocalBroadcastReceiver mConnectionReceiver;
    protected LocalBroadcastReceiver mConversationStateChangeReceiver;
    protected LocalBroadcastReceiver mDialogStateChangeReceiver;
    protected LocalBroadcastReceiver mFormStateChangeReceiver;
    protected LocalBroadcastReceiver mCobrowseWebviewReceiver;
    protected LocalBroadcastReceiver mCobrowseReceivedReceiver;
    protected LocalBroadcastReceiver mAgentTypingReceiver;
    protected LocalBroadcastReceiver mUnAuthenticatedUserExpired;
    protected LocalBroadcastReceiver mFileUploadStatusReceiver;
    protected ConversationFragmentCallbacks mFragmentContainer;
    protected FullImageFragment mFullImageFragment;
    protected InlineMessagesController mInlineMessagesController;
    protected String mBrandId;
    protected LPAuthenticationParams mLPAuthenticationParams;
    protected ConversationViewParams mConversationViewParams;
    protected IConversationProvider mIConversationProvider;
    protected String conversationId;
    protected ContextualActionBehavior mContextualActionBehavior;
    private AttachmentMenu mAttachmentMenu;
    private ConnectionStatusController mConnectionStatusController;
    private boolean mReadOnlyMode = false;
    private boolean mLastSocketReady;
    private boolean mIsTypingAnnouncementEnabledInBubble;
    private boolean mIsSDKInActivityMode;
    private Parcelable mSavedRecyclerLayoutState;
    private ArrayList<Integer> mContextualBehaviorStateData;
    private boolean mContextualBehaviorIsFile;
    private boolean mIsDocumentPermissionRequested;
    private boolean isPerformingFileOperation;
    private boolean isPickingDate;
    private boolean isRequestingPermission;
    private String mPendingCobrowseDialogId;
    private String mPendingCobrowseUrl;
    private boolean hasSocketBeenOpened;
    private boolean isAuthenCompleted;
    private View mLoadingView;

    public static ConversationFragment newInstance(String brandId, LPAuthenticationParams lpAuthenticationParams, ConversationViewParams conversationViewParams, boolean isSDKActivity) {
        Bundle args = new Bundle();
        args.putString("brand_id", brandId);
        args.putParcelable("auth_key", (Parcelable)lpAuthenticationParams);
        args.putBoolean("read_only", conversationViewParams.isViewOnlyMode());
        args.putParcelable("view_params", (Parcelable)conversationViewParams);
        args.putBoolean(SDK_MODE, isSDKActivity);
        ConversationFragment fragment = new ConversationFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        LocaleUtils.getInstance().init(context);
        if (MessagingFactory.getInstance().getController() != null) {
            MessagingFactory.getInstance().getController().initMaskedMessage(context);
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mContextualBehaviorStateData = savedInstanceState.getIntegerArrayList(BUNDLE_CONTEXTUAL_BEHAVIOR_STATE);
            this.mContextualBehaviorIsFile = savedInstanceState.getBoolean(BUNDLE_CONTEXTUAL_BEHAVIOR_STATE_FILE, false);
        }
        this.mBrandId = this.getArguments().getString("brand_id");
        this.mLPAuthenticationParams = (LPAuthenticationParams)this.getArguments().getParcelable("auth_key");
        this.mReadOnlyMode = this.getArguments().getBoolean("read_only");
        this.mConversationViewParams = (ConversationViewParams)this.getArguments().getParcelable("view_params");
        if (this.mConversationViewParams != null) {
            this.mReadOnlyMode = this.mConversationViewParams.isViewOnlyMode();
        }
        this.mIsSDKInActivityMode = this.getArguments().getBoolean(SDK_MODE);
        boolean isSdkVersionChanged = PreferenceManager.getInstance().getBooleanValue("SDK_VERSION_CHANGED_CLEAR_DATABASE_KEY", "appLevelPreferences", false);
        if (isSdkVersionChanged) {
            LPLog.INSTANCE.d(TAG, "Doing tasks when upgrading sdk version");
            if (PreferenceManager.getInstance().getBooleanValue("RESET_DB_ENCRYPTION_SERVICE_KEY", "appLevelPreferences", false)) {
                LPLog.INSTANCE.d(TAG, "Need to reset DBEncryptionService");
                MessagingFactory.getInstance().getController().resetDBEncryptionService();
                PreferenceManager.getInstance().remove("RESET_DB_ENCRYPTION_SERVICE_KEY", "appLevelPreferences");
            }
            this.clearDBToReFetchHistoryFromTheServer();
            PreferenceManager.getInstance().setBooleanValue("SDK_VERSION_CHANGED_CLEAR_DATABASE_KEY", "appLevelPreferences", false);
        }
        this.initConversationProvider();
        this.createContextualActionBehavior();
    }

    private void createContextualActionBehavior() {
        this.mContextualActionBehavior = Configuration.getBoolean((int)R.bool.contextual_menu_on_toolbar) ? new MessagingContextualActionModeBehavior(this, this.mContextualBehaviorStateData, this.mContextualBehaviorIsFile) : new MessagingContextualSimpleMenuBehavior(this, this.mContextualBehaviorStateData, this.mContextualBehaviorIsFile);
    }

    public void onStart() {
        super.onStart();
        ConversationStateHandler.setIsConversationFragmentRunning(true);
        this.setActivityProvider();
    }

    public void onStop() {
        super.onStop();
        LPLog.INSTANCE.d(TAG, "onStop:");
        boolean isUnAuth = MessagingFactory.getInstance().getController().mAccountsController.isInUnAuthMode(this.mBrandId);
        if ((this.isPerformingFileOperation || this.isPickingDate) && isUnAuth) {
            this.startConversationBackgroundService();
        }
        this.clearActivityProvider();
        MessagingFactory.getInstance().getController().amsDialogs.clearFetchConversationRequestDialogs();
    }

    private void startConversationBackgroundService() {
        try {
            Intent intent = new Intent(this.getActivity().getBaseContext(), ConversationInBackgroundService.class);
            intent.putExtra("bundle_brand_id", this.mBrandId);
            this.getActivity().startService(intent);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000E7, "Failed to start ConversationInBackgroundService: ", (Throwable)e);
        }
    }

    private void stopConversationBackgroundService() {
        try {
            if (this.isServiceRunning(ConversationInBackgroundService.class)) {
                this.getActivity().stopService(new Intent(this.getActivity().getBaseContext(), ConversationInBackgroundService.class));
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000E8, "Failed to stop ConversationInBackground service: ", (Throwable)e);
        }
    }

    private boolean isServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)this.getActivity().getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    private void clearActivityProvider() {
        this.mContextualActionBehavior.setActivityProvider(null);
    }

    private void setActivityProvider() {
        IActivityProvider activityProvider = () -> ((ConversationFragment)this).getActivity();
        this.mContextualActionBehavior.setActivityProvider(activityProvider);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        LPLog.INSTANCE.d(TAG, "onCreateView = " + this.mBrandId);
        View view = inflater.inflate(R.layout.lpmessaging_ui_fragment_conversation, container, false);
        if (savedInstanceState != null) {
            this.conversationId = savedInstanceState.getString(BUNDLE_CONVERSATION_ID);
            this.mReadOnlyMode = savedInstanceState.getBoolean("read_only");
        }
        if (!this.mIsSDKInActivityMode) {
            Bitmap background = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.conversation_background);
            if (background != null) {
                view.setBackground(this.getResources().getDrawable(R.drawable.conversation_background));
            } else {
                view.setBackgroundColor(ContextCompat.getColor((Context)this.requireContext(), (int)R.color.conversation_background));
            }
        }
        return view;
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mConversationLayout = (RelativeLayout)view.findViewById(R.id.lpui_list_enter_msg_container);
        this.mAttachmentMenu = (AttachmentMenu)view.findViewById(R.id.attachment_menu);
        this.mRecyclerView = (ChatMessageListRecyclerView)view.findViewById(R.id.lpui_recycler_view);
        this.mEmptyView = (TextView)view.findViewById(R.id.lpui_recycler_view_empty_view);
        this.mLoadingView = view.findViewById(R.id.lpui_loading_view);
        int cacheSize = Configuration.getInteger((int)R.integer.recycler_view_cache_size);
        this.mRecyclerView.setItemViewCacheSize(cacheSize);
        LPLog.INSTANCE.d(TAG, "onViewCreated: Set RecyclerView cache size to " + cacheSize);
        this.mEnterMessageLayout = (AmsEnterMessage)view.findViewById(R.id.lpui_enter);
        this.mEnterMessageLayout.setBrandIdProvider(this.mIConversationProvider);
        this.mEnterMessageLayout.setEnterMessageListener(new IEnterMessageListener(){

            public void onMessageSent() {
            }

            public void onVoiceRecordingPermissionRequired(IPermissionCallback permissionCallback) {
                if (Build.VERSION.SDK_INT >= 23) {
                    if (ConversationFragment.this.verifyRecordPermission((Activity)ConversationFragment.this.getActivity())) {
                        if (permissionCallback != null) {
                            permissionCallback.onPermissionsGranted();
                        }
                    } else {
                        permissionCallback.onPermissionsDenied();
                    }
                } else if (permissionCallback != null) {
                    permissionCallback.onPermissionsGranted();
                }
            }
        });
        this.mEnterMessageLayout.setVisibility(this.mReadOnlyMode ? 8 : 0);
        this.mEnterMessageLayout.setOverflowMenu(this.mAttachmentMenu);
        this.mAttachmentMenu.setListener(new AttachmentMenu.AttachmentMenuListener(){

            @Override
            public void onGalleryButtonPressed() {
                ConversationFragment.this.mAttachmentMenu.hide();
                if (Build.VERSION.SDK_INT >= 23) {
                    if (ConversationFragment.this.verifyStoragePermissions((Activity)ConversationFragment.this.getActivity())) {
                        ConversationFragment.this.startGallery();
                    }
                } else {
                    ConversationFragment.this.startGallery();
                }
            }

            @Override
            public void onCameraButtonPressed() {
                ConversationFragment.this.mAttachmentMenu.hide();
                if (Build.VERSION.SDK_INT >= 23) {
                    if (ConversationFragment.this.verifyCameraPermission((Activity)ConversationFragment.this.getActivity())) {
                        ConversationFragment.this.startCamera();
                    }
                } else {
                    ConversationFragment.this.startCamera();
                }
            }

            @Override
            public void onDocumentButtonPressed() {
                ConversationFragment.this.mAttachmentMenu.hide();
                if (Build.VERSION.SDK_INT >= 23) {
                    ConversationFragment.this.mIsDocumentPermissionRequested = true;
                    if (ConversationFragment.this.verifyStoragePermissions((Activity)ConversationFragment.this.getActivity())) {
                        ConversationFragment.this.openDocumentProvider();
                        ConversationFragment.this.mIsDocumentPermissionRequested = false;
                    }
                } else {
                    ConversationFragment.this.openDocumentProvider();
                }
            }
        });
        this.mConnectionStatusController = (ConnectionStatusController)view.findViewById(R.id.lpmessaging_ui_connection_status_view);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        LPLog.INSTANCE.d(TAG, "onActivityCreated");
        super.onActivityCreated(savedInstanceState);
        this.attachActivity(this.getActivity());
        boolean isInitialized = MessagingUIFactory.getInstance().isInitialized();
        LPLog.INSTANCE.d(TAG, "onActivityCreated isInitialized = " + isInitialized);
        if (!isInitialized) {
            LPLog.INSTANCE.d(TAG, "onActivityCreated removing fragment! ");
            try {
                this.getActivity().getSupportFragmentManager().beginTransaction().remove((Fragment)this).commit();
            }
            catch (Exception error) {
                String className = this.getActivity() != null ? this.getActivity().getClass().getName() : "";
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000150, "onActivityCreated: Failed to remove attached fragment from activity: " + className, (Throwable)error);
            }
            return;
        }
        MessagingFactory.getInstance().getController().removeClearHistoryFlag(this.mBrandId);
        MessagingFactory.getInstance().getController().setConversationViewParams(this.mConversationViewParams);
        MessagingFactory.getInstance().getController().updateWelcomeMessage(this.mBrandId);
        if (!TextUtils.isEmpty((CharSequence)PreferenceManager.getInstance().getStringValue("CONSUMER_UNREGISTER_PUSHER_PREFERENCE_KEY", this.mBrandId, ""))) {
            MessagingFactory.getInstance().getController().unregisterPusherOnLiteLogout(this.mBrandId, PreferenceManager.getInstance().getStringValue("CONSUMER_UNREGISTER_PUSHER_PREFERENCE_KEY", this.mBrandId, ""));
        }
        if (savedInstanceState != null) {
            this.mSavedRecyclerLayoutState = savedInstanceState.getParcelable(BUNDLE_RECYCLER_LAYOUT_STATE);
            this.initRelevantToolbar();
        }
        this.initRecyclerView();
        boolean isTypingAnnouncementEnabled = Configuration.getBoolean((int)R.bool.announce_agent_typing);
        boolean isTypingAnnouncementEnabledInMessageBubble = Configuration.getBoolean((int)R.bool.show_agent_typing_in_message_bubble);
        this.mIsTypingAnnouncementEnabledInBubble = isTypingAnnouncementEnabled && isTypingAnnouncementEnabledInMessageBubble;
        this.mInlineMessagesController = new InlineMessagesController((Context)this.getActivity(), this.getResources(), this.getView(), this.mIConversationProvider);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putString(BUNDLE_CONVERSATION_ID, this.conversationId);
        outState.putBoolean("read_only", this.mReadOnlyMode);
        if (this.mRecyclerView != null && this.mRecyclerView.getLayoutManager() != null && this.mContextualActionBehavior != null) {
            outState.putParcelable(BUNDLE_RECYCLER_LAYOUT_STATE, this.mRecyclerView.getLayoutManager().onSaveInstanceState());
            outState.putIntegerArrayList(BUNDLE_CONTEXTUAL_BEHAVIOR_STATE, this.mContextualActionBehavior.getListOfSelectedItems());
            outState.putBoolean(BUNDLE_CONTEXTUAL_BEHAVIOR_STATE_FILE, this.mContextualActionBehavior.getIfFileSelectedBeforeOrientation());
        } else {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000014D, "onSaveInstanceState is called when ConversationFragment is not initialized");
        }
        super.onSaveInstanceState(outState);
    }

    protected void initRecyclerView() {
        IScrollDownIndicator scrollDownIndicator = Configuration.getBoolean((int)R.bool.scroll_down_indicator_enabled) ? (ScrollDownIndicator)this.getView().findViewById(R.id.lpui_scroll_down_indicator) : new IScrollDownIndicator.NullImplementation();
        this.mRecyclerView.initData(MessagingFactory.getInstance().getController(), this.mIConversationProvider.getBrandId(), scrollDownIndicator, this.mContextualActionBehavior, this);
    }

    protected void attachActivity(FragmentActivity activity) {
        this.mFragmentContainer = activity instanceof ConversationFragmentCallbacks ? (ConversationFragmentCallbacks)activity : new ConversationFragmentCallbacks.NullConversationFragmentCallbacks();
    }

    private void onConnectionChanged(boolean isConnected) {
        FeedbackFragment feedbackFragment;
        LPLog.INSTANCE.d(TAG, "onConnectionChanged isConnected = " + isConnected);
        this.mEnterMessageLayout.onConnectionChanged(isConnected);
        if (this.mRecyclerView != null) {
            this.mRecyclerView.onConnectionChanged(isConnected);
        }
        if (isConnected) {
            MessagingFactory.getInstance().getController().changeChatState(this.mBrandId, this.mBrandId, ChatState.ACTIVE);
            MessagingFactory.getInstance().getController().amsConversations.notifyClosedConversationFromDB(this.mBrandId);
        }
        if (this.getActivity() instanceof IConnectionChangedCustomView) {
            ((IConnectionChangedCustomView)this.getActivity()).onConnectionChanged(isConnected);
        }
        if ((feedbackFragment = this.getFeedbackFragment()) != null) {
            feedbackFragment.onConnectionChanged(isConnected);
        }
    }

    public boolean verifyStoragePermissions(Activity activity) {
        String STORAGE_PERMISSION = Build.VERSION.SDK_INT >= 33 ? "android.permission.READ_MEDIA_IMAGES" : "android.permission.WRITE_EXTERNAL_STORAGE";
        int permission2 = ContextCompat.checkSelfPermission((Context)activity, (String)STORAGE_PERMISSION);
        if (permission2 == 0) {
            return true;
        }
        PermissionType permissionType = PermissionType.PHOTO_SHARING;
        if (this.mIsDocumentPermissionRequested) {
            permissionType = PermissionType.DOCUMENT_SHARING;
        }
        MessagingFactory.getInstance().getController().mEventsProxy.onUserActionOnPreventedPermission(permissionType);
        String[] PERMISSIONS_STORAGE = Build.VERSION.SDK_INT >= 33 ? new String[]{"android.permission.READ_MEDIA_IMAGES"} : new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
        this.requestPermissions(PERMISSIONS_STORAGE, 1);
        return false;
    }

    public boolean verifyRecordPermission(Activity activity) {
        int recordPermissions = ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.RECORD_AUDIO");
        if (recordPermissions == 0) {
            return true;
        }
        MessagingFactory.getInstance().getController().mEventsProxy.onUserActionOnPreventedPermission(PermissionType.VOICE_RECORDING);
        String[] PERMISSIONS_RECORD = new String[]{"android.permission.RECORD_AUDIO"};
        this.requestPermissions(PERMISSIONS_RECORD, 3);
        return false;
    }

    public boolean verifyCameraPermission(Activity activity) {
        int cameraPermissionStatus;
        boolean cameraPermissionDeclared = ConversationFragment.hasPermissionInManifest((Context)activity, "android.permission.CAMERA");
        int n = cameraPermissionStatus = !cameraPermissionDeclared ? 0 : ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.CAMERA");
        if (cameraPermissionStatus == 0) {
            return true;
        }
        MessagingFactory.getInstance().getController().mEventsProxy.onUserActionOnPreventedPermission(PermissionType.PHOTO_SHARING);
        String[] PERMISSIONS_CAMERA = new String[]{"android.permission.CAMERA"};
        this.isRequestingPermission = true;
        this.requestPermissions(PERMISSIONS_CAMERA, 2);
        return false;
    }

    private static boolean hasPermissionInManifest(@NonNull Context context, @NonNull String permissionName) {
        String packageName = context.getPackageName();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 4096);
            String[] declaredPermissions = packageInfo.requestedPermissions;
            if (declaredPermissions != null) {
                for (String p : declaredPermissions) {
                    if (!p.equals(permissionName)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        PermissionType permissionType = null;
        String permission2 = null;
        boolean shouldDisplayPermissionDialog = false;
        this.isRequestingPermission = false;
        switch (requestCode) {
            case 1: {
                LPLog.INSTANCE.d(TAG, "permission result = " + (grantResults.length > 0 ? Integer.valueOf(grantResults[0]) : "empty"));
                shouldDisplayPermissionDialog = PreferenceManager.getInstance().getBooleanValue(PREF_STORAGE_PERMISSION_DIALOG_STATUS, this.mBrandId, false);
                if (this.checkAllPermissionsGranted(grantResults)) {
                    if (PreferenceManager.getInstance().getBooleanValue(PREF_SAVE_FILE_WITH_PERMISSIONS, this.mBrandId, false)) {
                        this.saveFileToPublicDownloadsDir(PreferenceManager.getInstance().getStringValue(PREF_SAVE_FILE_PATH, this.mBrandId, null));
                    } else if (this.mIsDocumentPermissionRequested) {
                        this.openDocumentProvider();
                        this.mIsDocumentPermissionRequested = false;
                    } else {
                        this.startGallery();
                    }
                    return;
                }
                if (this.mIsDocumentPermissionRequested) {
                    permissionType = PermissionType.DOCUMENT_SHARING;
                    this.mIsDocumentPermissionRequested = false;
                } else {
                    permissionType = PermissionType.PHOTO_SHARING;
                }
                if (Build.VERSION.SDK_INT >= 33) {
                    permission2 = "android.permission.READ_MEDIA_IMAGES";
                    break;
                }
                permission2 = "android.permission.WRITE_EXTERNAL_STORAGE";
                break;
            }
            case 2: {
                shouldDisplayPermissionDialog = PreferenceManager.getInstance().getBooleanValue(PREF_CAMERA_PERMISSION_DIALOG_STATUS, this.mBrandId, false);
                if (this.checkAllPermissionsGranted(grantResults)) {
                    this.startCamera();
                    return;
                }
                permissionType = PermissionType.PHOTO_SHARING;
                permission2 = "android.permission.CAMERA";
                break;
            }
            case 3: {
                shouldDisplayPermissionDialog = PreferenceManager.getInstance().getBooleanValue(PREF_RECORD_PERMISSION_DIALOG_STATUS, this.mBrandId, false);
                if (this.checkAllPermissionsGranted(grantResults)) {
                    return;
                }
                permissionType = PermissionType.VOICE_RECORDING;
                permission2 = "android.permission.RECORD_AUDIO";
                break;
            }
            case 5: {
                shouldDisplayPermissionDialog = PreferenceManager.getInstance().getBooleanValue(PREF_CAMERA_PERMISSION_DIALOG_STATUS, this.mBrandId, false);
                if (this.checkAllPermissionsGranted(grantResults)) {
                    this.showCobrowseFragment(this.mPendingCobrowseDialogId, this.mPendingCobrowseUrl);
                    return;
                }
                permissionType = PermissionType.PHOTO_SHARING;
                permission2 = "android.permission.CAMERA";
                break;
            }
            case 6: {
                shouldDisplayPermissionDialog = PreferenceManager.getInstance().getBooleanValue(PREF_RECORD_PERMISSION_DIALOG_STATUS, this.mBrandId, false);
                if (this.checkAllPermissionsGranted(grantResults)) {
                    this.showCobrowseFragment(this.mPendingCobrowseDialogId, this.mPendingCobrowseUrl);
                    return;
                }
                permissionType = PermissionType.VOICE_RECORDING;
                permission2 = "android.permission.RECORD_AUDIO";
            }
        }
        if (permissionType == null) {
            LPLog.INSTANCE.w(TAG, "onRequestPermissionsResult: permissionType was not set");
            return;
        }
        try {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.requireActivity(), permission2)) {
                LPLog.INSTANCE.d(TAG, "User pressed deny button without checking 'Don't ask again' box");
                MessagingFactory.getInstance().getController().mEventsProxy.onUserDeniedPermission(permissionType, false);
                if (shouldDisplayPermissionDialog) {
                    this.setPermissionDialogDisplayStatus(requestCode, false);
                }
            } else if (grantResults[0] == -1) {
                LPLog.INSTANCE.d(TAG, "User pressed 'deny' with flag 'do not show this again' or just pressed to access the gallery anytime afterwards");
                MessagingFactory.getInstance().getController().mEventsProxy.onUserDeniedPermission(permissionType, true);
                boolean showRationale = this.shouldShowRequestPermissionRationale(permissions[0]);
                if (!showRationale && shouldDisplayPermissionDialog) {
                    LPLog.INSTANCE.d(TAG, "user also CHECKED never ask again");
                    this.showPermissionDialog(requestCode);
                } else if (!shouldDisplayPermissionDialog) {
                    this.setPermissionDialogDisplayStatus(requestCode, true);
                }
            }
        }
        catch (Exception error) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000E9, "onRequestPermissionsResult: Failed to validate permission states ", (Throwable)error);
        }
    }

    private void setPermissionDialogDisplayStatus(int requestCode, boolean value) {
        switch (requestCode) {
            case 1: {
                PreferenceManager.getInstance().setBooleanValue(PREF_STORAGE_PERMISSION_DIALOG_STATUS, this.mBrandId, value);
                break;
            }
            case 2: {
                PreferenceManager.getInstance().setBooleanValue(PREF_CAMERA_PERMISSION_DIALOG_STATUS, this.mBrandId, value);
                break;
            }
            case 3: {
                PreferenceManager.getInstance().setBooleanValue(PREF_RECORD_PERMISSION_DIALOG_STATUS, this.mBrandId, value);
                break;
            }
            default: {
                return;
            }
        }
    }

    private boolean checkAllPermissionsGranted(@NonNull int[] grantResults) {
        if (grantResults.length < 1) {
            return false;
        }
        for (int grantResult : grantResults) {
            if (grantResult == 0) continue;
            return false;
        }
        return true;
    }

    private void startGallery() {
        Intent pickIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        pickIntent.setType("image/*");
        LPLog.INSTANCE.d(TAG, "startGallery: starting gallery");
        this.isPerformingFileOperation = true;
        this.startActivityForResult(pickIntent, 1545);
    }

    public void startCamera() {
        try {
            Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
            if (takePictureIntent.resolveActivity(this.requireActivity().getPackageManager()) != null) {
                Uri imageUri = ImageUtils.createImageFileForCamera((Context)this.requireContext(), (String)this.mBrandId);
                takePictureIntent.putExtra("output", (Parcelable)imageUri);
                PreferenceManager.getInstance().setStringValue(PREF_LP_PHOTO, this.mBrandId, imageUri.toString());
                LPLog.INSTANCE.d(TAG, "startCamera: starting camera");
                if (Build.VERSION.SDK_INT < 21) {
                    List resolvedIntentActivities = this.requireContext().getPackageManager().queryIntentActivities(takePictureIntent, 65536);
                    for (ResolveInfo resolvedIntentInfo : resolvedIntentActivities) {
                        String packageName = resolvedIntentInfo.activityInfo.packageName;
                        this.requireContext().grantUriPermission(packageName, imageUri, 3);
                    }
                }
                LPLog.INSTANCE.d(TAG, "startCamera: imageUri = " + imageUri);
                this.isPerformingFileOperation = true;
                this.startActivityForResult(takePictureIntent, 1546);
            } else {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000157, "Failed to resolve Activity when starting camera");
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000EA, "IOException launching camera Intent", (Throwable)e);
        }
    }

    public void openDocumentProvider() {
        String[] allDocumentTypes = new String[]{"pdf", "docx", "pptx", "xlsx", "jpg", "jpeg", "png", "gif"};
        ArrayList<String> mimeTypes = new ArrayList<String>();
        for (String documentType : allDocumentTypes) {
            String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(documentType);
            mimeTypes.add(mimeType);
        }
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setType("*/*");
        intent.putExtra("android.intent.extra.MIME_TYPES", mimeTypes.toArray(new String[0]));
        intent.putExtra("android.content.extra.SHOW_ADVANCED", true);
        this.isPerformingFileOperation = true;
        this.startActivityForResult(intent, 1547);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        LPLog.INSTANCE.d(TAG, "onActivityResult");
        super.onActivityResult(requestCode, resultCode, data);
        LPLog.INSTANCE.d(TAG, "onActivityResult: resultCode = " + resultCode);
        if (requestCode == 1545 && resultCode == -1) {
            if (data == null || data.getData() == null) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000EB, "onActivityResult: image URI selected from Gallery is null");
                return;
            }
            String imagePath = ImageUtils.getImagePath((Context)this.getActivity(), (Uri)data.getData());
            int orientation = ImageUtils.getImageRotation((String)imagePath, (boolean)false);
            this.startFileUpload(data.getData(), orientation, false);
        } else if (requestCode == 1546 && resultCode == -1) {
            String imageUriString = PreferenceManager.getInstance().getStringValue(PREF_LP_PHOTO, this.mBrandId, null);
            if (imageUriString == null) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000EC, "onActivityResult: image URI from preferences is null");
                return;
            }
            Uri imageUri = Uri.parse((String)imageUriString);
            String imagePath = ImageUtils.getImagePath((Context)this.getActivity(), (Uri)imageUri);
            int orientation = ImageUtils.getImageRotation((String)imagePath, (boolean)true);
            if (Build.VERSION.SDK_INT < 21) {
                this.getContext().revokeUriPermission(imageUri, 3);
            }
            this.startFileUpload(Uri.parse((String)imageUriString), orientation, true);
        } else if (requestCode == 1547 && resultCode == -1) {
            if (data != null && data.getData() != null) {
                int orientation = 0;
                FileSharingType fileType = FileSharingUtils.getFileSharingTypeFromUri((String)data.getData().toString(), (Context)this.getActivity());
                if (!FileSharingUtils.isDocumentType((FileSharingType)fileType)) {
                    String imagePath = ImageUtils.getImagePath((Context)this.getActivity(), (Uri)data.getData());
                    orientation = ImageUtils.getImageRotation((String)imagePath, (boolean)false);
                }
                this.startFileUpload(data.getData(), orientation, false);
            }
        } else if (requestCode == 4 && resultCode == -1 && data != null) {
            Uri publicDir = data.getData();
            String filePath = PreferenceManager.getInstance().getStringValue(PREF_SAVE_FILE_PATH, this.mBrandId, null);
            if (!TextUtils.isEmpty((CharSequence)filePath)) {
                File privateDir = new File(filePath);
                boolean isFileSaved = FileUtils.writeFileContent((Context)this.requireActivity().getApplicationContext(), (File)privateDir, (Uri)publicDir);
                if (isFileSaved) {
                    String toastMessageSaved = this.getResources().getString(R.string.lp_file_saved_to_toast);
                    Toast.makeText((Context)this.getActivity(), (CharSequence)toastMessageSaved, (int)1).show();
                }
                LPLog.INSTANCE.d(TAG, "Saving file from: srcPath = [" + privateDir.getPath() + "] to dstPath [" + publicDir.getPath() + "] isFileSaved = " + isFileSaved);
            }
        } else if (requestCode == 7) {
            this.isPickingDate = false;
            if (resultCode == -1 && data != null) {
                this.sendDatePickerResult(data);
            } else if (resultCode == 0) {
                LPLog.INSTANCE.i(TAG, "REQUEST_DATE_PICKER - RESULT_CANCELED: no date selected");
            }
        }
    }

    private void sendDatePickerResult(Intent resultIntent) {
        long startDate = resultIntent.getLongExtra("RESULT_START_DATE_IN_SECONDS", 0L);
        long endDate = resultIntent.getLongExtra("RESULT_END_DATE_IN_SECONDS", 0L);
        Type pickerType = null;
        String dateFormat = "";
        if (resultIntent.hasExtra("CALENDAR_INIT_INFO")) {
            CalendarInitInfo calendarInfo = (CalendarInitInfo)resultIntent.getParcelableExtra("CALENDAR_INIT_INFO");
            pickerType = calendarInfo.getType();
            dateFormat = calendarInfo.getDateFormat();
        }
        LPLog.INSTANCE.i(TAG, "REQUEST_DATE_PICKER - RESULT_OK: StartDate = " + startDate + " - EndDate = " + endDate + " - pickerType = " + pickerType + " - dateFormat = " + dateFormat);
        Locale locale = LocaleUtils.getInstance().getLocale();
        LPLog.INSTANCE.i(TAG, "locale = " + locale);
        JSONObject metadata = new JSONObject();
        try {
            metadata.put("type", (Object)"datePickerResponse");
            metadata.put("start", startDate);
            if (pickerType == Type.RANGE) {
                metadata.put("end", endDate);
            }
        }
        catch (JSONException e) {
            Toast.makeText((Context)this.requireContext(), (int)R.string.lpmessaging_general_error_message, (int)0).show();
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000015E, e.getMessage(), (Throwable)e);
        }
        LPLog.INSTANCE.i(TAG, "REQUEST_DATE_PICKER - RESULT_OK: metadata = " + metadata.toString());
        String message = pickerType == Type.SINGLE ? StringUtils.INSTANCE.createDatePickerMessage(startDate, dateFormat, locale) : StringUtils.INSTANCE.createDatePickerMessage(startDate, endDate, dateFormat, locale);
        LPLog.INSTANCE.i(TAG, "REQUEST_DATE_PICKER - RESULT_OK: formatted message = " + message);
        MessagingFactory.getInstance().getController().sendMessage(this.mBrandId, this.mBrandId, message, new DeliveryStatusUpdateInfo(new JSONArray().put((Object)metadata)));
    }

    private void startFileUpload(Uri data, int orientation, boolean imageFromCamera) {
        if (FileSharingUtils.getFileSharingTypeFromUri((String)data.toString(), (Context)this.getContext()) != FileSharingType.UNKNOWN) {
            CaptionPreviewFragment fragment = this.getCaptionPreviewFragment();
            if (fragment == null || !fragment.isAdded()) {
                this.executePendingFragmentTransaction(fragment);
                CaptionPreviewFragment captionPreviewFragment = CaptionPreviewFragment.newInstance(this.mBrandId, data.toString(), orientation, imageFromCamera);
                FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
                transaction.add(R.id.lpui_fragment_child_container, (Fragment)captionPreviewFragment, "CaptionPreviewFragment");
                transaction.addToBackStack("CaptionPreviewFragment");
                this.setAccessibilityImportance(false);
                transaction.commit();
            }
        } else {
            Toast.makeText((Context)this.getContext(), (int)R.string.lp_failed_file_type_not_supported, (int)1).show();
        }
    }

    public void onResume() {
        boolean isSocketReady;
        super.onResume();
        LPLog.INSTANCE.d(TAG, "onResume: ");
        Messaging messagingController = MessagingFactory.getInstance().getController();
        if (messagingController == null) {
            LPLog.INSTANCE.w(TAG, "onResume: Messaging is not initialized");
            return;
        }
        ConversationStateHandler.setConversationBackgroundStatus(false);
        this.stopConversationBackgroundService();
        if (!this.isRequestingPermission) {
            this.isPerformingFileOperation = false;
        }
        this.isPickingDate = false;
        if (ConversationStateHandler.isHideConversationCalledInBackground()) {
            LPLog.INSTANCE.i(TAG, "Hiding the conversation screen");
            ConversationStateHandler.setIsHideConversationCalledInBackground(false);
            try {
                this.getActivity().getSupportFragmentManager().beginTransaction().remove((Fragment)this).commit();
            }
            catch (Exception error) {
                String className = this.getActivity() != null ? this.getActivity().getClass().getName() : "";
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000150, "onResume: Failed to remove attached fragment from activity: " + className, (Throwable)error);
            }
            return;
        }
        this.refreshLoadingViewOption();
        this.registerBroadCastReceivers();
        ForegroundService.getInstance().register(this.mBrandId, this.mIConversationProvider.getTargetId());
        this.moveToForeground();
        NotificationController.instance.clearMessagesForBrand((Context)this.getActivity(), this.mBrandId);
        boolean isInitialized = messagingController.isInitialized();
        LPLog.INSTANCE.i(TAG, "onResume: Is messaging initialized? " + isInitialized);
        this.mLastSocketReady = isSocketReady = isInitialized && messagingController.mConnectionController.isSocketReady(this.mBrandId);
        this.onConnectionChanged(isSocketReady);
        boolean isUpdated = isInitialized && messagingController.mConnectionController.isUpdated(this.mBrandId);
        this.mEnterMessageLayout.onUpdate(isUpdated);
        boolean isConnecting = isInitialized && messagingController.mConnectionController.isConnecting(this.mBrandId);
        this.mConnectionStatusController.initState(isSocketReady, isConnecting |= isInitialized && messagingController.mAccountsController.isInUnAuthMode(this.mBrandId));
        if (this.mInlineMessagesController != null) {
            this.mInlineMessagesController.register(this.mBrandId);
        }
        this.mEnterMessageLayout.restoreTypedText();
        if (this.mRecyclerView != null && !InternetConnectionService.isNetworkAvailable()) {
            LPLog.INSTANCE.d(TAG, "No internet connection. Adding message listener");
            this.mRecyclerView.onForeground();
        }
    }

    private void moveToForeground() {
        MessagingFactory.getInstance().getController().moveToForeground(this.mBrandId, this.mLPAuthenticationParams, this.mConversationViewParams);
    }

    @Override
    public void connect() {
        MessagingFactory.getInstance().getController().connect(this.mBrandId, this.mLPAuthenticationParams, this.mConversationViewParams);
    }

    public void onPause() {
        super.onPause();
        LPLog.INSTANCE.d(TAG, "onPause: ");
        this.unregisterFragment();
        this.moveToBackground();
        ConversationStateHandler.setConversationBackgroundStatus(true);
        if (this.mEnterMessageLayout != null) {
            this.mEnterMessageLayout.onBackground();
        }
        if (this.mRecyclerView != null) {
            this.mRecyclerView.onBackground();
        }
    }

    protected void unregisterFragment() {
        this.unregisterForegroundService();
        this.unregisterReceivers();
        this.unregisterControllers();
    }

    private void moveToBackground() {
        try {
            if (!this.isRequestingPermission) {
                boolean isUnAuth = MessagingFactory.getInstance().getController().mAccountsController.isInUnAuthMode(this.mBrandId);
                if (isUnAuth) {
                    if (!this.isPerformingFileOperation && !this.isPickingDate) {
                        this.clearDBToReFetchHistoryFromTheServer();
                    }
                    MessagingFactory.getInstance().getController().moveToBackground(this.mBrandId, 0L);
                } else {
                    MessagingFactory.getInstance().getController().moveToBackground(this.mBrandId, (long)Configuration.getInteger((int)R.integer.background_timeout_short_ms));
                }
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000ED, "Failed to clear database or to close socket.");
        }
    }

    private void clearDBToReFetchHistoryFromTheServer() {
        PreferenceManager.getInstance().remove("hide_closed_conversations", this.mBrandId);
        MessagingFactory.getInstance().getController().mConnectionController.clearLastUpdateTime(this.mBrandId);
        MessagingFactory.getInstance().getController().clearAllConversationData(this.mBrandId);
        FileUtils.deleteFileAsync((File)this.getActivity().getApplicationContext().getFilesDir());
    }

    protected void registerBroadCastReceivers() {
        this.registerConnectionReceiver();
        this.registerConversationStateChangedReceiver();
        this.registerDialogStateChangedReceiver();
        this.registerFormStateChangeReceiver();
        this.registerCobrowseWebviewReceiver();
        this.registerCobrowseReceivedReceiver();
        this.mConnectionStatusController.registerToChanges(this);
        this.registerAgentTypingReceiver();
        this.registerUnAuthenticatedUserExpired();
        this.registerFileUploadStatusReceiver();
    }

    private void registerAgentTypingReceiver() {
        if (this.mAgentTypingReceiver == null) {
            this.mAgentTypingReceiver = new LocalBroadcastReceiver.Builder().addAction("agent_typing").build((context, intent) -> {
                boolean isTyping = intent.getBooleanExtra("is_typing", false);
                String originatorId = intent.getStringExtra("originator_id");
                if (!isTyping || this.mConversationViewParams != null && this.mConversationViewParams.getHistoryConversationsStateToDisplay() != LPConversationsHistoryStateToDisplay.CLOSE) {
                    this.setAgentIsTyping(isTyping, originatorId);
                }
            });
        } else {
            this.mAgentTypingReceiver.register();
        }
    }

    private void registerUnAuthenticatedUserExpired() {
        if (this.mUnAuthenticatedUserExpired == null) {
            this.mUnAuthenticatedUserExpired = new LocalBroadcastReceiver.Builder().addAction("LP_ON_UNAUTHENTICATED_USER_EXPIRED_INTENT_ACTION").build((context, intent) -> {
                if (this.getFragmentManager() != null) {
                    NewUserDialog.getInstance().show(this.getFragmentManager(), "NewUserDialog");
                }
            });
        } else {
            this.mUnAuthenticatedUserExpired.register();
        }
    }

    protected void registerFormStateChangeReceiver() {
        if (this.mFormStateChangeReceiver == null) {
            this.mFormStateChangeReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_UPDATE_FORM_URL").build((context, intent) -> {
                LPLog.INSTANCE.d(TAG, "Got PCI update onBroadcastReceived");
                if (intent != null) {
                    String url = intent.getStringExtra("url");
                    String invitation_id = intent.getStringExtra("invitation_id");
                    String form_title = intent.getStringExtra("form_title");
                    if (!url.isEmpty()) {
                        this.showSecuredFormFragment(url, invitation_id, form_title);
                    }
                }
            });
        } else {
            this.mFormStateChangeReceiver.register();
        }
    }

    protected void registerCobrowseWebviewReceiver() {
        if (this.mCobrowseWebviewReceiver == null) {
            this.mCobrowseWebviewReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_COBROWSE_WEBVIEW").build((context, intent) -> {
                if (intent != null) {
                    UIUtils.hideKeyboard((Activity)this.requireActivity());
                    String dialogId = intent.getStringExtra("dialogId");
                    String url = intent.getStringExtra("url");
                    String action = intent.getStringExtra("action");
                    boolean join = intent.getBooleanExtra("join", false);
                    if (join) {
                        if (url != null && !url.isEmpty()) {
                            this.showCobrowseFragment(dialogId, url);
                        } else {
                            LPLog.INSTANCE.d(TAG, "CoBrowseLogic url is NULL");
                        }
                    } else {
                        CoBrowseManager.instance.cancelCobrowse(this.mBrandId, url, action);
                    }
                }
            });
        } else {
            this.mCobrowseWebviewReceiver.register();
        }
    }

    protected void registerCobrowseReceivedReceiver() {
        if (this.mCobrowseReceivedReceiver == null) {
            this.mCobrowseReceivedReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_COBROWSE_RECEIVED").build((context, intent) -> {
                String automaticMessageKey = intent.getStringExtra("automaticMessageKey");
                String dialogId = intent.getStringExtra("dialogId");
                boolean newMessages = intent.getBooleanExtra("newMessages", false);
                if (newMessages) {
                    if (this.mRecyclerView != null && this.mRecyclerView.getAdapter() != null) {
                        this.mRecyclerView.getAdapter().notifyDataSetChanged();
                    }
                    LPLog.INSTANCE.d(TAG, "CoBrowseLogic cobrowsefragment registerCobrowseReceivedReceiver received system message " + LPLog.INSTANCE.mask((Object)automaticMessageKey));
                }
                String activeDialogId = MessagingFactory.getInstance().getController().amsDialogs.getActiveCoBrowseDialogId();
                LPLog.INSTANCE.d(TAG, "automaticMessageKey: " + LPLog.INSTANCE.mask((Object)automaticMessageKey) + " for dialogId: " + dialogId);
                if (activeDialogId != null && activeDialogId.equals(dialogId) && (automaticMessageKey.equals("COLLABORATION_CALL_ENDED_BY_CONSUMER") || automaticMessageKey.equals("COLLABORATION_CALL_ENDED_BY_AGENT") || automaticMessageKey.equals("COLLABORATION_CALL_DECLINED") || automaticMessageKey.equals("COLLABORATION_CALL_CANCEL_INVITATION") || automaticMessageKey.equals("COLLABORATION_CALL_NOT_JOINED") || automaticMessageKey.equals("COLLABORATION_CALL_TIMEOUT") || automaticMessageKey.equals("COLLABORATION_CALL_ENDED"))) {
                    LPLog.INSTANCE.i(TAG, "registerCobrowseReceivedReceiver: Remove CoBrows message from view");
                    this.mRecyclerView.removeCoBrowsMessageFromView(dialogId);
                    MessagingFactory.getInstance().getController().amsDialogs.setActiveCoBrowseDialogId(null);
                }
            });
        } else {
            this.mCobrowseReceivedReceiver.register();
        }
    }

    protected void registerDialogStateChangedReceiver() {
        if (this.mDialogStateChangeReceiver == null) {
            this.mDialogStateChangeReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_UPDATE_CSAT_DIALOG").addAction("BROADCAST_UPDATE_DIALOG_CLOSED").build((context, intent) -> {
                String targetId = intent.getStringExtra("KEY_DIALOG_TARGET_ID");
                LPLog.INSTANCE.d(TAG, "Got update on brand - dialog state: " + targetId);
                if (this.mIConversationProvider.getTargetId().equals(targetId) && intent.getAction() != null && intent.getAction().equals("BROADCAST_UPDATE_DIALOG_CLOSED")) {
                    String dialogId = intent.getStringExtra("DIALOG_ID");
                    this.handleClosedDialog(dialogId);
                }
            });
        } else {
            this.mDialogStateChangeReceiver.register();
        }
    }

    protected void registerConversationStateChangedReceiver() {
        if (this.mConversationStateChangeReceiver == null) {
            this.mConversationStateChangeReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_UPDATE_CSAT_CONVERSATION").addAction("BROADCAST_UPDATE_CONVERSATION_CLOSED").build((context, intent) -> {
                String targetId = intent.getStringExtra("CONVERSATION_TARGET_ID");
                LPLog.INSTANCE.d(TAG, "Got update on brand - conversation state: " + targetId);
                if (this.mIConversationProvider.getTargetId().equals(targetId) && intent.getAction() != null) {
                    if (intent.getAction().equals("BROADCAST_UPDATE_CONVERSATION_CLOSED")) {
                        String conversationID = intent.getStringExtra("CONVERSATION_ID");
                        this.handleConversationClosed(conversationID);
                    } else if (intent.getAction().equals("BROADCAST_UPDATE_CSAT_CONVERSATION")) {
                        String conversationID = intent.getStringExtra("CONVERSATION_ID");
                        ConversationState state = ConversationState.values()[intent.getIntExtra("CONVERSATION_STATE", -1)];
                        int isShowedCsatValue = intent.getIntExtra("CONVERSATION_SHOWED_CSAT", CSAT.CSAT_SHOW_STATUS.NO_VALUE.getValue());
                        CSAT.CSAT_SHOW_STATUS isShowedCsat = CSAT.CSAT_SHOW_STATUS.parse((int)isShowedCsatValue);
                        String agentId = intent.getStringExtra("CONVERSATION_ASSIGNED_AGENT");
                        this.handleConversationUpdate(conversationID, state, isShowedCsat, agentId);
                    }
                }
            });
        } else {
            this.mConversationStateChangeReceiver.register();
        }
    }

    protected void registerFileUploadStatusReceiver() {
        if (this.mFileUploadStatusReceiver == null) {
            this.mFileUploadStatusReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_FILE_UPLOAD_FAILED").build((context, intent) -> {
                String errorMessage = intent.getStringExtra("KEY_FILE_UPLOAD_ERROR");
                this.showErrorDialog(errorMessage);
            });
        } else {
            this.mFileUploadStatusReceiver.register();
        }
    }

    protected void handleClosedDialog(String dialogId) {
        Messaging controller = MessagingFactory.getInstance().getController();
        controller.updateWelcomeMessage(this.mBrandId);
        this.hideCobrowseFragment();
        controller.sendBroadcastStopTyping();
        this.mRecyclerView.removeQuickRepliesMessageOfDialog(dialogId);
        Dialog dialog = controller.amsDialogs.getActiveDialog();
        if (dialog == null) {
            controller.refreshEngagement();
        }
        if (dialog != null && dialog.getDialogType() == DialogType.POST_SURVEY) {
            this.tryToClearCoBrowseDialog(controller);
        }
        controller.sendBroadcastStopTyping();
    }

    protected void handleConversationClosed(String conversationId) {
        boolean shouldClearActiveDialog;
        Messaging controller = MessagingFactory.getInstance().getController();
        this.mRecyclerView.removeQuickRepliesMessageOfConversation(conversationId);
        boolean bl = shouldClearActiveDialog = !controller.amsConversations.isConversationActive(this.mBrandId);
        if (shouldClearActiveDialog) {
            this.tryToClearCoBrowseDialog(controller);
        }
    }

    private void tryToClearCoBrowseDialog(Messaging controller) {
        AmsDialogs dialogs = controller.amsDialogs;
        String activeCoBrowseDialogId = dialogs.getActiveCoBrowseDialogId();
        if (activeCoBrowseDialogId != null) {
            LPLog.INSTANCE.d(TAG, "handleConversationClosed: hiding CoBrows fragment and removing from view");
            this.hideCobrowseFragment();
            this.mRecyclerView.removeCoBrowsMessageFromView(activeCoBrowseDialogId);
            dialogs.setActiveCoBrowseDialogId(null);
        }
    }

    protected void handleConversationUpdate(String conversationID, ConversationState state, CSAT.CSAT_SHOW_STATUS csatShowStatus, String agentId) {
        switch (state) {
            case CLOSE: {
                LPLog.INSTANCE.d(TAG, "handle Dialog Update - conversation is closed. csatShowStatus = " + csatShowStatus);
                this.hideSecuredFormFragment();
                this.hideAppointmentSchedulerFragment();
                this.setAgentIsTyping(false, null);
                if (csatShowStatus == CSAT.CSAT_SHOW_STATUS.NOT_SHOWN) {
                    this.showFeedbackFragment(conversationID, agentId);
                    break;
                }
                this.hideFeedBackFragment();
                break;
            }
            case OPEN: {
                this.hideFeedBackFragment();
                break;
            }
        }
    }

    private void showFeedbackFragment(String conversationID, String agentId) {
        LPLog.INSTANCE.i(TAG, "Dialog is closed.");
        if (!Configuration.getBoolean((int)R.bool.show_feedback)) {
            LPLog.INSTANCE.i(TAG, "show_feedback configuration is set to false");
            return;
        }
        Messaging controller = MessagingFactory.getInstance().getController();
        controller.amsConversations.updateCSAT(this.mBrandId, conversationID);
        controller.amsDialogs.queryDialogsByConversationId(conversationID).setPostQueryOnBackground(dialogs -> {
            boolean doesConversationHasSurveyWithMessages = false;
            for (Dialog dialog : dialogs) {
                if (dialog.getDialogType() != DialogType.POST_SURVEY) continue;
                doesConversationHasSurveyWithMessages = true;
            }
            if (!doesConversationHasSurveyWithMessages && !TextUtils.isEmpty((CharSequence)agentId)) {
                controller.amsUsers.getUserById(agentId).setPostQueryOnUI(data -> {
                    if (data != null) {
                        LPLog.INSTANCE.i(TAG, "Agent available, showing csat screen.");
                        this.onConversationResolved(conversationID);
                        this.showFeedbackFragment(data.getNickname(), data.getAvatarUrl(), conversationID);
                    }
                }).execute();
            } else {
                Infra.instance.postOnMainThread(() -> this.onConversationResolved(conversationID));
            }
        }).execute();
    }

    protected void registerConnectionReceiver() {
        if (this.mConnectionReceiver == null) {
            LocalBroadcastReceiver.Builder connectionReceiverBuilder = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_KEY_SOCKET_READY_ACTION").addAction("BROADCAST_AMS_CONNECTION_UPDATE_ACTION").addAction("BROADCAST_KEY_AUTH_COMPLETED_ACTION");
            LPLog.INSTANCE.d(TAG, "registerConnectionReceiver - lp_hide_ui_until_auth:" + Configuration.getBoolean((int)R.bool.lp_hide_ui_until_auth));
            if (Configuration.getBoolean((int)R.bool.lp_hide_ui_until_auth)) {
                connectionReceiverBuilder.addAction("BROADCAST_SOCKET_OPEN_ACTION");
            }
            this.mConnectionReceiver = connectionReceiverBuilder.build((context, intent) -> {
                String brandId = intent.getStringExtra("BROADCAST_KEY_BRAND_ID");
                if ("BROADCAST_KEY_SOCKET_READY_ACTION".equals(intent.getAction())) {
                    if (this.mBrandId.equals(brandId)) {
                        boolean isConnected = intent.getBooleanExtra("BROADCAST_KEY_SOCKET_READY_EXTRA", false);
                        LPLog.INSTANCE.i(TAG, "Connection changed! new status: " + isConnected + " last status: " + this.mLastSocketReady);
                        if (this.mLastSocketReady != isConnected) {
                            this.mLastSocketReady = isConnected;
                            this.onConnectionChanged(isConnected);
                        }
                    }
                } else if ("BROADCAST_AMS_CONNECTION_UPDATE_ACTION".equals(intent.getAction())) {
                    if (this.mBrandId.equals(brandId)) {
                        boolean isUpdated = intent.getBooleanExtra("BROADCAST_AMS_CONNECTION_UPDATE_EXTRA", false);
                        this.mEnterMessageLayout.onUpdate(isUpdated);
                    }
                } else if ("BROADCAST_KEY_AUTH_COMPLETED_ACTION".equals(intent.getAction())) {
                    if (this.mRecyclerView != null) {
                        this.mRecyclerView.onForeground();
                    }
                    this.isAuthenCompleted = true;
                    if (this.hasSocketBeenOpened && Configuration.getBoolean((int)R.bool.lp_hide_ui_until_auth)) {
                        this.mLoadingView.setVisibility(8);
                    }
                } else if ("BROADCAST_SOCKET_OPEN_ACTION".equals(intent.getAction())) {
                    this.hasSocketBeenOpened = true;
                    if (this.isAuthenCompleted && Configuration.getBoolean((int)R.bool.lp_hide_ui_until_auth)) {
                        this.mLoadingView.setVisibility(8);
                    }
                }
            });
        }
        this.mConnectionReceiver.register();
    }

    protected void unregisterReceivers() {
        this.unregisterBroadcastReceivers(this.mConnectionReceiver, this.mConversationStateChangeReceiver);
        this.unregisterBroadcastReceivers(this.mCobrowseWebviewReceiver, this.mCobrowseReceivedReceiver);
        this.unregisterBroadcastReceivers(this.mDialogStateChangeReceiver, this.mFormStateChangeReceiver);
        this.unregisterBroadcastReceivers(this.mAgentTypingReceiver, this.mUnAuthenticatedUserExpired, this.mFileUploadStatusReceiver);
    }

    protected void unregisterControllers() {
        if (this.mInlineMessagesController != null) {
            this.mInlineMessagesController.unregister();
        }
        if (this.mConnectionStatusController != null) {
            this.mConnectionStatusController.unregister();
        }
    }

    protected void unregisterForegroundService() {
        ForegroundService.getInstance().unregisterBrand(this.mIConversationProvider.getBrandId());
        ForegroundService.getInstance().unregisterTarget(this.mIConversationProvider.getTargetId());
    }

    protected void initConversationProvider() {
        LPLog.INSTANCE.d(TAG, "initConversationProvider");
        this.mBrandId = this.getArguments().getString("brand_id");
        this.mIConversationProvider = new IConversationProvider(){

            public String getBrandId() {
                return ConversationFragment.this.mBrandId;
            }

            public String getTargetId() {
                return ConversationFragment.this.mBrandId;
            }
        };
    }

    public boolean onBackPressed() {
        if (!this.isVisible()) {
            return false;
        }
        FeedbackFragment feedbackFragment = this.getFeedbackFragment();
        if (feedbackFragment != null) {
            if (feedbackFragment.isAdded()) {
                MessagingFactory.getInstance().getController().mEventsProxy.onCsatSkipped();
                return feedbackFragment.slideOutFragment();
            }
            return false;
        }
        SecuredFormFragment securedFormFragment = this.getSecuredFormFragment();
        if (securedFormFragment != null) {
            return securedFormFragment.isAdded() && securedFormFragment.slideOutFragment();
        }
        CobrowseFragment cobrowseFragment = this.getCobrowseFragment();
        if (cobrowseFragment != null && cobrowseFragment.isAdded()) {
            this.setAccessibilityImportance(true);
            return cobrowseFragment.slideOutCobrowseFragment();
        }
        FullImageFragment fullImageFragment = this.getFullImageFragment();
        if (fullImageFragment != null) {
            this.getChildFragmentManager().popBackStack();
            this.setAccessibilityImportance(true);
            return true;
        }
        CaptionPreviewFragment captionPreviewFragment = this.getCaptionPreviewFragment();
        if (captionPreviewFragment != null) {
            this.getChildFragmentManager().popBackStack();
            this.setAccessibilityImportance(true);
            return true;
        }
        AppointmentSchedulerFragment appointmentSchedulerFragment = this.getAppointmentSchedulerFragment();
        if (appointmentSchedulerFragment != null) {
            this.hideAppointmentSchedulerFragment();
            return true;
        }
        if (this.getFragmentManager().getBackStackEntryCount() > 0) {
            this.getFragmentManager().popBackStack();
        }
        this.onConversationFragmentClosed();
        return false;
    }

    public void onDestroy() {
        if (this.mInlineMessagesController != null) {
            this.mInlineMessagesController.hideAll();
        }
        LPLog.INSTANCE.d(TAG, "onDestroy");
        super.onDestroy();
        ConversationStateHandler.setIsConversationFragmentRunning(false);
        Messaging messagingController = MessagingFactory.getInstance().getController();
        if (messagingController != null) {
            messagingController.onConversationDestroyed(this.mBrandId);
        } else {
            LPLog.INSTANCE.w(TAG, "onDestroy: Messaging is not initialized");
        }
    }

    public void initRelevantToolbar() {
        FeedbackFragment feedbackFragment = this.getFeedbackFragment();
        if (feedbackFragment != null) {
            this.mFragmentContainer.setFeedBackMode(true, feedbackFragment);
        }
    }

    protected void onConversationResolved(String conversationServerId) {
        this.conversationId = conversationServerId;
        this.mInlineMessagesController.onConversationResolved();
        UIUtils.hideKeyboard((Activity)this.getActivity());
    }

    private void showFeedbackFragment(String agentNickname, String avatarUrl, String conversationId) {
        LPLog.INSTANCE.d(TAG, "Showing FeedbackFragment - agentNickname = " + LPLog.INSTANCE.mask((Object)agentNickname));
        this.mEnterMessageLayout.enableMicButtonTooltips(false);
        FeedbackFragment fragment = this.getFeedbackFragment();
        if (fragment == null || !fragment.isAdded()) {
            this.executePendingFragmentTransaction(fragment);
            MessagingFactory.getInstance().getController().mEventsProxy.onCsatLaunched();
            FeedbackFragment feedbackFragment = FeedbackFragment.newInstance(agentNickname, avatarUrl, conversationId);
            this.mFragmentContainer.setFeedBackMode(true, feedbackFragment);
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.setCustomAnimations(R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out, R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out);
            transaction.add(R.id.lpui_fragment_child_container, (Fragment)feedbackFragment, "FeedbackFragment");
            transaction.addToBackStack("FeedbackFragment");
            this.setAccessibilityImportance(false);
            transaction.commit();
        }
    }

    private FeedbackFragment getFeedbackFragment() {
        return (FeedbackFragment)this.getChildFragmentManager().findFragmentByTag("FeedbackFragment");
    }

    private SecuredFormFragment getSecuredFormFragment() {
        return (SecuredFormFragment)this.getChildFragmentManager().findFragmentByTag("SecuredFormFragment");
    }

    private CobrowseFragment getCobrowseFragment() {
        return (CobrowseFragment)this.getChildFragmentManager().findFragmentByTag("CobrowseFragment");
    }

    private FullImageFragment getFullImageFragment() {
        return (FullImageFragment)this.getChildFragmentManager().findFragmentByTag(FullImageFragment.TAG);
    }

    private CaptionPreviewFragment getCaptionPreviewFragment() {
        return (CaptionPreviewFragment)this.getChildFragmentManager().findFragmentByTag("CaptionPreviewFragment");
    }

    private AppointmentSchedulerFragment getAppointmentSchedulerFragment() {
        return (AppointmentSchedulerFragment)this.getChildFragmentManager().findFragmentByTag(AppointmentSchedulerFragment.Companion.getTAG());
    }

    private void setAccessibilityImportance(boolean isImportant) {
        if (AccessibilityChecker.exploreByTouchEnabled((Context)this.getActivity())) {
            if (isImportant) {
                this.mConversationLayout.setImportantForAccessibility(1);
            } else {
                this.mConversationLayout.setImportantForAccessibility(4);
            }
        }
    }

    private void showSecuredFormFragment(String url, String invitationId, String formTitle) {
        SecuredFormFragment fragment = this.getSecuredFormFragment();
        if (fragment == null || !fragment.isAdded()) {
            this.executePendingFragmentTransaction(fragment);
            Bundle bundle = new Bundle();
            bundle.putString("url", url);
            bundle.putString("invitation_id", invitationId);
            bundle.putString("form_title", formTitle);
            SecuredFormFragment securedFormFragment = new SecuredFormFragment();
            securedFormFragment.setArguments(bundle);
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.setCustomAnimations(R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out, R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out);
            transaction.add(R.id.lpui_fragment_child_container, (Fragment)securedFormFragment, "SecuredFormFragment");
            transaction.addToBackStack("SecuredFormFragment");
            this.setAccessibilityImportance(false);
            transaction.commit();
        }
    }

    private void hideSecuredFormFragment() {
        SecuredFormFragment fragment = this.getSecuredFormFragment();
        LPLog.INSTANCE.d(TAG, "hideSecuredFormFragment, fragment = " + (Object)((Object)fragment));
        if (fragment != null && fragment.isAdded()) {
            fragment.slideOutSecureFormFragment();
        }
    }

    public boolean verifyCobrowseCameraPermission(Activity activity) {
        int cameraPermissionStatus;
        boolean cameraPermissionDeclared = ConversationFragment.hasPermissionInManifest((Context)activity, "android.permission.CAMERA");
        int n = cameraPermissionStatus = !cameraPermissionDeclared ? 0 : ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.CAMERA");
        if (cameraPermissionStatus == 0) {
            return true;
        }
        String[] PERMISSIONS_CAMERA = new String[]{"android.permission.CAMERA"};
        this.isRequestingPermission = true;
        this.requestPermissions(PERMISSIONS_CAMERA, 5);
        return false;
    }

    public boolean verifyCobrowseRecordPermission(Activity activity) {
        int recordPermissions = ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.RECORD_AUDIO");
        if (recordPermissions == 0) {
            return true;
        }
        String[] PERMISSIONS_RECORD = new String[]{"android.permission.RECORD_AUDIO"};
        this.isRequestingPermission = true;
        this.requestPermissions(PERMISSIONS_RECORD, 6);
        return false;
    }

    private void showCobrowseFragment(String dialogId, String url) {
        this.mPendingCobrowseDialogId = dialogId;
        this.mPendingCobrowseUrl = url;
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.verifyCobrowseCameraPermission((Activity)this.getActivity()) && this.verifyCobrowseRecordPermission((Activity)this.getActivity())) {
                this.internalShowCobrowseFragment(dialogId, url);
            }
        } else {
            this.internalShowCobrowseFragment(dialogId, url);
        }
    }

    private void internalShowCobrowseFragment(String dialogId, String url) {
        CobrowseFragment fragment = this.getCobrowseFragment();
        if (fragment == null || !fragment.isAdded()) {
            this.mPendingCobrowseDialogId = null;
            this.mPendingCobrowseUrl = null;
            this.executePendingFragmentTransaction(fragment);
            CobrowseFragment cobrowseFragment = CobrowseFragment.newInstance(url, dialogId);
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.setCustomAnimations(R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out, R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out);
            transaction.add(R.id.lpui_fragment_child_container, (Fragment)cobrowseFragment, "CobrowseFragment");
            transaction.addToBackStack("CobrowseFragment");
            this.setAccessibilityImportance(false);
            transaction.commit();
        }
    }

    private void hideCobrowseFragment() {
        CobrowseFragment fragment = this.getCobrowseFragment();
        LPLog.INSTANCE.d(TAG, "hideCobrowseFragment, fragment = " + (Object)((Object)fragment));
        if (fragment != null && fragment.isAdded()) {
            fragment.slideOutCobrowseFragment();
        }
    }

    private void hideFeedBackFragment() {
        this.mEnterMessageLayout.enableMicButtonTooltips(true);
        FeedbackFragment fragment = this.getFeedbackFragment();
        LPLog.INSTANCE.d(TAG, "CSAT_FLOW: hideFeedBackFragment, fragment = " + fragment);
        if (fragment != null) {
            fragment.slideOutFragment();
        }
    }

    private void executePendingFragmentTransaction(Fragment fragment) {
        if (fragment != null && !fragment.isAdded()) {
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.remove(fragment);
            transaction.commit();
            this.getChildFragmentManager().executePendingTransactions();
        }
    }

    public void onConversationFragmentClosed() {
        Messaging controller = MessagingFactory.getInstance().getController();
        controller.amsConversations.notifyConversationFragmentClosedEvent();
    }

    @Override
    public void sendCSAT(int starsNumber, int yesNoValue) {
        MessagingFactory.getInstance().getController().sendCSAT(this.mBrandId, this.conversationId, starsNumber, yesNoValue);
    }

    @Override
    public void onSurveySubmitted(String conversationId, int starRating) {
        FeedbackFragment feedbackFragment = this.getFeedbackFragment();
        if (feedbackFragment != null) {
            this.mFragmentContainer.onSurveySubmitted(feedbackFragment);
        }
        MessagingFactory.getInstance().getController().mEventsProxy.onCsatSubmitted(conversationId, starRating);
    }

    private void setAgentIsTyping(boolean isTyping, String originatorId) {
        if (this.mIsTypingAnnouncementEnabledInBubble) {
            this.mRecyclerView.setAgentIsTyping(isTyping, originatorId);
        }
    }

    @Override
    public void setSecureFormMode(boolean on, String formTitle) {
        this.mFragmentContainer.setSecureFormMode(on, formTitle);
    }

    @Override
    public void setCobrowseMode(boolean on) {
        this.mFragmentContainer.setCobrowseMode(on);
    }

    @Override
    public void setFullImageMode(boolean on) {
        this.mFragmentContainer.setFullImageMode(on);
    }

    @Override
    public void setCaptionPreviewMode(boolean on, String title) {
        if (!on) {
            this.setAccessibilityImportance(true);
        }
        this.mFragmentContainer.setCaptionPreviewMode(on, title);
    }

    @Override
    public void slideOutCobrowseFragment() {
        this.mFragmentContainer.setCobrowseMode(false);
        if (this.getActivity() != null) {
            this.getChildFragmentManager().popBackStack();
        }
        if (AccessibilityChecker.exploreByTouchEnabled((Context)this.getActivity())) {
            this.setAccessibilityImportance(true);
            this.mRecyclerView.requestFocus();
            this.mRecyclerView.focusLastItem();
        } else {
            this.mEnterMessageLayout.requestFocus();
        }
    }

    @Override
    public void slideOutSecureFormFragment() {
        this.mFragmentContainer.setSecureFormMode(false, null);
        if (this.getActivity() != null) {
            this.getChildFragmentManager().popBackStack();
        }
        if (AccessibilityChecker.exploreByTouchEnabled((Context)this.getActivity())) {
            this.setAccessibilityImportance(true);
            this.mRecyclerView.requestFocus();
            this.mRecyclerView.focusLastItem();
        } else {
            this.mEnterMessageLayout.requestFocus();
        }
    }

    @Override
    public void slideOutFragment() {
        LPLog.INSTANCE.d(TAG, "CSAT_FLOW: slideOutFragment, popping back stack");
        this.mFragmentContainer.setFeedBackMode(false, null);
        if (this.getActivity() != null) {
            this.getChildFragmentManager().popBackStack();
        }
        LPLog.INSTANCE.d(TAG, "CSAT_FLOW: slideOutFragment, popping back stack completed. getFeedbackFragment() = " + this.getFeedbackFragment());
        MessagingFactory.getInstance().getController().mEventsProxy.onCsatDismissed();
        if (AccessibilityChecker.exploreByTouchEnabled((Context)this.getActivity())) {
            this.setAccessibilityImportance(true);
            this.mRecyclerView.requestFocus();
            this.mRecyclerView.focusLastItem();
        }
    }

    @Override
    public void PerformCopyTextToClipboard(String text) {
        ClipboardManager clipboard = (ClipboardManager)Infra.instance.getApplicationContext().getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"", (CharSequence)text);
        clipboard.setPrimaryClip(clip);
    }

    @Override
    public void performSaveFile(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            LPLog.INSTANCE.d(TAG, "invalid filepath = " + filePath + " cannot save file ");
            return;
        }
        PreferenceManager.getInstance().setStringValue(PREF_SAVE_FILE_PATH, this.mBrandId, filePath);
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.verifyStoragePermissions((Activity)this.getActivity())) {
                this.saveFileToPublicDownloadsDir(filePath);
                PreferenceManager.getInstance().setBooleanValue(PREF_SAVE_FILE_WITH_PERMISSIONS, this.mBrandId, false);
                return;
            }
            PreferenceManager.getInstance().setBooleanValue(PREF_SAVE_FILE_WITH_PERMISSIONS, this.mBrandId, true);
        } else {
            this.saveFileToPublicDownloadsDir(filePath);
        }
    }

    private void saveFileToPublicDownloadsDir(String filePath) {
        try {
            File privateDirectory = new File(filePath);
            String fileName = privateDirectory.getName();
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            String ext = MimeTypeMap.getFileExtensionFromUrl((String)filePath).toLowerCase();
            String type = mime.getMimeTypeFromExtension(ext);
            Intent intent = new Intent("android.intent.action.CREATE_DOCUMENT");
            intent.addCategory("android.intent.category.OPENABLE");
            intent.setType(type);
            intent.putExtra("android.intent.extra.TITLE", fileName);
            this.isPerformingFileOperation = true;
            this.startActivityForResult(intent, 4);
        }
        catch (Exception error) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000EE, "createNewFile: Failed to send request to create new file ", (Throwable)error);
        }
    }

    @Override
    public void performOpenLink(String link, boolean isCustomisedLink, BaseViewHolder.LinkType linkType) {
        try {
            Intent intent = null;
            Uri uri = null;
            switch (linkType) {
                case PHONE: {
                    intent = new Intent("android.intent.action.DIAL");
                    uri = Uri.parse((String)("tel:" + link));
                    break;
                }
                case EMAIL: {
                    intent = new Intent("android.intent.action.SENDTO");
                    uri = Uri.parse((String)("mailto:" + link));
                    break;
                }
                case URL: {
                    String schema;
                    intent = new Intent("android.intent.action.VIEW");
                    try {
                        schema = Uri.parse((String)link).getScheme();
                    }
                    catch (Exception ex) {
                        schema = null;
                    }
                    if (!isCustomisedLink && schema == null) {
                        uri = Uri.parse((String)("http://" + link));
                        break;
                    }
                    uri = Uri.parse((String)link);
                    break;
                }
                case NAVIGATION: {
                    uri = Uri.parse((String)link);
                    intent = new Intent("android.intent.action.VIEW");
                }
            }
            if (intent != null && uri != null) {
                intent.setData(uri);
                if (intent.resolveActivity(this.getActivity().getPackageManager()) != null) {
                    this.startActivity(intent);
                }
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000EF, "Failed to open a link.", (Throwable)e);
        }
    }

    @Override
    public void performFileAction(String filePath, ContextualItemAction.Action action) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            LPLog.INSTANCE.d(TAG, "invalid filepath = " + filePath + " cannot perform action " + action.name());
            return;
        }
        File file = new File(filePath);
        MimeTypeMap mime = MimeTypeMap.getSingleton();
        String ext = MimeTypeMap.getFileExtensionFromUrl((String)filePath).toLowerCase();
        String type = mime.getMimeTypeFromExtension(ext);
        String title = null;
        Uri contentUri = LpFileProvider.getUriForFile((Context)this.getActivity(), (String)(Infra.getFileProviderAuthorityPrefix() + this.getActivity().getApplicationInfo().packageName), (File)file);
        Intent intent = new Intent();
        switch (action) {
            case SHARE: {
                intent.setAction("android.intent.action.SEND");
                intent.putExtra("android.intent.extra.STREAM", (Parcelable)contentUri);
                intent.setDataAndType(contentUri, type);
                intent.setFlags(1);
                title = this.getResources().getString(R.string.lp_file_share);
                break;
            }
            case OPEN: {
                intent.setAction("android.intent.action.VIEW");
                intent.setDataAndType(contentUri, type);
                intent.setFlags(1);
                title = this.getResources().getString(R.string.lp_file_open);
            }
        }
        PackageManager packageManager = this.getActivity().getPackageManager();
        List activities = packageManager.queryIntentActivities(intent, 65536);
        if (activities != null && !activities.isEmpty()) {
            for (ResolveInfo resolvedIntentInfo : activities) {
                String packageName = resolvedIntentInfo.activityInfo.packageName;
                this.getActivity().grantUriPermission(packageName, contentUri, 1);
            }
        }
        this.isPerformingFileOperation = true;
        this.getActivity().startActivity(Intent.createChooser((Intent)intent, (CharSequence)title));
    }

    @Override
    public void onFileClicked(FileSharingType fileSharingType, String filePath, String imageSwiftPath, long messageRowId, long fileRowId, String conversationId) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            MessagingFactory.getInstance().getController().downloadFile(fileSharingType, this.mBrandId, this.mBrandId, imageSwiftPath, messageRowId, fileRowId, conversationId);
        } else if (!this.mContextualActionBehavior.isSelectable()) {
            switch (fileSharingType.getCommonFileType()) {
                case IMAGE: {
                    this.openFullImageScreen(filePath);
                    break;
                }
                case DOCUMENT: {
                    this.performFileAction(filePath, ContextualItemAction.Action.OPEN);
                    break;
                }
            }
        }
    }

    @Override
    public void restoreRecyclerViewInstanceState() {
        if (this.mSavedRecyclerLayoutState != null) {
            LPLog.INSTANCE.d(TAG, "onHistoryLoaded: restoring previous recyclerview state");
            if (this.mRecyclerView.getLayoutManager() != null) {
                this.mRecyclerView.getLayoutManager().onRestoreInstanceState(this.mSavedRecyclerLayoutState);
            }
        }
    }

    @Override
    public void showEmptyView() {
        if (this.mLoadingView.getVisibility() != 8) {
            this.mLoadingView.setVisibility(8);
        }
        if (this.mRecyclerView.getVisibility() != 4) {
            this.mRecyclerView.setVisibility(4);
        }
        if (this.mEmptyView.getVisibility() != 0) {
            this.mEmptyView.setVisibility(0);
        }
    }

    @Override
    public void hideEmptyView() {
        if (Configuration.getBoolean((int)R.bool.lp_hide_ui_until_auth)) {
            if (this.hasSocketBeenOpened && this.isAuthenCompleted) {
                this.mLoadingView.setVisibility(8);
            } else {
                this.mLoadingView.setVisibility(0);
            }
        } else {
            this.mLoadingView.setVisibility(8);
        }
        if (this.mRecyclerView.getVisibility() != 0) {
            this.mRecyclerView.setVisibility(0);
        }
        if (this.mEmptyView.getVisibility() != 4) {
            this.mEmptyView.setVisibility(4);
        }
    }

    @Override
    public void onDatePickerClicked(@NonNull CalendarInitInfo calendarInitInfo) {
        this.isPickingDate = true;
        Intent intent = new Intent(this.requireContext(), DatePickerActivity.class);
        intent.putExtra("CALENDAR_INIT_INFO", (Parcelable)calendarInitInfo);
        this.startActivityForResult(intent, 7);
    }

    @Override
    public void onAppointmentSchedulerRequested(@NotNull LPAppointmentInfo lpAppointmentInfo) {
        AppointmentSchedulerFragment fragment = this.getAppointmentSchedulerFragment();
        if (fragment == null || !fragment.isAdded()) {
            this.executePendingFragmentTransaction((Fragment)fragment);
            Bundle bundle = new Bundle();
            bundle.putParcelable("LPAppointmentInitInfo", (Parcelable)lpAppointmentInfo);
            AppointmentSchedulerFragment appointmentSchedulerFragment = new AppointmentSchedulerFragment();
            appointmentSchedulerFragment.setArguments(bundle);
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.setCustomAnimations(R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out, R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out);
            transaction.add(R.id.lpui_fragment_child_container, (Fragment)appointmentSchedulerFragment, AppointmentSchedulerFragment.Companion.getTAG());
            transaction.addToBackStack(AppointmentSchedulerFragment.Companion.getTAG());
            this.setAccessibilityImportance(false);
            transaction.commit();
            this.mFragmentContainer.hideConversationToolBar(true);
        }
    }

    @Override
    public void onAppointmentSchedulerClosed() {
        if (this.isAdded()) {
            this.hideAppointmentSchedulerFragment();
        } else {
            LPLog.INSTANCE.w(TAG, "onAppointmentSchedulerClosed: Fragment is not added to its activity");
        }
    }

    private void hideAppointmentSchedulerFragment() {
        AppointmentSchedulerFragment appointmentSchedulerFragment = this.getAppointmentSchedulerFragment();
        if (appointmentSchedulerFragment != null) {
            this.getChildFragmentManager().popBackStack();
            this.setAccessibilityImportance(true);
        }
        this.mFragmentContainer.hideConversationToolBar(false);
    }

    private void refreshLoadingViewOption() {
        boolean isSocketReady;
        Messaging controller = MessagingFactory.getInstance().getController();
        if (controller == null) {
            LPLog.INSTANCE.w(TAG, "refreshLoadingViewOption: Messaging is not initialized");
            return;
        }
        boolean bl = isSocketReady = controller.isInitialized() ? controller.mConnectionController.isSocketReady(this.mBrandId) : false;
        if (Configuration.getBoolean((int)R.bool.lp_hide_ui_until_auth) && !isSocketReady) {
            this.hasSocketBeenOpened = false;
            this.isAuthenCompleted = false;
            if (this.mLoadingView != null) {
                this.mLoadingView.setVisibility(0);
            }
        } else if (this.mLoadingView != null) {
            this.mLoadingView.setVisibility(8);
        }
    }

    private void openFullImageScreen(String fullImageLocalPath) {
        this.mFullImageFragment = (FullImageFragment)this.getFragmentManager().findFragmentByTag(FullImageFragment.class.getSimpleName());
        if (this.mFullImageFragment == null) {
            this.mFullImageFragment = FullImageFragment.newInstance(fullImageLocalPath);
        }
        this.setAccessibilityImportance(false);
        FragmentTransaction fragmentTransaction = this.getChildFragmentManager().beginTransaction();
        fragmentTransaction.addToBackStack(FullImageFragment.TAG);
        fragmentTransaction.add(R.id.lpui_fragment_child_container, (Fragment)this.mFullImageFragment, FullImageFragment.TAG);
        fragmentTransaction.commit();
    }

    private void showPermissionDialog(int requestCode) {
        int imageDrawable;
        String dialogTitle = this.getResources().getString(R.string.lp_enable_permission_dialog_title);
        String dialogMessage = this.getResources().getString(R.string.lp_permission_dialog_go_to_settings_message);
        switch (requestCode) {
            case 1: {
                String accessType = this.getResources().getString(R.string.lp_storage_permission_dialog_title);
                dialogTitle = String.format(dialogTitle, accessType);
                dialogMessage = this.getResources().getString(R.string.lp_enable_storage_permission_dialog_message) + " " + String.format(dialogMessage, accessType);
                imageDrawable = R.drawable.lpmessaging_ui_ic_document;
                break;
            }
            case 2: {
                String accessType = this.getResources().getString(R.string.lp_camera_permission_dialog_title);
                dialogTitle = String.format(dialogTitle, accessType);
                dialogMessage = this.getResources().getString(R.string.lp_enable_camera_permission_dialog_message) + " " + String.format(dialogMessage, accessType);
                imageDrawable = R.drawable.lpmessaging_ui_ic_camera;
                break;
            }
            case 3: {
                String accessType = this.getResources().getString(R.string.lp_microphone_permission_dialog_title);
                dialogTitle = String.format(dialogTitle, accessType);
                dialogMessage = this.getResources().getString(R.string.lp_enable_microphone_permission_dialog_message) + " " + String.format(dialogMessage, accessType);
                imageDrawable = R.drawable.lpinfra_ui_ic_mic;
                break;
            }
            default: {
                return;
            }
        }
        try {
            ImageView imageView = new ImageView((Context)this.getActivity());
            imageView.setImageResource(imageDrawable);
            imageView.setColorFilter(ContextCompat.getColor((Context)this.requireContext(), (int)R.color.lp_blue), PorterDuff.Mode.SRC_IN);
            TextView customMessage = new TextView((Context)this.getActivity());
            customMessage.setText((CharSequence)dialogMessage);
            customMessage.setTextColor(ContextCompat.getColor((Context)this.requireContext(), (int)R.color.lp_alert_dialog_title_description_color));
            customMessage.setPadding(50, 50, 50, 0);
            customMessage.setGravity(17);
            new AlertDialog.Builder(this.requireContext(), R.style.LpAlertDialogCustom).setIcon(imageView.getDrawable()).setTitle((CharSequence)dialogTitle).setView((View)customMessage).setCancelable(false).setPositiveButton((CharSequence)this.getResources().getString(R.string.lp_permission_dialog_settings_button), (dialog, which) -> {
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                intent.addFlags(0x10000000);
                Uri uri = Uri.fromParts((String)"package", (String)this.requireActivity().getPackageName(), null);
                intent.setData(uri);
                this.startActivity(intent);
            }).setNegativeButton((CharSequence)this.getResources().getString(R.string.lp_permission_dialog_cancel_button), null).show();
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F0, "Failed to display permission dialog.", (Throwable)e);
        }
    }

    private void showErrorDialog(String message) {
        try {
            if (message.equals("Unsupported file size")) {
                String errorTitle = this.getResources().getString(R.string.lp_not_supported_file_size);
                String errorMessage = this.getResources().getString(R.string.lp_file_size_exceeds);
                new AlertDialog.Builder(this.requireContext(), R.style.LpAlertDialogCustom).setTitle((CharSequence)errorTitle).setMessage((CharSequence)errorMessage).setCancelable(false).setPositiveButton((CharSequence)"OK", null).show();
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F1, "Failed to display error dialog.", (Throwable)e);
        }
    }

    private void unregisterBroadcastReceiverSilently(LocalBroadcastReceiver receiver) {
        if (receiver != null) {
            receiver.unregister();
        }
    }

    private void unregisterBroadcastReceivers(LocalBroadcastReceiver ... receivers) {
        for (LocalBroadcastReceiver receiver : receivers) {
            this.unregisterBroadcastReceiverSilently(receiver);
        }
    }

    static {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
    }
}

