/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.spring.ArmeriaConfigurationNetUtil;
import com.linecorp.armeria.internal.spring.ArmeriaConfigurationUtil;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.docs.DocServiceBuilder;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import com.linecorp.armeria.spring.ArmeriaSettings;
import com.linecorp.armeria.spring.DocServiceConfigurator;
import com.linecorp.armeria.spring.HealthCheckServiceConfigurator;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

public abstract class AbstractArmeriaAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final ArmeriaSettings.Port DEFAULT_PORT = new ArmeriaSettings.Port().setPort(8080).setProtocol(SessionProtocol.HTTP);
    private static final String GRACEFUL_SHUTDOWN = "graceful";

    @Bean
    @Nullable
    public Server armeriaServer(ArmeriaSettings armeriaSettings, Optional<MeterRegistry> meterRegistry, Optional<List<HealthChecker>> healthCheckers, Optional<List<HealthCheckServiceConfigurator>> healthCheckServiceConfigurators, Optional<MeterIdPrefixFunction> meterIdPrefixFunction, Optional<List<ArmeriaServerConfigurator>> armeriaServerConfigurators, Optional<List<Consumer<ServerBuilder>>> armeriaServerBuilderConsumers, Optional<List<DocServiceConfigurator>> docServiceConfigurators) {
        if (!armeriaServerConfigurators.isPresent() && !armeriaServerBuilderConsumers.isPresent()) {
            return null;
        }
        ServerBuilder serverBuilder = Server.builder();
        List<ArmeriaSettings.Port> ports = armeriaSettings.getPorts();
        if (ports.isEmpty()) {
            serverBuilder.port(new ServerPort(DEFAULT_PORT.getPort(), DEFAULT_PORT.getProtocols()));
        } else {
            ArmeriaConfigurationNetUtil.configurePorts(serverBuilder, ports);
        }
        DocServiceBuilder docServiceBuilder = DocService.builder();
        docServiceConfigurators.ifPresent(configurators -> configurators.forEach(configurator -> configurator.configure(docServiceBuilder)));
        armeriaServerConfigurators.ifPresent(configurators -> configurators.forEach(configurator -> configurator.configure(serverBuilder)));
        armeriaServerBuilderConsumers.ifPresent(consumers -> consumers.forEach(consumer -> consumer.accept(serverBuilder)));
        String docsPath = armeriaSettings.getDocsPath();
        ArmeriaConfigurationUtil.configureServerWithArmeriaSettings(serverBuilder, armeriaSettings, meterRegistry.orElse((MeterRegistry)Metrics.globalRegistry), healthCheckers.orElseGet(Collections::emptyList), healthCheckServiceConfigurators.orElseGet(Collections::emptyList), meterIdPrefixFunction.orElse(MeterIdPrefixFunction.ofDefault((String)"armeria.server")));
        if (!Strings.isNullOrEmpty((String)docsPath)) {
            serverBuilder.serviceUnder(docsPath, (HttpService)docServiceBuilder.build());
        }
        Server server = serverBuilder.build();
        ((CompletableFuture)server.start().handle((result, t) -> {
            if (t != null) {
                throw new IllegalStateException("Armeria server failed to start", (Throwable)t);
            }
            return result;
        })).join();
        this.logger.info("Armeria server started at ports: {}", (Object)server.activePorts());
        return server;
    }

    @Bean
    @ConditionalOnProperty(value={"server.shutdown"})
    public ArmeriaServerConfigurator gracefulShutdownServerConfigurator(@Value(value="${server.shutdown}") String shutdown, @Value(value="${spring.lifecycle.timeout-per-shutdown-phase:30s}") Duration duration) {
        if (GRACEFUL_SHUTDOWN.equalsIgnoreCase(shutdown)) {
            return sb -> sb.gracefulShutdownTimeout(duration, duration);
        }
        return sb -> {};
    }
}

