/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.spring;

import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.metric.PrometheusExpositionService;
import com.linecorp.armeria.spring.ArmeriaSettings;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.CollectorRegistry;
import java.util.Optional;
import java.util.Set;

final class PrometheusSupport {
    static boolean addExposition(ArmeriaSettings settings, ServerBuilder server, MeterRegistry meterRegistry) {
        String metricsPath = settings.getMetricsPath();
        assert (metricsPath != null);
        while (true) {
            if (meterRegistry instanceof PrometheusMeterRegistry) {
                CollectorRegistry prometheusRegistry = ((PrometheusMeterRegistry)meterRegistry).getPrometheusRegistry();
                server.service(metricsPath, (HttpService)PrometheusExpositionService.of((CollectorRegistry)prometheusRegistry));
                return true;
            }
            if (!(meterRegistry instanceof CompositeMeterRegistry)) break;
            Set childRegistries = ((CompositeMeterRegistry)meterRegistry).getRegistries();
            Optional<PrometheusMeterRegistry> opt = childRegistries.stream().filter(PrometheusMeterRegistry.class::isInstance).map(PrometheusMeterRegistry.class::cast).findAny();
            if (!opt.isPresent()) {
                return false;
            }
            meterRegistry = (MeterRegistry)opt.get();
        }
        return false;
    }

    private PrometheusSupport() {
    }
}

