/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.spring;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import com.linecorp.armeria.internal.spring.CustomAliasKeyManagerFactory;
import com.linecorp.armeria.internal.spring.DropwizardSupport;
import com.linecorp.armeria.internal.spring.PrometheusSupport;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.encoding.EncodingService;
import com.linecorp.armeria.server.healthcheck.HealthCheckService;
import com.linecorp.armeria.server.healthcheck.HealthCheckServiceBuilder;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.server.metric.MetricCollectingService;
import com.linecorp.armeria.spring.ArmeriaSettings;
import com.linecorp.armeria.spring.HealthCheckServiceConfigurator;
import com.linecorp.armeria.spring.Ssl;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public final class ArmeriaConfigurationUtil {
    private static final Logger logger = LoggerFactory.getLogger(ArmeriaConfigurationUtil.class);
    private static final String[] EMPTY_PROTOCOL_NAMES = new String[0];
    private static final Pattern DATA_SIZE_PATTERN = Pattern.compile("^([+]?\\d+)([a-zA-Z]{0,2})$");

    public static void configureServerWithArmeriaSettings(ServerBuilder server, ArmeriaSettings settings, MeterRegistry meterRegistry, List<HealthChecker> healthCheckers, List<HealthCheckServiceConfigurator> healthCheckServiceConfigurators, MeterIdPrefixFunction meterIdPrefixFunction) {
        ArmeriaSettings.Compression compression;
        String healthCheckPath;
        Objects.requireNonNull(server, "server");
        Objects.requireNonNull(settings, "settings");
        Objects.requireNonNull(meterRegistry, "meterRegistry");
        Objects.requireNonNull(healthCheckers, "healthCheckers");
        Objects.requireNonNull(healthCheckServiceConfigurators, "healthCheckServiceConfigurators");
        if (settings.getGracefulShutdownQuietPeriodMillis() >= 0L && settings.getGracefulShutdownTimeoutMillis() >= 0L) {
            server.gracefulShutdownTimeoutMillis(settings.getGracefulShutdownQuietPeriodMillis(), settings.getGracefulShutdownTimeoutMillis());
            logger.debug("Set graceful shutdown timeout: quiet period {} ms, timeout {} ms", (Object)settings.getGracefulShutdownQuietPeriodMillis(), (Object)settings.getGracefulShutdownTimeoutMillis());
        }
        if (!Strings.isNullOrEmpty((String)(healthCheckPath = settings.getHealthCheckPath()))) {
            HealthCheckServiceBuilder builder = HealthCheckService.builder().checkers(healthCheckers);
            healthCheckServiceConfigurators.forEach(configurator -> configurator.configure(builder));
            server.service(healthCheckPath, (HttpService)builder.build());
        } else if (!healthCheckServiceConfigurators.isEmpty()) {
            logger.warn("{}s exist but they are disabled by the empty 'health-check-path' property. configurators: {}", (Object)HealthCheckServiceConfigurator.class.getSimpleName(), healthCheckServiceConfigurators);
        }
        server.meterRegistry(meterRegistry);
        if (settings.isEnableMetrics()) {
            boolean hasDropwizard;
            boolean hasPrometheus;
            boolean addedPrometheusExposition;
            server.decorator(MetricCollectingService.newDecorator((MeterIdPrefixFunction)meterIdPrefixFunction));
            if (!Strings.isNullOrEmpty((String)settings.getMetricsPath()) && !(addedPrometheusExposition = (hasPrometheus = ArmeriaConfigurationUtil.hasAllClasses("io.micrometer.prometheus.PrometheusMeterRegistry", "io.prometheus.client.CollectorRegistry")) ? PrometheusSupport.addExposition(settings, server, meterRegistry) : false) && (hasDropwizard = ArmeriaConfigurationUtil.hasAllClasses("io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry", "com.codahale.metrics.MetricRegistry", "com.codahale.metrics.json.MetricsModule"))) {
                DropwizardSupport.addExposition(settings, server, meterRegistry);
            }
        }
        if (settings.getSsl() != null) {
            ArmeriaConfigurationUtil.configureTls(server, settings.getSsl());
        }
        if ((compression = settings.getCompression()) != null && compression.isEnabled()) {
            int minBytesToForceChunkedAndEncoding = Ints.saturatedCast((long)ArmeriaConfigurationUtil.parseDataSize(compression.getMinResponseSize()));
            server.decorator(ArmeriaConfigurationUtil.contentEncodingDecorator(compression.getMimeTypes(), compression.getExcludedUserAgents(), minBytesToForceChunkedAndEncoding));
        }
    }

    private static boolean hasAllClasses(String ... classNames) {
        for (String className : classNames) {
            try {
                Class.forName(className, false, ArmeriaConfigurationUtil.class.getClassLoader());
            }
            catch (Throwable t) {
                return false;
            }
        }
        return true;
    }

    public static void configureTls(ServerBuilder sb, Ssl ssl) {
        ArmeriaConfigurationUtil.configureTls(sb, ssl, null, null);
    }

    public static void configureTls(ServerBuilder sb, Ssl ssl, @Nullable Supplier<KeyStore> keyStoreSupplier, @Nullable Supplier<KeyStore> trustStoreSupplier) {
        if (!ssl.isEnabled()) {
            return;
        }
        try {
            if (keyStoreSupplier == null && trustStoreSupplier == null && ssl.getKeyStore() == null && ssl.getTrustStore() == null) {
                logger.warn("Configuring TLS with a self-signed certificate because no key or trust store was specified");
                sb.tlsSelfSigned();
                return;
            }
            KeyManagerFactory keyManagerFactory = ArmeriaConfigurationUtil.getKeyManagerFactory(ssl, keyStoreSupplier);
            TrustManagerFactory trustManagerFactory = ArmeriaConfigurationUtil.getTrustManagerFactory(ssl, trustStoreSupplier);
            sb.tls(keyManagerFactory);
            sb.tlsCustomizer(sslContextBuilder -> {
                ClientAuth clientAuth;
                List<String> ciphers;
                List<String> enabledProtocols;
                sslContextBuilder.trustManager(trustManagerFactory);
                SslProvider sslProvider = ssl.getProvider();
                if (sslProvider != null) {
                    sslContextBuilder.sslProvider(sslProvider);
                }
                if ((enabledProtocols = ssl.getEnabledProtocols()) != null) {
                    sslContextBuilder.protocols(enabledProtocols.toArray(EMPTY_PROTOCOL_NAMES));
                }
                if ((ciphers = ssl.getCiphers()) != null) {
                    sslContextBuilder.ciphers((Iterable)ImmutableList.copyOf(ciphers), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
                }
                if ((clientAuth = ssl.getClientAuth()) != null) {
                    sslContextBuilder.clientAuth(clientAuth);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to configure TLS: " + e, e);
        }
    }

    private static KeyManagerFactory getKeyManagerFactory(Ssl ssl, @Nullable Supplier<KeyStore> sslStoreProvider) throws Exception {
        String keyPassword;
        KeyStore store = sslStoreProvider != null ? sslStoreProvider.get() : ArmeriaConfigurationUtil.loadKeyStore(ssl.getKeyStoreType(), ssl.getKeyStore(), ssl.getKeyStorePassword());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (ssl.getKeyAlias() != null) {
            keyManagerFactory = new CustomAliasKeyManagerFactory(keyManagerFactory, ssl.getKeyAlias());
        }
        if ((keyPassword = ssl.getKeyPassword()) == null) {
            keyPassword = ssl.getKeyStorePassword();
        }
        keyManagerFactory.init(store, keyPassword != null ? keyPassword.toCharArray() : null);
        return keyManagerFactory;
    }

    private static TrustManagerFactory getTrustManagerFactory(Ssl ssl, @Nullable Supplier<KeyStore> sslStoreProvider) throws Exception {
        KeyStore store = sslStoreProvider != null ? sslStoreProvider.get() : ArmeriaConfigurationUtil.loadKeyStore(ssl.getTrustStoreType(), ssl.getTrustStore(), ssl.getTrustStorePassword());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(store);
        return trustManagerFactory;
    }

    @Nullable
    private static KeyStore loadKeyStore(@Nullable String type, @Nullable String resource, @Nullable String password) throws IOException, GeneralSecurityException {
        if (resource == null) {
            return null;
        }
        KeyStore store = KeyStore.getInstance((String)MoreObjects.firstNonNull((Object)type, (Object)"JKS"));
        URL url = ResourceUtils.getURL((String)resource);
        store.load(url.openStream(), password != null ? password.toCharArray() : null);
        return store;
    }

    public static Function<? super HttpService, EncodingService> contentEncodingDecorator(@Nullable String[] mimeTypes, @Nullable String[] excludedUserAgents, int minBytesToForceChunkedAndEncoding) {
        Predicate<RequestHeaders> encodableRequestHeadersPredicate;
        Predicate<MediaType> encodableContentTypePredicate;
        if (mimeTypes == null || mimeTypes.length == 0) {
            encodableContentTypePredicate = contentType -> true;
        } else {
            List encodableContentTypes = (List)Arrays.stream(mimeTypes).map(MediaType::parse).collect(ImmutableList.toImmutableList());
            encodableContentTypePredicate = contentType -> encodableContentTypes.stream().anyMatch(arg_0 -> ((MediaType)contentType).is(arg_0));
        }
        if (excludedUserAgents == null || excludedUserAgents.length == 0) {
            encodableRequestHeadersPredicate = headers -> true;
        } else {
            List patterns = (List)Arrays.stream(excludedUserAgents).map(Pattern::compile).collect(ImmutableList.toImmutableList());
            encodableRequestHeadersPredicate = headers -> {
                String userAgent = headers.get((CharSequence)HttpHeaderNames.USER_AGENT, "");
                return patterns.stream().noneMatch(pattern -> pattern.matcher(userAgent).matches());
            };
        }
        return EncodingService.builder().encodableContentTypes(encodableContentTypePredicate).encodableRequestHeaders(encodableRequestHeadersPredicate).minBytesToForceChunkedEncoding(minBytesToForceChunkedAndEncoding).newDecorator();
    }

    public static long parseDataSize(String dataSizeText) {
        long unit;
        Objects.requireNonNull(dataSizeText, "text");
        Matcher matcher = DATA_SIZE_PATTERN.matcher(dataSizeText);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid data size text: %s (expected: %s)", (Object)dataSizeText, (Object)DATA_SIZE_PATTERN);
        String unitText = matcher.group(2);
        if (Strings.isNullOrEmpty((String)unitText)) {
            unit = 1L;
        } else {
            switch (Ascii.toLowerCase((String)unitText)) {
                case "b": {
                    unit = 1L;
                    break;
                }
                case "kb": {
                    unit = 1024L;
                    break;
                }
                case "mb": {
                    unit = 0x100000L;
                    break;
                }
                case "gb": {
                    unit = 0x40000000L;
                    break;
                }
                case "tb": {
                    unit = 0x10000000000L;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid data size text: " + dataSizeText + " (expected: " + DATA_SIZE_PATTERN + ')');
                }
            }
        }
        try {
            long amount = Long.parseLong(matcher.group(1));
            return LongMath.checkedMultiply((long)amount, (long)unit);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid data size text: " + dataSizeText + " (expected: " + DATA_SIZE_PATTERN + ')', e);
        }
    }

    private ArmeriaConfigurationUtil() {
    }
}

