/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={KBArticleImporter.class})
public class KBArticleImporter {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private KBArticleLocalService _kbArticleLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void importKBArticles(JSONArray jsonArray, long scopeGroupId, long userId) throws Exception {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._addKBArticle(jsonArray.getJSONObject(i), userId, serviceContext);
        }
    }

    protected void updatePermissions(long companyId, String name, String primKey, JSONArray jsonArray) throws PortalException {
        if (jsonArray == null) {
            jsonArray = this._jsonFactory.createJSONArray("[{\"actionIds\": [\"VIEW\"], \"roleName\": \"Site Member\",\"scope\": 4}]");
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            int scope = jsonObject.getInt("scope");
            String roleName = jsonObject.getString("roleName");
            Role role = this._roleLocalService.getRole(companyId, roleName);
            Object[] actionIds = new String[]{};
            JSONArray actionIdsJSONArray = jsonObject.getJSONArray("actionIds");
            if (actionIdsJSONArray != null) {
                for (int j = 0; j < actionIdsJSONArray.length(); ++j) {
                    actionIds = (String[])ArrayUtil.append((Object[])actionIds, (Object)actionIdsJSONArray.getString(j));
                }
            }
            this._resourcePermissionLocalService.setResourcePermissions(companyId, name, scope, primKey, role.getRoleId(), (String[])actionIds);
        }
    }

    private void _addKBArticle(JSONObject jsonObject, long userId, ServiceContext serviceContext) throws Exception {
        JSONArray permissionsJSONArray;
        String content = jsonObject.getString("content");
        String title = jsonObject.getString("title");
        String[] sections = new String[]{};
        String[] selectedFileNames = new String[]{};
        long folderClassNameId = this._classNameLocalService.getClassNameId(KBFolderConstants.getClassName());
        KBArticle kbArticle = this._kbArticleLocalService.addKBArticle(null, userId, folderClassNameId, 0L, title, null, content, "", sections, null, null, null, selectedFileNames, serviceContext);
        JSONArray tagsJSONArray = jsonObject.getJSONArray("tags");
        if (tagsJSONArray.length() > 0) {
            String[] assetTagNames = ArrayUtil.toStringArray((JSONArray)tagsJSONArray);
            this._kbArticleLocalService.updateKBArticleAsset(userId, kbArticle, new long[0], assetTagNames, new long[0]);
        }
        if ((permissionsJSONArray = jsonObject.getJSONArray("permissions")) != null && permissionsJSONArray.length() > 0) {
            this.updatePermissions(kbArticle.getCompanyId(), kbArticle.getModelClassName(), String.valueOf(kbArticle.getResourcePrimKey()), permissionsJSONArray);
        } else {
            this.updatePermissions(kbArticle.getCompanyId(), kbArticle.getModelClassName(), String.valueOf(kbArticle.getResourcePrimKey()), null);
        }
    }
}

