/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.commerce.constants.CommerceShipmentConstants;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.service.CommerceShipmentItemLocalService;
import com.liferay.commerce.service.CommerceShipmentLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceShipmentGenerator.class})
public class CommerceShipmentGenerator {
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentGenerator.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceInventoryWarehouseLocalService _commerceInventoryWarehouseLocalService;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceShipmentItemLocalService _commerceShipmentItemLocalService;
    @Reference
    private CommerceShipmentLocalService _commerceShipmentLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    private final Random _random = new Random();
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void generate(long groupId, int shipmentsCount) {
        GenerateShipmentsCallable generateShipmentsCallable = new GenerateShipmentsCallable(groupId, shipmentsCount);
        try {
            TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)generateShipmentsCallable);
        }
        catch (Throwable throwable) {
            _log.error((Object)throwable, throwable);
        }
    }

    private Calendar _convertDateToCalendar(Date date, int days) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = CalendarFactoryUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(6, days);
        return calendar;
    }

    private void _generateCommerceShipment(CommerceOrder commerceOrder, List<CommerceInventoryWarehouse> commerceInventoryWarehouses) throws Exception {
        List commerceOrderItems = this._commerceOrderItemService.getAvailableForShipmentCommerceOrderItems(commerceOrder.getCommerceOrderId());
        if (commerceOrderItems == null) {
            _log.error((Object)("There are no items ready to be shipped for order " + commerceOrder.getCommerceOrderId()));
            return;
        }
        ServiceContext serviceContext = this._getServiceContext(commerceOrder);
        CommerceShipment commerceShipment = this._commerceShipmentLocalService.addCommerceShipment(commerceOrder.getCommerceOrderId(), serviceContext);
        this._generateCommerceShipmentItems(commerceShipment.getCommerceShipmentId(), commerceOrderItems, commerceInventoryWarehouses, serviceContext);
        Calendar shippingDateCalendar = this._convertDateToCalendar(commerceShipment.getShippingDate(), 0);
        Calendar expectedDateCalendar = this._convertDateToCalendar(commerceShipment.getExpectedDate(), this._randomInt(3, 10));
        this._commerceShipmentLocalService.updateCommerceShipment(commerceShipment.getCommerceShipmentId(), commerceShipment.getCommerceShippingMethodId(), commerceShipment.getCarrier(), expectedDateCalendar.get(2), expectedDateCalendar.get(5), expectedDateCalendar.get(1), expectedDateCalendar.get(10), expectedDateCalendar.get(12), shippingDateCalendar.get(2), shippingDateCalendar.get(5), shippingDateCalendar.get(1), shippingDateCalendar.get(10), shippingDateCalendar.get(12), commerceShipment.getTrackingNumber(), commerceShipment.getTrackingURL(), this._getRandomCommerceShipmentStatus(), serviceContext);
    }

    private void _generateCommerceShipmentItems(long commerceShipmentId, List<CommerceOrderItem> commerceOrderItems, List<CommerceInventoryWarehouse> commerceInventoryWarehouses, ServiceContext serviceContext) throws Exception {
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            int quantity;
            CommerceInventoryWarehouse commerceInventoryWarehouse;
            int commerceInventoryWarehouseItemQuantity = this._getRandomCommerceInventoryWarehouseItemQuantity(commerceOrderItem, commerceInventoryWarehouse = this._getRandomCommerceInventoryWarehouse(commerceInventoryWarehouses), quantity = commerceOrderItem.getQuantity() - commerceOrderItem.getShippedQuantity());
            if (commerceInventoryWarehouseItemQuantity <= 0) continue;
            this._commerceShipmentItemLocalService.addCommerceShipmentItem(null, commerceShipmentId, commerceOrderItem.getCommerceOrderItemId(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), commerceInventoryWarehouseItemQuantity, true, serviceContext);
        }
    }

    private void _generateCommerceShipments(long groupId, int shipmentsCount) throws Exception {
        this._setPermissionChecker(groupId);
        List<CommerceInventoryWarehouse> commerceInventoryWarehouses = this._getCommerceInventoryWarehouses(groupId);
        if (commerceInventoryWarehouses.isEmpty()) {
            _log.error((Object)"There are no active warehouses");
            return;
        }
        long commerceChannelGroupId = this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId);
        List commerceOrders = this._commerceOrderService.getCommerceOrders(commerceChannelGroupId, CommerceShipmentConstants.ALLOWED_ORDER_STATUSES, 0, shipmentsCount - 1);
        if (commerceOrders.isEmpty()) {
            _log.error((Object)"There are no commerceOrders ready to be shipped");
            return;
        }
        for (CommerceOrder commerceOrder : commerceOrders) {
            this._generateCommerceShipment(commerceOrder, commerceInventoryWarehouses);
        }
    }

    private List<CommerceInventoryWarehouse> _getCommerceInventoryWarehouses(long groupId) throws Exception {
        Group group = this._groupLocalService.getGroup(groupId);
        return this._commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouses(group.getCompanyId());
    }

    private CommerceInventoryWarehouse _getRandomCommerceInventoryWarehouse(List<CommerceInventoryWarehouse> commerceInventoryWarehouses) {
        return commerceInventoryWarehouses.get(this._randomInt(0, commerceInventoryWarehouses.size() - 1));
    }

    private int _getRandomCommerceInventoryWarehouseItemQuantity(CommerceOrderItem commerceOrderItem, CommerceInventoryWarehouse commerceInventoryWarehouse, int quantity) throws Exception {
        int commerceInventoryWarehouseItemQuantity = this._commerceOrderItemService.getCommerceInventoryWarehouseItemQuantity(commerceOrderItem.getCommerceOrderItemId(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId());
        if (quantity < commerceInventoryWarehouseItemQuantity) {
            commerceInventoryWarehouseItemQuantity = quantity;
        }
        if (commerceInventoryWarehouseItemQuantity <= 0) {
            return commerceInventoryWarehouseItemQuantity;
        }
        return this._randomInt(1, commerceInventoryWarehouseItemQuantity);
    }

    private int _getRandomCommerceShipmentStatus() {
        int i = this._randomInt(0, CommerceShipmentConstants.SHIPMENT_STATUSES.length - 1);
        return CommerceShipmentConstants.SHIPMENT_STATUSES[i];
    }

    private ServiceContext _getServiceContext(CommerceOrder commerceOrder) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(commerceOrder.getCompanyId());
        serviceContext.setScopeGroupId(commerceOrder.getGroupId());
        serviceContext.setUserId(commerceOrder.getUserId());
        return serviceContext;
    }

    private int _randomInt(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("Max value must be greater than or equal to the min value");
        }
        int value = this._random.nextInt();
        int range = max + 1 - min;
        if (range == 0) {
            return value;
        }
        return value % range + min;
    }

    private void _setPermissionChecker(long groupId) throws Exception {
        Group group = this._groupLocalService.getGroup(groupId);
        Company company = this._companyLocalService.getCompanyById(group.getCompanyId());
        Role role = this._roleLocalService.fetchRole(company.getCompanyId(), "Administrator");
        List roleUsers = this._userLocalService.getRoleUsers(role.getRoleId());
        User user = (User)roleUsers.get(0);
        PermissionChecker permissionChecker = this._permissionCheckerFactory.create(user);
        PrincipalThreadLocal.setName((long)user.getUserId());
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
    }

    private class GenerateShipmentsCallable
    implements Callable<Object> {
        private final long _groupId;
        private final int _shipmentsCount;

        @Override
        public Object call() throws Exception {
            CommerceShipmentGenerator.this._generateCommerceShipments(this._groupId, this._shipmentsCount);
            return null;
        }

        private GenerateShipmentsCallable(long groupId, int shipmentsCount) {
            this._groupId = groupId;
            this._shipmentsCount = shipmentsCount;
        }
    }
}

