/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.service.CPAttachmentFileEntryLocalService;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MimeTypes;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CPAttachmentFileEntryCreator.class})
public class CPAttachmentFileEntryCreator {
    private static final Log _log = LogFactoryUtil.getLog(CPAttachmentFileEntryCreator.class);
    @Reference
    private CPAttachmentFileEntryLocalService _cpAttachmentFileEntryLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private MimeTypes _mimeTypes;
    @Reference
    private Portal _portal;
    @Reference
    private RepositoryProvider _repositoryProvider;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public CPAttachmentFileEntry addCPAttachmentFileEntry(ClassedModel classedModel, ClassLoader classLoader, String dependenciesPath, String fileName, double priority, int type, long scopeGroupId, long userId) throws Exception {
        File file;
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        HashMap titleMap = HashMapBuilder.put((Object)serviceContext.getLocale(), (Object)fileName).build();
        InputStream inputStream = null;
        String uriString = dependenciesPath + URLEncoder.encode(fileName, "UTF-8");
        URI uri = new URI(uriString);
        if (StringUtil.equalsIgnoreCase((String)uri.getScheme(), (String)"file")) {
            file = new File(uri.getPath());
            if (file.exists()) {
                inputStream = new FileInputStream(file);
            }
        } else {
            inputStream = classLoader.getResourceAsStream(dependenciesPath + fileName);
        }
        if (inputStream == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("resource not found: " + uri.toString()));
            }
            return null;
        }
        file = null;
        FileEntry fileEntry = null;
        try {
            fileEntry = this._dlAppService.getFileEntry(serviceContext.getScopeGroupId(), 0L, fileName);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchFileEntryException);
            }
            Repository repository = this._repositoryProvider.getRepository(serviceContext.getScopeGroupId());
            file = FileUtil.createTempFile((InputStream)inputStream);
            fileEntry = this._dlAppService.addFileEntry(null, repository.getRepositoryId(), 0L, fileName, this._mimeTypes.getContentType(file), fileName, null, null, null, file, null, null, serviceContext);
        }
        finally {
            if (file != null) {
                FileUtil.delete((File)file);
            }
            inputStream.close();
        }
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        displayCalendar.add(1, -1);
        int displayDateMonth = displayCalendar.get(2);
        int displayDateDay = displayCalendar.get(5);
        int displayDateYear = displayCalendar.get(1);
        int displayDateHour = displayCalendar.get(10);
        int displayDateMinute = displayCalendar.get(12);
        int displayDateAmPm = displayCalendar.get(9);
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        expirationCalendar.add(2, 1);
        int expirationDateMonth = expirationCalendar.get(2);
        int expirationDateDay = expirationCalendar.get(5);
        int expirationDateYear = expirationCalendar.get(1);
        int expirationDateHour = expirationCalendar.get(10);
        int expirationDateMinute = expirationCalendar.get(12);
        int expirationDateAmPm = expirationCalendar.get(9);
        if (expirationDateAmPm == 1) {
            expirationDateHour += 12;
        }
        long classPK = GetterUtil.getLong((Object)classedModel.getPrimaryKeyObj());
        return this._cpAttachmentFileEntryLocalService.addCPAttachmentFileEntry("", serviceContext.getUserId(), fileEntry.getGroupId(), this._portal.getClassNameId(classedModel.getModelClass()), classPK, fileEntry.getFileEntryId(), false, null, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, true, (Map)titleMap, null, priority, type, serviceContext);
    }
}

