/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.scim.types.AuthenticationScheme;
import com.langfuse.client.resources.scim.types.BulkConfig;
import com.langfuse.client.resources.scim.types.FilterConfig;
import com.langfuse.client.resources.scim.types.ResourceMeta;
import com.langfuse.client.resources.scim.types.ScimFeatureSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ServiceProviderConfig {
    private final List<String> schemas;
    private final String documentationUri;
    private final ScimFeatureSupport patch;
    private final BulkConfig bulk;
    private final FilterConfig filter;
    private final ScimFeatureSupport changePassword;
    private final ScimFeatureSupport sort;
    private final ScimFeatureSupport etag;
    private final List<AuthenticationScheme> authenticationSchemes;
    private final ResourceMeta meta;
    private final Map<String, Object> additionalProperties;

    private ServiceProviderConfig(List<String> schemas, String documentationUri, ScimFeatureSupport patch, BulkConfig bulk, FilterConfig filter, ScimFeatureSupport changePassword, ScimFeatureSupport sort, ScimFeatureSupport etag, List<AuthenticationScheme> authenticationSchemes, ResourceMeta meta, Map<String, Object> additionalProperties) {
        this.schemas = schemas;
        this.documentationUri = documentationUri;
        this.patch = patch;
        this.bulk = bulk;
        this.filter = filter;
        this.changePassword = changePassword;
        this.sort = sort;
        this.etag = etag;
        this.authenticationSchemes = authenticationSchemes;
        this.meta = meta;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="documentationUri")
    public String getDocumentationUri() {
        return this.documentationUri;
    }

    @JsonProperty(value="patch")
    public ScimFeatureSupport getPatch() {
        return this.patch;
    }

    @JsonProperty(value="bulk")
    public BulkConfig getBulk() {
        return this.bulk;
    }

    @JsonProperty(value="filter")
    public FilterConfig getFilter() {
        return this.filter;
    }

    @JsonProperty(value="changePassword")
    public ScimFeatureSupport getChangePassword() {
        return this.changePassword;
    }

    @JsonProperty(value="sort")
    public ScimFeatureSupport getSort() {
        return this.sort;
    }

    @JsonProperty(value="etag")
    public ScimFeatureSupport getEtag() {
        return this.etag;
    }

    @JsonProperty(value="authenticationSchemes")
    public List<AuthenticationScheme> getAuthenticationSchemes() {
        return this.authenticationSchemes;
    }

    @JsonProperty(value="meta")
    public ResourceMeta getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ServiceProviderConfig && this.equalTo((ServiceProviderConfig)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ServiceProviderConfig other) {
        return this.schemas.equals(other.schemas) && this.documentationUri.equals(other.documentationUri) && this.patch.equals(other.patch) && this.bulk.equals(other.bulk) && this.filter.equals(other.filter) && this.changePassword.equals(other.changePassword) && this.sort.equals(other.sort) && this.etag.equals(other.etag) && this.authenticationSchemes.equals(other.authenticationSchemes) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.documentationUri, this.patch, this.bulk, this.filter, this.changePassword, this.sort, this.etag, this.authenticationSchemes, this.meta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DocumentationUriStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DocumentationUriStage,
    PatchStage,
    BulkStage,
    FilterStage,
    ChangePasswordStage,
    SortStage,
    EtagStage,
    MetaStage,
    _FinalStage {
        private String documentationUri;
        private ScimFeatureSupport patch;
        private BulkConfig bulk;
        private FilterConfig filter;
        private ScimFeatureSupport changePassword;
        private ScimFeatureSupport sort;
        private ScimFeatureSupport etag;
        private ResourceMeta meta;
        private List<AuthenticationScheme> authenticationSchemes = new ArrayList<AuthenticationScheme>();
        private List<String> schemas = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ServiceProviderConfig other) {
            this.schemas(other.getSchemas());
            this.documentationUri(other.getDocumentationUri());
            this.patch(other.getPatch());
            this.bulk(other.getBulk());
            this.filter(other.getFilter());
            this.changePassword(other.getChangePassword());
            this.sort(other.getSort());
            this.etag(other.getEtag());
            this.authenticationSchemes(other.getAuthenticationSchemes());
            this.meta(other.getMeta());
            return this;
        }

        @Override
        @JsonSetter(value="documentationUri")
        public PatchStage documentationUri(@NotNull String documentationUri) {
            this.documentationUri = Objects.requireNonNull(documentationUri, "documentationUri must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="patch")
        public BulkStage patch(@NotNull ScimFeatureSupport patch) {
            this.patch = Objects.requireNonNull(patch, "patch must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="bulk")
        public FilterStage bulk(@NotNull BulkConfig bulk) {
            this.bulk = Objects.requireNonNull(bulk, "bulk must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="filter")
        public ChangePasswordStage filter(@NotNull FilterConfig filter) {
            this.filter = Objects.requireNonNull(filter, "filter must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="changePassword")
        public SortStage changePassword(@NotNull ScimFeatureSupport changePassword) {
            this.changePassword = Objects.requireNonNull(changePassword, "changePassword must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="sort")
        public EtagStage sort(@NotNull ScimFeatureSupport sort) {
            this.sort = Objects.requireNonNull(sort, "sort must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="etag")
        public MetaStage etag(@NotNull ScimFeatureSupport etag) {
            this.etag = Objects.requireNonNull(etag, "etag must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="meta")
        public _FinalStage meta(@NotNull ResourceMeta meta) {
            this.meta = Objects.requireNonNull(meta, "meta must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllAuthenticationSchemes(List<AuthenticationScheme> authenticationSchemes) {
            this.authenticationSchemes.addAll(authenticationSchemes);
            return this;
        }

        @Override
        public _FinalStage addAuthenticationSchemes(AuthenticationScheme authenticationSchemes) {
            this.authenticationSchemes.add(authenticationSchemes);
            return this;
        }

        @Override
        @JsonSetter(value="authenticationSchemes", nulls=Nulls.SKIP)
        public _FinalStage authenticationSchemes(List<AuthenticationScheme> authenticationSchemes) {
            this.authenticationSchemes.clear();
            this.authenticationSchemes.addAll(authenticationSchemes);
            return this;
        }

        @Override
        public _FinalStage addAllSchemas(List<String> schemas) {
            this.schemas.addAll(schemas);
            return this;
        }

        @Override
        public _FinalStage addSchemas(String schemas) {
            this.schemas.add(schemas);
            return this;
        }

        @Override
        @JsonSetter(value="schemas", nulls=Nulls.SKIP)
        public _FinalStage schemas(List<String> schemas) {
            this.schemas.clear();
            this.schemas.addAll(schemas);
            return this;
        }

        @Override
        public ServiceProviderConfig build() {
            return new ServiceProviderConfig(this.schemas, this.documentationUri, this.patch, this.bulk, this.filter, this.changePassword, this.sort, this.etag, this.authenticationSchemes, this.meta, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ServiceProviderConfig build();

        public _FinalStage schemas(List<String> var1);

        public _FinalStage addSchemas(String var1);

        public _FinalStage addAllSchemas(List<String> var1);

        public _FinalStage authenticationSchemes(List<AuthenticationScheme> var1);

        public _FinalStage addAuthenticationSchemes(AuthenticationScheme var1);

        public _FinalStage addAllAuthenticationSchemes(List<AuthenticationScheme> var1);
    }

    public static interface MetaStage {
        public _FinalStage meta(@NotNull ResourceMeta var1);
    }

    public static interface EtagStage {
        public MetaStage etag(@NotNull ScimFeatureSupport var1);
    }

    public static interface SortStage {
        public EtagStage sort(@NotNull ScimFeatureSupport var1);
    }

    public static interface ChangePasswordStage {
        public SortStage changePassword(@NotNull ScimFeatureSupport var1);
    }

    public static interface FilterStage {
        public ChangePasswordStage filter(@NotNull FilterConfig var1);
    }

    public static interface BulkStage {
        public FilterStage bulk(@NotNull BulkConfig var1);
    }

    public static interface PatchStage {
        public BulkStage patch(@NotNull ScimFeatureSupport var1);
    }

    public static interface DocumentationUriStage {
        public PatchStage documentationUri(@NotNull String var1);

        public Builder from(ServiceProviderConfig var1);
    }
}

