/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FilterConfig {
    private final boolean supported;
    private final int maxResults;
    private final Map<String, Object> additionalProperties;

    private FilterConfig(boolean supported, int maxResults, Map<String, Object> additionalProperties) {
        this.supported = supported;
        this.maxResults = maxResults;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="supported")
    public boolean getSupported() {
        return this.supported;
    }

    @JsonProperty(value="maxResults")
    public int getMaxResults() {
        return this.maxResults;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FilterConfig && this.equalTo((FilterConfig)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FilterConfig other) {
        return this.supported == other.supported && this.maxResults == other.maxResults;
    }

    public int hashCode() {
        return Objects.hash(this.supported, this.maxResults);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SupportedStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SupportedStage,
    MaxResultsStage,
    _FinalStage {
        private boolean supported;
        private int maxResults;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(FilterConfig other) {
            this.supported(other.getSupported());
            this.maxResults(other.getMaxResults());
            return this;
        }

        @Override
        @JsonSetter(value="supported")
        public MaxResultsStage supported(boolean supported) {
            this.supported = supported;
            return this;
        }

        @Override
        @JsonSetter(value="maxResults")
        public _FinalStage maxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public FilterConfig build() {
            return new FilterConfig(this.supported, this.maxResults, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public FilterConfig build();
    }

    public static interface MaxResultsStage {
        public _FinalStage maxResults(int var1);
    }

    public static interface SupportedStage {
        public MaxResultsStage supported(boolean var1);

        public Builder from(FilterConfig var1);
    }
}

