/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.prompts.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateTextPromptRequest {
    private final String name;
    private final String prompt;
    private final Optional<Object> config;
    private final Optional<List<String>> labels;
    private final Optional<List<String>> tags;
    private final Optional<String> commitMessage;
    private final Map<String, Object> additionalProperties;

    private CreateTextPromptRequest(String name, String prompt, Optional<Object> config, Optional<List<String>> labels, Optional<List<String>> tags, Optional<String> commitMessage, Map<String, Object> additionalProperties) {
        this.name = name;
        this.prompt = prompt;
        this.config = config;
        this.labels = labels;
        this.tags = tags;
        this.commitMessage = commitMessage;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="prompt")
    public String getPrompt() {
        return this.prompt;
    }

    @JsonProperty(value="config")
    public Optional<Object> getConfig() {
        return this.config;
    }

    @JsonProperty(value="labels")
    public Optional<List<String>> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="tags")
    public Optional<List<String>> getTags() {
        return this.tags;
    }

    @JsonProperty(value="commitMessage")
    public Optional<String> getCommitMessage() {
        return this.commitMessage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateTextPromptRequest && this.equalTo((CreateTextPromptRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateTextPromptRequest other) {
        return this.name.equals(other.name) && this.prompt.equals(other.prompt) && this.config.equals(other.config) && this.labels.equals(other.labels) && this.tags.equals(other.tags) && this.commitMessage.equals(other.commitMessage);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.prompt, this.config, this.labels, this.tags, this.commitMessage);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    PromptStage,
    _FinalStage {
        private String name;
        private String prompt;
        private Optional<String> commitMessage = Optional.empty();
        private Optional<List<String>> tags = Optional.empty();
        private Optional<List<String>> labels = Optional.empty();
        private Optional<Object> config = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateTextPromptRequest other) {
            this.name(other.getName());
            this.prompt(other.getPrompt());
            this.config(other.getConfig());
            this.labels(other.getLabels());
            this.tags(other.getTags());
            this.commitMessage(other.getCommitMessage());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PromptStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="prompt")
        public _FinalStage prompt(@NotNull String prompt) {
            this.prompt = Objects.requireNonNull(prompt, "prompt must not be null");
            return this;
        }

        @Override
        public _FinalStage commitMessage(String commitMessage) {
            this.commitMessage = Optional.ofNullable(commitMessage);
            return this;
        }

        @Override
        @JsonSetter(value="commitMessage", nulls=Nulls.SKIP)
        public _FinalStage commitMessage(Optional<String> commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        @Override
        public _FinalStage tags(List<String> tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @Override
        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public _FinalStage tags(Optional<List<String>> tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public _FinalStage labels(List<String> labels) {
            this.labels = Optional.ofNullable(labels);
            return this;
        }

        @Override
        @JsonSetter(value="labels", nulls=Nulls.SKIP)
        public _FinalStage labels(Optional<List<String>> labels) {
            this.labels = labels;
            return this;
        }

        @Override
        public _FinalStage config(Object config) {
            this.config = Optional.ofNullable(config);
            return this;
        }

        @Override
        @JsonSetter(value="config", nulls=Nulls.SKIP)
        public _FinalStage config(Optional<Object> config) {
            this.config = config;
            return this;
        }

        @Override
        public CreateTextPromptRequest build() {
            return new CreateTextPromptRequest(this.name, this.prompt, this.config, this.labels, this.tags, this.commitMessage, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateTextPromptRequest build();

        public _FinalStage config(Optional<Object> var1);

        public _FinalStage config(Object var1);

        public _FinalStage labels(Optional<List<String>> var1);

        public _FinalStage labels(List<String> var1);

        public _FinalStage tags(Optional<List<String>> var1);

        public _FinalStage tags(List<String> var1);

        public _FinalStage commitMessage(Optional<String> var1);

        public _FinalStage commitMessage(String var1);
    }

    public static interface PromptStage {
        public _FinalStage prompt(@NotNull String var1);
    }

    public static interface NameStage {
        public PromptStage name(@NotNull String var1);

        public Builder from(CreateTextPromptRequest var1);
    }
}

