/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.prompts.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.langfuse.client.resources.prompts.types.CreateChatPromptRequest;
import com.langfuse.client.resources.prompts.types.CreateTextPromptRequest;
import java.util.Objects;
import java.util.Optional;

public final class CreatePromptRequest {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private CreatePromptRequest(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static CreatePromptRequest chat(CreateChatPromptRequest value) {
        return new CreatePromptRequest(new ChatValue(value));
    }

    public static CreatePromptRequest text(CreateTextPromptRequest value) {
        return new CreatePromptRequest(new TextValue(value));
    }

    public boolean isChat() {
        return this.value instanceof ChatValue;
    }

    public boolean isText() {
        return this.value instanceof TextValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<CreateChatPromptRequest> getChat() {
        if (this.isChat()) {
            return Optional.of(((ChatValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CreateTextPromptRequest> getText() {
        if (this.isText()) {
            return Optional.of(((TextValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ChatValue.class), @JsonSubTypes.Type(value=TextValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitChat(CreateChatPromptRequest var1);

        public T visitText(CreateTextPromptRequest var1);

        public T _visitUnknown(Object var1);
    }

    @JsonTypeName(value="chat")
    @JsonIgnoreProperties(value={"type"})
    private static final class ChatValue
    implements Value {
        @JsonUnwrapped
        private CreateChatPromptRequest value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ChatValue() {
        }

        private ChatValue(CreateChatPromptRequest value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitChat(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ChatValue && this.equalTo((ChatValue)other);
        }

        private boolean equalTo(ChatValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CreatePromptRequest{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="text")
    @JsonIgnoreProperties(value={"type"})
    private static final class TextValue
    implements Value {
        @JsonUnwrapped
        private CreateTextPromptRequest value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TextValue() {
        }

        private TextValue(CreateTextPromptRequest value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitText(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TextValue && this.equalTo((TextValue)other);
        }

        private boolean equalTo(TextValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CreatePromptRequest{value: " + this.value + "}";
        }
    }

    @JsonIgnoreProperties(value={"type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "CreatePromptRequest{type: " + this.type + ", value: " + this.value + "}";
        }
    }
}

