/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.prompts.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ChatMessage {
    private final String role;
    private final String content;
    private final Map<String, Object> additionalProperties;

    private ChatMessage(String role, String content, Map<String, Object> additionalProperties) {
        this.role = role;
        this.content = content;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="role")
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatMessage && this.equalTo((ChatMessage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatMessage other) {
        return this.role.equals(other.role) && this.content.equals(other.content);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.content);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RoleStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RoleStage,
    ContentStage,
    _FinalStage {
        private String role;
        private String content;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ChatMessage other) {
            this.role(other.getRole());
            this.content(other.getContent());
            return this;
        }

        @Override
        @JsonSetter(value="role")
        public ContentStage role(@NotNull String role) {
            this.role = Objects.requireNonNull(role, "role must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="content")
        public _FinalStage content(@NotNull String content) {
            this.content = Objects.requireNonNull(content, "content must not be null");
            return this;
        }

        @Override
        public ChatMessage build() {
            return new ChatMessage(this.role, this.content, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ChatMessage build();
    }

    public static interface ContentStage {
        public _FinalStage content(@NotNull String var1);
    }

    public static interface RoleStage {
        public ContentStage role(@NotNull String var1);

        public Builder from(ChatMessage var1);
    }
}

