/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.projects.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ApiKeyResponse {
    private final String id;
    private final OffsetDateTime createdAt;
    private final String publicKey;
    private final String secretKey;
    private final String displaySecretKey;
    private final Optional<String> note;
    private final Map<String, Object> additionalProperties;

    private ApiKeyResponse(String id, OffsetDateTime createdAt, String publicKey, String secretKey, String displaySecretKey, Optional<String> note, Map<String, Object> additionalProperties) {
        this.id = id;
        this.createdAt = createdAt;
        this.publicKey = publicKey;
        this.secretKey = secretKey;
        this.displaySecretKey = displaySecretKey;
        this.note = note;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="publicKey")
    public String getPublicKey() {
        return this.publicKey;
    }

    @JsonProperty(value="secretKey")
    public String getSecretKey() {
        return this.secretKey;
    }

    @JsonProperty(value="displaySecretKey")
    public String getDisplaySecretKey() {
        return this.displaySecretKey;
    }

    @JsonProperty(value="note")
    public Optional<String> getNote() {
        return this.note;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ApiKeyResponse && this.equalTo((ApiKeyResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ApiKeyResponse other) {
        return this.id.equals(other.id) && this.createdAt.equals(other.createdAt) && this.publicKey.equals(other.publicKey) && this.secretKey.equals(other.secretKey) && this.displaySecretKey.equals(other.displaySecretKey) && this.note.equals(other.note);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.publicKey, this.secretKey, this.displaySecretKey, this.note);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    CreatedAtStage,
    PublicKeyStage,
    SecretKeyStage,
    DisplaySecretKeyStage,
    _FinalStage {
        private String id;
        private OffsetDateTime createdAt;
        private String publicKey;
        private String secretKey;
        private String displaySecretKey;
        private Optional<String> note = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ApiKeyResponse other) {
            this.id(other.getId());
            this.createdAt(other.getCreatedAt());
            this.publicKey(other.getPublicKey());
            this.secretKey(other.getSecretKey());
            this.displaySecretKey(other.getDisplaySecretKey());
            this.note(other.getNote());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public CreatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="createdAt")
        public PublicKeyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="publicKey")
        public SecretKeyStage publicKey(@NotNull String publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="secretKey")
        public DisplaySecretKeyStage secretKey(@NotNull String secretKey) {
            this.secretKey = Objects.requireNonNull(secretKey, "secretKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="displaySecretKey")
        public _FinalStage displaySecretKey(@NotNull String displaySecretKey) {
            this.displaySecretKey = Objects.requireNonNull(displaySecretKey, "displaySecretKey must not be null");
            return this;
        }

        @Override
        public _FinalStage note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        @Override
        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public _FinalStage note(Optional<String> note) {
            this.note = note;
            return this;
        }

        @Override
        public ApiKeyResponse build() {
            return new ApiKeyResponse(this.id, this.createdAt, this.publicKey, this.secretKey, this.displaySecretKey, this.note, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ApiKeyResponse build();

        public _FinalStage note(Optional<String> var1);

        public _FinalStage note(String var1);
    }

    public static interface DisplaySecretKeyStage {
        public _FinalStage displaySecretKey(@NotNull String var1);
    }

    public static interface SecretKeyStage {
        public DisplaySecretKeyStage secretKey(@NotNull String var1);
    }

    public static interface PublicKeyStage {
        public SecretKeyStage publicKey(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public PublicKeyStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface IdStage {
        public CreatedAtStage id(@NotNull String var1);

        public Builder from(ApiKeyResponse var1);
    }
}

