/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.observations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetObservationsRequest {
    private final Optional<Integer> page;
    private final Optional<Integer> limit;
    private final Optional<String> name;
    private final Optional<String> userId;
    private final Optional<String> type;
    private final Optional<String> traceId;
    private final Optional<String> parentObservationId;
    private final Optional<String> environment;
    private final Optional<OffsetDateTime> fromStartTime;
    private final Optional<OffsetDateTime> toStartTime;
    private final Optional<String> version;
    private final Map<String, Object> additionalProperties;

    private GetObservationsRequest(Optional<Integer> page, Optional<Integer> limit, Optional<String> name, Optional<String> userId, Optional<String> type, Optional<String> traceId, Optional<String> parentObservationId, Optional<String> environment, Optional<OffsetDateTime> fromStartTime, Optional<OffsetDateTime> toStartTime, Optional<String> version, Map<String, Object> additionalProperties) {
        this.page = page;
        this.limit = limit;
        this.name = name;
        this.userId = userId;
        this.type = type;
        this.traceId = traceId;
        this.parentObservationId = parentObservationId;
        this.environment = environment;
        this.fromStartTime = fromStartTime;
        this.toStartTime = toStartTime;
        this.version = version;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="page")
    public Optional<Integer> getPage() {
        return this.page;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="userId")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="traceId")
    public Optional<String> getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="parentObservationId")
    public Optional<String> getParentObservationId() {
        return this.parentObservationId;
    }

    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="fromStartTime")
    public Optional<OffsetDateTime> getFromStartTime() {
        return this.fromStartTime;
    }

    @JsonProperty(value="toStartTime")
    public Optional<OffsetDateTime> getToStartTime() {
        return this.toStartTime;
    }

    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return this.version;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetObservationsRequest && this.equalTo((GetObservationsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetObservationsRequest other) {
        return this.page.equals(other.page) && this.limit.equals(other.limit) && this.name.equals(other.name) && this.userId.equals(other.userId) && this.type.equals(other.type) && this.traceId.equals(other.traceId) && this.parentObservationId.equals(other.parentObservationId) && this.environment.equals(other.environment) && this.fromStartTime.equals(other.fromStartTime) && this.toStartTime.equals(other.toStartTime) && this.version.equals(other.version);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.limit, this.name, this.userId, this.type, this.traceId, this.parentObservationId, this.environment, this.fromStartTime, this.toStartTime, this.version);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> page = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> userId = Optional.empty();
        private Optional<String> type = Optional.empty();
        private Optional<String> traceId = Optional.empty();
        private Optional<String> parentObservationId = Optional.empty();
        private Optional<String> environment = Optional.empty();
        private Optional<OffsetDateTime> fromStartTime = Optional.empty();
        private Optional<OffsetDateTime> toStartTime = Optional.empty();
        private Optional<String> version = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetObservationsRequest other) {
            this.page(other.getPage());
            this.limit(other.getLimit());
            this.name(other.getName());
            this.userId(other.getUserId());
            this.type(other.getType());
            this.traceId(other.getTraceId());
            this.parentObservationId(other.getParentObservationId());
            this.environment(other.getEnvironment());
            this.fromStartTime(other.getFromStartTime());
            this.toStartTime(other.getToStartTime());
            this.version(other.getVersion());
            return this;
        }

        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="userId", nulls=Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="traceId", nulls=Nulls.SKIP)
        public Builder traceId(Optional<String> traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder traceId(String traceId) {
            this.traceId = Optional.ofNullable(traceId);
            return this;
        }

        @JsonSetter(value="parentObservationId", nulls=Nulls.SKIP)
        public Builder parentObservationId(Optional<String> parentObservationId) {
            this.parentObservationId = parentObservationId;
            return this;
        }

        public Builder parentObservationId(String parentObservationId) {
            this.parentObservationId = Optional.ofNullable(parentObservationId);
            return this;
        }

        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public Builder environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        @JsonSetter(value="fromStartTime", nulls=Nulls.SKIP)
        public Builder fromStartTime(Optional<OffsetDateTime> fromStartTime) {
            this.fromStartTime = fromStartTime;
            return this;
        }

        public Builder fromStartTime(OffsetDateTime fromStartTime) {
            this.fromStartTime = Optional.ofNullable(fromStartTime);
            return this;
        }

        @JsonSetter(value="toStartTime", nulls=Nulls.SKIP)
        public Builder toStartTime(Optional<OffsetDateTime> toStartTime) {
            this.toStartTime = toStartTime;
            return this;
        }

        public Builder toStartTime(OffsetDateTime toStartTime) {
            this.toStartTime = Optional.ofNullable(toStartTime);
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<String> version) {
            this.version = version;
            return this;
        }

        public Builder version(String version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        public GetObservationsRequest build() {
            return new GetObservationsRequest(this.page, this.limit, this.name, this.userId, this.type, this.traceId, this.parentObservationId, this.environment, this.fromStartTime, this.toStartTime, this.version, this.additionalProperties);
        }
    }
}

