/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.MapValue;
import com.langfuse.client.resources.commons.types.ObservationLevel;
import com.langfuse.client.resources.commons.types.Usage;
import com.langfuse.client.resources.ingestion.types.ObservationType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ObservationBody {
    private final Optional<String> id;
    private final Optional<String> traceId;
    private final ObservationType type;
    private final Optional<String> name;
    private final Optional<OffsetDateTime> startTime;
    private final Optional<OffsetDateTime> endTime;
    private final Optional<OffsetDateTime> completionStartTime;
    private final Optional<String> model;
    private final Optional<Map<String, MapValue>> modelParameters;
    private final Optional<Object> input;
    private final Optional<String> version;
    private final Optional<Object> metadata;
    private final Optional<Object> output;
    private final Optional<Usage> usage;
    private final Optional<ObservationLevel> level;
    private final Optional<String> statusMessage;
    private final Optional<String> parentObservationId;
    private final Optional<String> environment;
    private final Map<String, Object> additionalProperties;

    private ObservationBody(Optional<String> id, Optional<String> traceId, ObservationType type, Optional<String> name, Optional<OffsetDateTime> startTime, Optional<OffsetDateTime> endTime, Optional<OffsetDateTime> completionStartTime, Optional<String> model, Optional<Map<String, MapValue>> modelParameters, Optional<Object> input, Optional<String> version, Optional<Object> metadata, Optional<Object> output, Optional<Usage> usage, Optional<ObservationLevel> level, Optional<String> statusMessage, Optional<String> parentObservationId, Optional<String> environment, Map<String, Object> additionalProperties) {
        this.id = id;
        this.traceId = traceId;
        this.type = type;
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
        this.completionStartTime = completionStartTime;
        this.model = model;
        this.modelParameters = modelParameters;
        this.input = input;
        this.version = version;
        this.metadata = metadata;
        this.output = output;
        this.usage = usage;
        this.level = level;
        this.statusMessage = statusMessage;
        this.parentObservationId = parentObservationId;
        this.environment = environment;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="traceId")
    public Optional<String> getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="type")
    public ObservationType getType() {
        return this.type;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="startTime")
    public Optional<OffsetDateTime> getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="endTime")
    public Optional<OffsetDateTime> getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="completionStartTime")
    public Optional<OffsetDateTime> getCompletionStartTime() {
        return this.completionStartTime;
    }

    @JsonProperty(value="model")
    public Optional<String> getModel() {
        return this.model;
    }

    @JsonProperty(value="modelParameters")
    public Optional<Map<String, MapValue>> getModelParameters() {
        return this.modelParameters;
    }

    @JsonProperty(value="input")
    public Optional<Object> getInput() {
        return this.input;
    }

    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return this.version;
    }

    @JsonProperty(value="metadata")
    public Optional<Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="output")
    public Optional<Object> getOutput() {
        return this.output;
    }

    @JsonProperty(value="usage")
    public Optional<Usage> getUsage() {
        return this.usage;
    }

    @JsonProperty(value="level")
    public Optional<ObservationLevel> getLevel() {
        return this.level;
    }

    @JsonProperty(value="statusMessage")
    public Optional<String> getStatusMessage() {
        return this.statusMessage;
    }

    @JsonProperty(value="parentObservationId")
    public Optional<String> getParentObservationId() {
        return this.parentObservationId;
    }

    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ObservationBody && this.equalTo((ObservationBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ObservationBody other) {
        return this.id.equals(other.id) && this.traceId.equals(other.traceId) && this.type.equals((Object)other.type) && this.name.equals(other.name) && this.startTime.equals(other.startTime) && this.endTime.equals(other.endTime) && this.completionStartTime.equals(other.completionStartTime) && this.model.equals(other.model) && this.modelParameters.equals(other.modelParameters) && this.input.equals(other.input) && this.version.equals(other.version) && this.metadata.equals(other.metadata) && this.output.equals(other.output) && this.usage.equals(other.usage) && this.level.equals(other.level) && this.statusMessage.equals(other.statusMessage) && this.parentObservationId.equals(other.parentObservationId) && this.environment.equals(other.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.traceId, this.type, this.name, this.startTime, this.endTime, this.completionStartTime, this.model, this.modelParameters, this.input, this.version, this.metadata, this.output, this.usage, this.level, this.statusMessage, this.parentObservationId, this.environment});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    _FinalStage {
        private ObservationType type;
        private Optional<String> environment = Optional.empty();
        private Optional<String> parentObservationId = Optional.empty();
        private Optional<String> statusMessage = Optional.empty();
        private Optional<ObservationLevel> level = Optional.empty();
        private Optional<Usage> usage = Optional.empty();
        private Optional<Object> output = Optional.empty();
        private Optional<Object> metadata = Optional.empty();
        private Optional<String> version = Optional.empty();
        private Optional<Object> input = Optional.empty();
        private Optional<Map<String, MapValue>> modelParameters = Optional.empty();
        private Optional<String> model = Optional.empty();
        private Optional<OffsetDateTime> completionStartTime = Optional.empty();
        private Optional<OffsetDateTime> endTime = Optional.empty();
        private Optional<OffsetDateTime> startTime = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> traceId = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ObservationBody other) {
            this.id(other.getId());
            this.traceId(other.getTraceId());
            this.type(other.getType());
            this.name(other.getName());
            this.startTime(other.getStartTime());
            this.endTime(other.getEndTime());
            this.completionStartTime(other.getCompletionStartTime());
            this.model(other.getModel());
            this.modelParameters(other.getModelParameters());
            this.input(other.getInput());
            this.version(other.getVersion());
            this.metadata(other.getMetadata());
            this.output(other.getOutput());
            this.usage(other.getUsage());
            this.level(other.getLevel());
            this.statusMessage(other.getStatusMessage());
            this.parentObservationId(other.getParentObservationId());
            this.environment(other.getEnvironment());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public _FinalStage type(@NotNull ObservationType type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        public _FinalStage environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        @Override
        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public _FinalStage environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public _FinalStage parentObservationId(String parentObservationId) {
            this.parentObservationId = Optional.ofNullable(parentObservationId);
            return this;
        }

        @Override
        @JsonSetter(value="parentObservationId", nulls=Nulls.SKIP)
        public _FinalStage parentObservationId(Optional<String> parentObservationId) {
            this.parentObservationId = parentObservationId;
            return this;
        }

        @Override
        public _FinalStage statusMessage(String statusMessage) {
            this.statusMessage = Optional.ofNullable(statusMessage);
            return this;
        }

        @Override
        @JsonSetter(value="statusMessage", nulls=Nulls.SKIP)
        public _FinalStage statusMessage(Optional<String> statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public _FinalStage level(ObservationLevel level) {
            this.level = Optional.ofNullable(level);
            return this;
        }

        @Override
        @JsonSetter(value="level", nulls=Nulls.SKIP)
        public _FinalStage level(Optional<ObservationLevel> level) {
            this.level = level;
            return this;
        }

        @Override
        public _FinalStage usage(Usage usage) {
            this.usage = Optional.ofNullable(usage);
            return this;
        }

        @Override
        @JsonSetter(value="usage", nulls=Nulls.SKIP)
        public _FinalStage usage(Optional<Usage> usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public _FinalStage output(Object output) {
            this.output = Optional.ofNullable(output);
            return this;
        }

        @Override
        @JsonSetter(value="output", nulls=Nulls.SKIP)
        public _FinalStage output(Optional<Object> output) {
            this.output = output;
            return this;
        }

        @Override
        public _FinalStage metadata(Object metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage version(String version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<String> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage input(Object input) {
            this.input = Optional.ofNullable(input);
            return this;
        }

        @Override
        @JsonSetter(value="input", nulls=Nulls.SKIP)
        public _FinalStage input(Optional<Object> input) {
            this.input = input;
            return this;
        }

        @Override
        public _FinalStage modelParameters(Map<String, MapValue> modelParameters) {
            this.modelParameters = Optional.ofNullable(modelParameters);
            return this;
        }

        @Override
        @JsonSetter(value="modelParameters", nulls=Nulls.SKIP)
        public _FinalStage modelParameters(Optional<Map<String, MapValue>> modelParameters) {
            this.modelParameters = modelParameters;
            return this;
        }

        @Override
        public _FinalStage model(String model) {
            this.model = Optional.ofNullable(model);
            return this;
        }

        @Override
        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public _FinalStage model(Optional<String> model) {
            this.model = model;
            return this;
        }

        @Override
        public _FinalStage completionStartTime(OffsetDateTime completionStartTime) {
            this.completionStartTime = Optional.ofNullable(completionStartTime);
            return this;
        }

        @Override
        @JsonSetter(value="completionStartTime", nulls=Nulls.SKIP)
        public _FinalStage completionStartTime(Optional<OffsetDateTime> completionStartTime) {
            this.completionStartTime = completionStartTime;
            return this;
        }

        @Override
        public _FinalStage endTime(OffsetDateTime endTime) {
            this.endTime = Optional.ofNullable(endTime);
            return this;
        }

        @Override
        @JsonSetter(value="endTime", nulls=Nulls.SKIP)
        public _FinalStage endTime(Optional<OffsetDateTime> endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public _FinalStage startTime(OffsetDateTime startTime) {
            this.startTime = Optional.ofNullable(startTime);
            return this;
        }

        @Override
        @JsonSetter(value="startTime", nulls=Nulls.SKIP)
        public _FinalStage startTime(Optional<OffsetDateTime> startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage traceId(String traceId) {
            this.traceId = Optional.ofNullable(traceId);
            return this;
        }

        @Override
        @JsonSetter(value="traceId", nulls=Nulls.SKIP)
        public _FinalStage traceId(Optional<String> traceId) {
            this.traceId = traceId;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public ObservationBody build() {
            return new ObservationBody(this.id, this.traceId, this.type, this.name, this.startTime, this.endTime, this.completionStartTime, this.model, this.modelParameters, this.input, this.version, this.metadata, this.output, this.usage, this.level, this.statusMessage, this.parentObservationId, this.environment, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ObservationBody build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage traceId(Optional<String> var1);

        public _FinalStage traceId(String var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage startTime(Optional<OffsetDateTime> var1);

        public _FinalStage startTime(OffsetDateTime var1);

        public _FinalStage endTime(Optional<OffsetDateTime> var1);

        public _FinalStage endTime(OffsetDateTime var1);

        public _FinalStage completionStartTime(Optional<OffsetDateTime> var1);

        public _FinalStage completionStartTime(OffsetDateTime var1);

        public _FinalStage model(Optional<String> var1);

        public _FinalStage model(String var1);

        public _FinalStage modelParameters(Optional<Map<String, MapValue>> var1);

        public _FinalStage modelParameters(Map<String, MapValue> var1);

        public _FinalStage input(Optional<Object> var1);

        public _FinalStage input(Object var1);

        public _FinalStage version(Optional<String> var1);

        public _FinalStage version(String var1);

        public _FinalStage metadata(Optional<Object> var1);

        public _FinalStage metadata(Object var1);

        public _FinalStage output(Optional<Object> var1);

        public _FinalStage output(Object var1);

        public _FinalStage usage(Optional<Usage> var1);

        public _FinalStage usage(Usage var1);

        public _FinalStage level(Optional<ObservationLevel> var1);

        public _FinalStage level(ObservationLevel var1);

        public _FinalStage statusMessage(Optional<String> var1);

        public _FinalStage statusMessage(String var1);

        public _FinalStage parentObservationId(Optional<String> var1);

        public _FinalStage parentObservationId(String var1);

        public _FinalStage environment(Optional<String> var1);

        public _FinalStage environment(String var1);
    }

    public static interface TypeStage {
        public _FinalStage type(@NotNull ObservationType var1);

        public Builder from(ObservationBody var1);
    }
}

