/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.comments.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCommentRequest {
    private final String projectId;
    private final String objectType;
    private final String objectId;
    private final String content;
    private final Optional<String> authorUserId;
    private final Map<String, Object> additionalProperties;

    private CreateCommentRequest(String projectId, String objectType, String objectId, String content, Optional<String> authorUserId, Map<String, Object> additionalProperties) {
        this.projectId = projectId;
        this.objectType = objectType;
        this.objectId = objectId;
        this.content = content;
        this.authorUserId = authorUserId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="projectId")
    public String getProjectId() {
        return this.projectId;
    }

    @JsonProperty(value="objectType")
    public String getObjectType() {
        return this.objectType;
    }

    @JsonProperty(value="objectId")
    public String getObjectId() {
        return this.objectId;
    }

    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @JsonProperty(value="authorUserId")
    public Optional<String> getAuthorUserId() {
        return this.authorUserId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCommentRequest && this.equalTo((CreateCommentRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCommentRequest other) {
        return this.projectId.equals(other.projectId) && this.objectType.equals(other.objectType) && this.objectId.equals(other.objectId) && this.content.equals(other.content) && this.authorUserId.equals(other.authorUserId);
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.objectType, this.objectId, this.content, this.authorUserId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ProjectIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ProjectIdStage,
    ObjectTypeStage,
    ObjectIdStage,
    ContentStage,
    _FinalStage {
        private String projectId;
        private String objectType;
        private String objectId;
        private String content;
        private Optional<String> authorUserId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateCommentRequest other) {
            this.projectId(other.getProjectId());
            this.objectType(other.getObjectType());
            this.objectId(other.getObjectId());
            this.content(other.getContent());
            this.authorUserId(other.getAuthorUserId());
            return this;
        }

        @Override
        @JsonSetter(value="projectId")
        public ObjectTypeStage projectId(@NotNull String projectId) {
            this.projectId = Objects.requireNonNull(projectId, "projectId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="objectType")
        public ObjectIdStage objectType(@NotNull String objectType) {
            this.objectType = Objects.requireNonNull(objectType, "objectType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="objectId")
        public ContentStage objectId(@NotNull String objectId) {
            this.objectId = Objects.requireNonNull(objectId, "objectId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="content")
        public _FinalStage content(@NotNull String content) {
            this.content = Objects.requireNonNull(content, "content must not be null");
            return this;
        }

        @Override
        public _FinalStage authorUserId(String authorUserId) {
            this.authorUserId = Optional.ofNullable(authorUserId);
            return this;
        }

        @Override
        @JsonSetter(value="authorUserId", nulls=Nulls.SKIP)
        public _FinalStage authorUserId(Optional<String> authorUserId) {
            this.authorUserId = authorUserId;
            return this;
        }

        @Override
        public CreateCommentRequest build() {
            return new CreateCommentRequest(this.projectId, this.objectType, this.objectId, this.content, this.authorUserId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateCommentRequest build();

        public _FinalStage authorUserId(Optional<String> var1);

        public _FinalStage authorUserId(String var1);
    }

    public static interface ContentStage {
        public _FinalStage content(@NotNull String var1);
    }

    public static interface ObjectIdStage {
        public ContentStage objectId(@NotNull String var1);
    }

    public static interface ObjectTypeStage {
        public ObjectIdStage objectType(@NotNull String var1);
    }

    public static interface ProjectIdStage {
        public ObjectTypeStage projectId(@NotNull String var1);

        public Builder from(CreateCommentRequest var1);
    }
}

