/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.comments;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.langfuse.client.core.ClientOptions;
import com.langfuse.client.core.LangfuseClientApiException;
import com.langfuse.client.core.LangfuseClientException;
import com.langfuse.client.core.MediaTypes;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.core.QueryStringMapper;
import com.langfuse.client.core.RequestOptions;
import com.langfuse.client.resources.comments.requests.GetCommentsRequest;
import com.langfuse.client.resources.comments.types.CreateCommentRequest;
import com.langfuse.client.resources.comments.types.CreateCommentResponse;
import com.langfuse.client.resources.comments.types.GetCommentsResponse;
import com.langfuse.client.resources.commons.errors.AccessDeniedError;
import com.langfuse.client.resources.commons.errors.Error;
import com.langfuse.client.resources.commons.errors.MethodNotAllowedError;
import com.langfuse.client.resources.commons.errors.NotFoundError;
import com.langfuse.client.resources.commons.errors.UnauthorizedError;
import com.langfuse.client.resources.commons.types.Comment;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class CommentsClient {
    protected final ClientOptions clientOptions;

    public CommentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CreateCommentResponse create(CreateCommentRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CreateCommentResponse create(CreateCommentRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/public").addPathSegments("comments").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new LangfuseClientException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CreateCommentResponse createCommentResponse = (CreateCommentResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateCommentResponse.class);
                return createCommentResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new Error(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new AccessDeniedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 405: {
                        throw new MethodNotAllowedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new LangfuseClientException("Network error executing HTTP request", e);
        }
    }

    public GetCommentsResponse get() {
        return this.get(GetCommentsRequest.builder().build());
    }

    public GetCommentsResponse get(GetCommentsRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GetCommentsResponse get(GetCommentsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/public").addPathSegments("comments");
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page", request.getPage().get().toString(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get().toString(), false);
        }
        if (request.getObjectType().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "objectType", request.getObjectType().get(), false);
        }
        if (request.getObjectId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "objectId", request.getObjectId().get(), false);
        }
        if (request.getAuthorUserId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "authorUserId", request.getAuthorUserId().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                GetCommentsResponse getCommentsResponse = (GetCommentsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetCommentsResponse.class);
                return getCommentsResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new Error(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new AccessDeniedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 405: {
                        throw new MethodNotAllowedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new LangfuseClientException("Network error executing HTTP request", e);
        }
    }

    public Comment getById(String commentId) {
        return this.getById(commentId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Comment getById(String commentId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/public").addPathSegments("comments").addPathSegment(commentId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Comment comment = (Comment)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Comment.class);
                return comment;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new Error(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new AccessDeniedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 405: {
                        throw new MethodNotAllowedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new LangfuseClientException("Network error executing HTTP request", e);
        }
    }
}

