/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class RequestOptions {
    private final String xLangfuseSdkName;
    private final String xLangfuseSdkVersion;
    private final String xLangfusePublicKey;
    private final Optional<Integer> timeout;
    private final TimeUnit timeoutTimeUnit;
    private final Map<String, String> headers;
    private final Map<String, Supplier<String>> headerSuppliers;

    private RequestOptions(String xLangfuseSdkName, String xLangfuseSdkVersion, String xLangfusePublicKey, Optional<Integer> timeout, TimeUnit timeoutTimeUnit, Map<String, String> headers, Map<String, Supplier<String>> headerSuppliers) {
        this.xLangfuseSdkName = xLangfuseSdkName;
        this.xLangfuseSdkVersion = xLangfuseSdkVersion;
        this.xLangfusePublicKey = xLangfusePublicKey;
        this.timeout = timeout;
        this.timeoutTimeUnit = timeoutTimeUnit;
        this.headers = headers;
        this.headerSuppliers = headerSuppliers;
    }

    public Optional<Integer> getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutTimeUnit() {
        return this.timeoutTimeUnit;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.xLangfuseSdkName != null) {
            headers.put("X-Langfuse-Sdk-Name", this.xLangfuseSdkName);
        }
        if (this.xLangfuseSdkVersion != null) {
            headers.put("X-Langfuse-Sdk-Version", this.xLangfuseSdkVersion);
        }
        if (this.xLangfusePublicKey != null) {
            headers.put("X-Langfuse-Public-Key", this.xLangfusePublicKey);
        }
        headers.putAll(this.headers);
        this.headerSuppliers.forEach((key, supplier) -> headers.put((String)key, (String)supplier.get()));
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String xLangfuseSdkName = null;
        private String xLangfuseSdkVersion = null;
        private String xLangfusePublicKey = null;
        private Optional<Integer> timeout = Optional.empty();
        private TimeUnit timeoutTimeUnit = TimeUnit.SECONDS;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, Supplier<String>> headerSuppliers = new HashMap<String, Supplier<String>>();

        public Builder xLangfuseSdkName(String xLangfuseSdkName) {
            this.xLangfuseSdkName = xLangfuseSdkName;
            return this;
        }

        public Builder xLangfuseSdkVersion(String xLangfuseSdkVersion) {
            this.xLangfuseSdkVersion = xLangfuseSdkVersion;
            return this;
        }

        public Builder xLangfusePublicKey(String xLangfusePublicKey) {
            this.xLangfusePublicKey = xLangfusePublicKey;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = Optional.of(timeout);
            return this;
        }

        public Builder timeout(Integer timeout, TimeUnit timeoutTimeUnit) {
            this.timeout = Optional.of(timeout);
            this.timeoutTimeUnit = timeoutTimeUnit;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder addHeader(String key, Supplier<String> value) {
            this.headerSuppliers.put(key, value);
            return this;
        }

        public RequestOptions build() {
            return new RequestOptions(this.xLangfuseSdkName, this.xLangfuseSdkVersion, this.xLangfusePublicKey, this.timeout, this.timeoutTimeUnit, this.headers, this.headerSuppliers);
        }
    }
}

