/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client;

import com.langfuse.client.LangfuseClientBuilder;
import com.langfuse.client.core.ClientOptions;
import com.langfuse.client.core.Suppliers;
import com.langfuse.client.resources.annotationqueues.AnnotationQueuesClient;
import com.langfuse.client.resources.comments.CommentsClient;
import com.langfuse.client.resources.datasetitems.DatasetItemsClient;
import com.langfuse.client.resources.datasetrunitems.DatasetRunItemsClient;
import com.langfuse.client.resources.datasets.DatasetsClient;
import com.langfuse.client.resources.health.HealthClient;
import com.langfuse.client.resources.ingestion.IngestionClient;
import com.langfuse.client.resources.media.MediaClient;
import com.langfuse.client.resources.metrics.MetricsClient;
import com.langfuse.client.resources.models.ModelsClient;
import com.langfuse.client.resources.observations.ObservationsClient;
import com.langfuse.client.resources.organizations.OrganizationsClient;
import com.langfuse.client.resources.projects.ProjectsClient;
import com.langfuse.client.resources.prompts.PromptsClient;
import com.langfuse.client.resources.promptversion.PromptVersionClient;
import com.langfuse.client.resources.scim.ScimClient;
import com.langfuse.client.resources.score.ScoreClient;
import com.langfuse.client.resources.scoreconfigs.ScoreConfigsClient;
import com.langfuse.client.resources.scorev2.ScoreV2Client;
import com.langfuse.client.resources.sessions.SessionsClient;
import com.langfuse.client.resources.trace.TraceClient;
import java.util.function.Supplier;

public class LangfuseClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<AnnotationQueuesClient> annotationQueuesClient;
    protected final Supplier<CommentsClient> commentsClient;
    protected final Supplier<DatasetItemsClient> datasetItemsClient;
    protected final Supplier<DatasetRunItemsClient> datasetRunItemsClient;
    protected final Supplier<DatasetsClient> datasetsClient;
    protected final Supplier<HealthClient> healthClient;
    protected final Supplier<IngestionClient> ingestionClient;
    protected final Supplier<MediaClient> mediaClient;
    protected final Supplier<MetricsClient> metricsClient;
    protected final Supplier<ModelsClient> modelsClient;
    protected final Supplier<ObservationsClient> observationsClient;
    protected final Supplier<OrganizationsClient> organizationsClient;
    protected final Supplier<ProjectsClient> projectsClient;
    protected final Supplier<PromptVersionClient> promptVersionClient;
    protected final Supplier<PromptsClient> promptsClient;
    protected final Supplier<ScimClient> scimClient;
    protected final Supplier<ScoreConfigsClient> scoreConfigsClient;
    protected final Supplier<ScoreV2Client> scoreV2Client;
    protected final Supplier<ScoreClient> scoreClient;
    protected final Supplier<SessionsClient> sessionsClient;
    protected final Supplier<TraceClient> traceClient;

    public LangfuseClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.annotationQueuesClient = Suppliers.memoize(() -> new AnnotationQueuesClient(clientOptions));
        this.commentsClient = Suppliers.memoize(() -> new CommentsClient(clientOptions));
        this.datasetItemsClient = Suppliers.memoize(() -> new DatasetItemsClient(clientOptions));
        this.datasetRunItemsClient = Suppliers.memoize(() -> new DatasetRunItemsClient(clientOptions));
        this.datasetsClient = Suppliers.memoize(() -> new DatasetsClient(clientOptions));
        this.healthClient = Suppliers.memoize(() -> new HealthClient(clientOptions));
        this.ingestionClient = Suppliers.memoize(() -> new IngestionClient(clientOptions));
        this.mediaClient = Suppliers.memoize(() -> new MediaClient(clientOptions));
        this.metricsClient = Suppliers.memoize(() -> new MetricsClient(clientOptions));
        this.modelsClient = Suppliers.memoize(() -> new ModelsClient(clientOptions));
        this.observationsClient = Suppliers.memoize(() -> new ObservationsClient(clientOptions));
        this.organizationsClient = Suppliers.memoize(() -> new OrganizationsClient(clientOptions));
        this.projectsClient = Suppliers.memoize(() -> new ProjectsClient(clientOptions));
        this.promptVersionClient = Suppliers.memoize(() -> new PromptVersionClient(clientOptions));
        this.promptsClient = Suppliers.memoize(() -> new PromptsClient(clientOptions));
        this.scimClient = Suppliers.memoize(() -> new ScimClient(clientOptions));
        this.scoreConfigsClient = Suppliers.memoize(() -> new ScoreConfigsClient(clientOptions));
        this.scoreV2Client = Suppliers.memoize(() -> new ScoreV2Client(clientOptions));
        this.scoreClient = Suppliers.memoize(() -> new ScoreClient(clientOptions));
        this.sessionsClient = Suppliers.memoize(() -> new SessionsClient(clientOptions));
        this.traceClient = Suppliers.memoize(() -> new TraceClient(clientOptions));
    }

    public AnnotationQueuesClient annotationQueues() {
        return this.annotationQueuesClient.get();
    }

    public CommentsClient comments() {
        return this.commentsClient.get();
    }

    public DatasetItemsClient datasetItems() {
        return this.datasetItemsClient.get();
    }

    public DatasetRunItemsClient datasetRunItems() {
        return this.datasetRunItemsClient.get();
    }

    public DatasetsClient datasets() {
        return this.datasetsClient.get();
    }

    public HealthClient health() {
        return this.healthClient.get();
    }

    public IngestionClient ingestion() {
        return this.ingestionClient.get();
    }

    public MediaClient media() {
        return this.mediaClient.get();
    }

    public MetricsClient metrics() {
        return this.metricsClient.get();
    }

    public ModelsClient models() {
        return this.modelsClient.get();
    }

    public ObservationsClient observations() {
        return this.observationsClient.get();
    }

    public OrganizationsClient organizations() {
        return this.organizationsClient.get();
    }

    public ProjectsClient projects() {
        return this.projectsClient.get();
    }

    public PromptVersionClient promptVersion() {
        return this.promptVersionClient.get();
    }

    public PromptsClient prompts() {
        return this.promptsClient.get();
    }

    public ScimClient scim() {
        return this.scimClient.get();
    }

    public ScoreConfigsClient scoreConfigs() {
        return this.scoreConfigsClient.get();
    }

    public ScoreV2Client scoreV2() {
        return this.scoreV2Client.get();
    }

    public ScoreClient score() {
        return this.scoreClient.get();
    }

    public SessionsClient sessions() {
        return this.sessionsClient.get();
    }

    public TraceClient trace() {
        return this.traceClient.get();
    }

    public static LangfuseClientBuilder builder() {
        return new LangfuseClientBuilder();
    }
}

